/*
 * Decompiled with CFR 0.152.
 */
package io.konik.carriage.itext;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.AFRelationshipValue;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamper;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.XMPUtils;
import io.konik.harness.AppendParameter;
import io.konik.harness.FileAppender;
import io.konik.harness.exception.InvoiceAppendError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ITextInvoiceAppender
implements FileAppender {
    private static final String MIME_TYPE = "text/xml";
    private static final String ZF_FILE_NAME = "ZUGFeRD-invoice.xml";
    private static final String ZF_NS = "urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#";

    public void append(AppendParameter appendable) {
        try {
            this.appendInvoiceIntern(appendable);
        }
        catch (DocumentException e) {
            throw new InvoiceAppendError("Could not open PD for modification or to close it", (Throwable)e);
        }
        catch (IOException e) {
            throw new InvoiceAppendError("PDF IO Error", (Throwable)e);
        }
        catch (XMPException e) {
            throw new InvoiceAppendError("Error with XMP Extension", (Throwable)e);
        }
    }

    private void appendInvoiceIntern(AppendParameter appendable) throws IOException, DocumentException, XMPException {
        byte[] attachmentFile = ITextInvoiceAppender.convertToByteArray(appendable.attachmentFile());
        PdfReader reader = new PdfReader(appendable.inputPdf());
        PdfAStamper stamper = new PdfAStamper(reader, appendable.resultingPdf(), PdfAConformanceLevel.PDF_A_3B);
        this.appendZfMetadata(stamper, appendable.zugferdConformanceLevel(), appendable.zugferdVersion());
        ITextInvoiceAppender.attachFile(attachmentFile, stamper);
        stamper.close();
        reader.close();
    }

    private static void attachFile(byte[] attachmentFile, PdfAStamper stamper) throws IOException {
        PdfDictionary embeddedFileParams = new PdfDictionary();
        embeddedFileParams.put(PdfName.PARAMS, (PdfObject)new PdfName(ZF_FILE_NAME));
        embeddedFileParams.put(PdfName.MODDATE, (PdfObject)new PdfDate());
        PdfFileSpecification fs = PdfFileSpecification.fileEmbedded((PdfWriter)stamper.getWriter(), null, (String)ZF_FILE_NAME, (byte[])attachmentFile, (String)MIME_TYPE, (PdfDictionary)embeddedFileParams, (int)0);
        fs.put(PdfName.AFRELATIONSHIP, (PdfObject)AFRelationshipValue.Alternative);
        stamper.addFileAttachment(ZF_FILE_NAME, fs);
        PdfArray array = new PdfArray();
        array.add((PdfObject)fs.getReference());
        stamper.getWriter().getExtraCatalog().put(new PdfName("AF"), (PdfObject)array);
    }

    private void appendZfMetadata(PdfAStamper stamper, String conformanceLevel, String zfVersion) throws XMPException {
        stamper.createXmpMetadata();
        XmpWriter xmpWriter = stamper.getXmpWriter();
        XMPMeta xmpMeta = xmpWriter.getXmpMeta();
        InputStream zfExtensionIs = this.getClass().getResourceAsStream("/zf_extension.xmp");
        XMPMeta zfExtensionMetadata = XMPMetaFactory.parse((InputStream)zfExtensionIs);
        XMPUtils.appendProperties((XMPMeta)zfExtensionMetadata, (XMPMeta)xmpMeta, (boolean)true, (boolean)false);
        xmpWriter.setProperty(ZF_NS, "ConformanceLevel", (Object)conformanceLevel);
        xmpWriter.setProperty(ZF_NS, "Version", (Object)zfVersion);
    }

    private static byte[] convertToByteArray(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            is.close();
            baos.close();
        }
        catch (IOException e) {
            throw new InvoiceAppendError("Was not possible to read Invoice Content stream", (Throwable)e);
        }
        return baos.toByteArray();
    }
}

