/*
 * Decompiled with CFR 0.152.
 */
package io.konik.carriage.itext;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import io.konik.harness.FileExtractor;
import io.konik.harness.exception.InvoiceExtractionError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ITextInvoiceExtractor
implements FileExtractor {
    private static final PdfName AF = new PdfName("AF");

    public byte[] extract(InputStream pdfInput) {
        PdfReader reader = ITextInvoiceExtractor.getPdfReader(pdfInput);
        PdfArray af = ITextInvoiceExtractor.getValidAf(reader.getCatalog());
        PdfDictionary fileSpec = ITextInvoiceExtractor.getValidFileSpec(af);
        PdfDictionary ef = ITextInvoiceExtractor.getValidEf(fileSpec);
        return ITextInvoiceExtractor.getFStream(ef);
    }

    public InputStream extractToStream(InputStream pdfInput) {
        return new ByteArrayInputStream(this.extract(pdfInput));
    }

    private static PdfReader getPdfReader(InputStream pdfStream) {
        try {
            return new PdfReader(pdfStream);
        }
        catch (IOException e) {
            throw new InvoiceExtractionError("Could not read or open pdf.", (Throwable)e);
        }
    }

    private static PdfArray getValidAf(PdfDictionary catalog) {
        PdfArray af;
        if (catalog.contains(AF) && !(af = catalog.getAsArray(AF)).isEmpty() && af.getDirectObject(0).isDictionary()) {
            return af;
        }
        throw new InvoiceExtractionError("Pdf catalog does not contain Valid AF Entry");
    }

    private static PdfDictionary getValidFileSpec(PdfArray af) {
        if (af.isEmpty() || af.getAsDict(0) == null) {
            throw new InvoiceExtractionError("Pdf does not contain a FileSpec Entry");
        }
        return af.getAsDict(0);
    }

    private static PdfDictionary getValidEf(PdfDictionary fileSpec) {
        if (fileSpec.contains(PdfName.EF)) {
            return fileSpec.getAsDict(PdfName.EF);
        }
        throw new InvoiceExtractionError("Pdf catalog does not contain Valid EF Entry");
    }

    private static byte[] getFStream(PdfDictionary ef) {
        if (ef.contains(PdfName.F)) {
            PdfStream xmlStream = ef.getAsStream(PdfName.F);
            try {
                return PdfReader.getStreamBytes((PRStream)((PRStream)xmlStream));
            }
            catch (IOException e) {
                throw new InvoiceExtractionError("Could not extrac xml content form pdf.", (Throwable)e);
            }
        }
        throw new InvoiceExtractionError("Pdf catalog does not contain Valid F Entry");
    }
}

