/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.cryptalgs;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PBKDF2 {
    public static byte[] deriveKey(byte[] salt, long nof_iterations, byte[] pass, int dkLen, String algname) {
        try {
            SecretKeySpec keyspec = new SecretKeySpec(pass, algname);
            Mac mac = Mac.getInstance(algname);
            mac.init(keyspec);
            int hLen = mac.getMacLength();
            byte[] dk = new byte[dkLen];
            int l = (dkLen - 1) / hLen + 1;
            int r = dkLen - (l - 1) * hLen;
            byte[] t = new byte[hLen];
            for (long i = 0L; i < (long)l; ++i) {
                Arrays.fill(t, (byte)0);
                byte[] u = new byte[salt.length + 4];
                System.arraycopy(salt, 0, u, 0, salt.length);
                u[salt.length + 0] = (byte)(i + 1L >> 24 & 0xFFL);
                u[salt.length + 1] = (byte)(i + 1L >> 16 & 0xFFL);
                u[salt.length + 2] = (byte)(i + 1L >> 8 & 0xFFL);
                u[salt.length + 3] = (byte)(i + 1L >> 0 & 0xFFL);
                int j = 0;
                while ((long)j < nof_iterations) {
                    u = mac.doFinal(u);
                    for (int k = 0; k < t.length; ++k) {
                        int n = k;
                        t[n] = (byte)(t[n] ^ u[k]);
                    }
                    ++j;
                }
                System.arraycopy(t, 0, dk, (int)(i * (long)hLen), i != (long)(l - 1) ? hLen : r);
            }
            return dk;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] paddingRFC1423(byte[] input) {
        int len = input.length;
        int newlen = (len >> 3) + 1 << 3;
        byte diff = (byte)(newlen - len);
        byte[] output = new byte[newlen];
        System.arraycopy(input, 0, output, 0, len);
        for (int i = len; i < newlen; ++i) {
            output[i] = diff;
        }
        return output;
    }
}

