/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVDauerList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "DauerList";
    }

    public GVDauerList(HBCIHandler handler) {
        super(handler, GVDauerList.getLowlevelName(), new GVRDauerList());
        this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
        this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
        this.addConstraint("my.number", "KTV.number", null, 2);
        this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
        this.addConstraint("orderid", "orderid", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String usage;
        Properties result = msgstatus.getData();
        GVRDauerList.Dauer entry = new GVRDauerList.Dauer();
        entry.my = new Konto();
        entry.my.country = result.getProperty(header + ".My.KIK.country");
        entry.my.blz = result.getProperty(header + ".My.KIK.blz");
        entry.my.number = result.getProperty(header + ".My.number");
        entry.my.subnumber = result.getProperty(header + ".My.subnumber");
        this.getMainPassport().fillAccountInfo(entry.my);
        entry.other = new Konto();
        entry.other.country = result.getProperty(header + ".Other.KIK.country");
        entry.other.blz = result.getProperty(header + ".Other.KIK.blz");
        entry.other.number = result.getProperty(header + ".Other.number");
        entry.other.subnumber = result.getProperty(header + ".Other.subnumber");
        entry.other.name = result.getProperty(header + ".name");
        entry.other.name2 = result.getProperty(header + ".name2");
        entry.value = new Value(result.getProperty(header + ".BTG.value"), result.getProperty(header + ".BTG.curr"));
        entry.key = result.getProperty(header + ".key");
        entry.addkey = result.getProperty(header + ".addkey");
        int i = 0;
        while ((usage = result.getProperty(header + ".usage." + HBCIUtilsInternal.withCounter("usage", i))) != null) {
            entry.addUsage(usage);
            ++i;
        }
        String st = result.getProperty(header + ".date");
        if (st != null) {
            entry.nextdate = HBCIUtils.string2DateISO(st);
        }
        entry.orderid = result.getProperty(header + ".orderid");
        entry.firstdate = HBCIUtils.string2DateISO(result.getProperty(header + ".DauerDetails.firstdate"));
        entry.timeunit = result.getProperty(header + ".DauerDetails.timeunit");
        entry.turnus = Integer.parseInt(result.getProperty(header + ".DauerDetails.turnus"));
        entry.execday = Integer.parseInt(result.getProperty(header + ".DauerDetails.execday"));
        st = result.getProperty(header + ".DauerDetails.lastdate");
        if (st != null) {
            entry.lastdate = HBCIUtils.string2DateISO(st);
        }
        boolean bl = entry.aus_available = result.getProperty(header + ".Aussetzung.annual") != null;
        if (entry.aus_available) {
            entry.aus_annual = result.getProperty(header + ".Aussetzung.annual").equals("J");
            st = result.getProperty(header + ".Aussetzung.startdate");
            if (st != null) {
                entry.aus_start = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.getProperty(header + ".Aussetzung.enddate")) != null) {
                entry.aus_end = HBCIUtils.string2DateISO(st);
            }
            entry.aus_breakcount = result.getProperty(header + ".Aussetzung.number");
            st = result.getProperty(header + ".Aussetzung.newvalue.value");
            if (st != null) {
                entry.aus_newvalue = new Value(st, result.getProperty(header + ".Aussetzung.newvalue.curr"));
            }
        }
        ((GVRDauerList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            Properties p2 = new Properties();
            Enumeration<?> e = result.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(header + ".") || key.startsWith(header + ".SegHead.") || key.endsWith(".orderid")) continue;
                p2.setProperty(key.substring(header.length() + 1), result.getProperty(key));
            }
            this.getMainPassport().setPersistentData("dauer_" + entry.orderid, p2);
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

