/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRDauerNew;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class GVDauerNew
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "DauerNew";
    }

    public GVDauerNew(HBCIHandler handler) {
        super(handler, GVDauerNew.getLowlevelName(), new GVRDauerNew());
        this.addConstraint("src.number", "My.number", null, 2);
        this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        this.addConstraint("dst.blz", "Other.KIK.blz", null, 3);
        this.addConstraint("dst.number", "Other.number", null, 2);
        this.addConstraint("dst.subnumber", "Other.subnumber", "", 3);
        this.addConstraint("btg.value", "BTG.value", null, 3);
        this.addConstraint("btg.curr", "BTG.curr", null, 0);
        this.addConstraint("name", "name", null, 2);
        this.addConstraint("firstdate", "DauerDetails.firstdate", null, 0);
        this.addConstraint("timeunit", "DauerDetails.timeunit", null, 0);
        this.addConstraint("turnus", "DauerDetails.turnus", null, 0);
        this.addConstraint("execday", "DauerDetails.execday", null, 0);
        this.addConstraint("src.blz", "My.KIK.blz", null, 3);
        this.addConstraint("src.country", "My.KIK.country", "DE", 0);
        this.addConstraint("dst.country", "Other.KIK.country", "DE", 0);
        this.addConstraint("name2", "name2", "", 2);
        this.addConstraint("lastdate", "DauerDetails.lastdate", "", 0);
        this.addConstraint("key", "key", "52", 0);
        Properties parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.getProperty("maxusage"));
        for (int i = 0; i < maxusage; ++i) {
            String name = HBCIUtilsInternal.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "", 3);
        }
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String orderid = result.getProperty(header + ".orderid");
        ((GVRDauerNew)this.jobResult).setOrderId(orderid);
        if (orderid != null && orderid.length() != 0) {
            Properties p = this.getLowlevelParams();
            Properties p2 = new Properties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                p2.setProperty(key.substring(key.indexOf(".") + 1), p.getProperty(key));
            }
            this.getMainPassport().setPersistentData("dauer_" + orderid, p2);
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        Properties res = this.getJobRestrictions();
        if (paramName.equals("timeunit")) {
            if (!value.equals("W") && !value.equals("M")) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_TIMEUNIT", value);
                if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                    throw new InvalidUserDataException(msg);
                }
            }
        } else if (paramName.equals("turnus")) {
            String timeunit = this.getLowlevelParams().getProperty(this.getName() + ".DauerDetails.timeunit");
            if (timeunit != null) {
                String st;
                if (timeunit.equals("W")) {
                    String st2 = res.getProperty("turnusweeks");
                    if (st2 != null) {
                        String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                        if (!st2.equals("00") && !this.twoDigitValueInList(value2, st2)) {
                            String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_TURNUS", value);
                            if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                                throw new InvalidUserDataException(msg);
                            }
                        }
                    }
                } else if (timeunit.equals("M") && (st = res.getProperty("turnusmonths")) != null) {
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                        String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_TURNUS", value);
                        if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                            throw new InvalidUserDataException(msg);
                        }
                    }
                }
            }
        } else if (paramName.equals("execday")) {
            String timeunit = this.getLowlevelParams().getProperty(this.getName() + ".DauerDetails.timeunit");
            if (timeunit != null) {
                String st;
                if (timeunit.equals("W")) {
                    String st3 = res.getProperty("daysperweek");
                    if (st3 != null && !st3.equals("0") && st3.indexOf(value) == -1) {
                        String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_EXECDAY", value);
                        if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                            throw new InvalidUserDataException(msg);
                        }
                    }
                } else if (timeunit.equals("M") && (st = res.getProperty("dayspermonth")) != null) {
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                        String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_EXECDAY", value);
                        if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                            throw new InvalidUserDataException(msg);
                        }
                    }
                }
            }
        } else if (paramName.equals("key")) {
            String st;
            boolean atLeastOne = false;
            boolean found = false;
            int i = 0;
            while ((st = res.getProperty(HBCIUtilsInternal.withCounter("textkey", i))) != null) {
                atLeastOne = true;
                if (st.equals(value)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (atLeastOne && !found) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_INV_KEY", value);
                if (!HBCIUtilsInternal.ignoreError(this.getMainPassport(), "client.errors.ignoreWrongJobDataErrors", msg)) {
                    throw new InvalidUserDataException(msg);
                }
            }
        }
        super.setParam(paramName, value);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("src");
        this.checkAccountCRC("dst");
    }
}

