/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVKontoauszugPdf
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "KontoauszugPdf";
    }

    public GVKontoauszugPdf(HBCIHandler handler, String name) {
        super(handler, name, new GVRKontoauszug());
    }

    public GVKontoauszugPdf(HBCIHandler handler) {
        this(handler, GVKontoauszugPdf.getLowlevelName());
        this.addConstraint("my.bic", "My.bic", null, 3);
        this.addConstraint("my.iban", "My.iban", null, 2);
        if (this.canNationalAcc(handler)) {
            this.addConstraint("my.country", "My.KIK.country", "DE", 0);
            this.addConstraint("my.blz", "My.KIK.blz", "", 3);
            this.addConstraint("my.number", "My.number", "", 2);
            this.addConstraint("my.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("idx", "idx", "", 0);
        this.addConstraint("year", "year", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
        this.addConstraint("offset", "offset", "", 0);
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String receipt;
        Properties result = msgstatus.getData();
        GVRKontoauszug list = (GVRKontoauszug)this.jobResult;
        GVRKontoauszug.GVRKontoauszugEntry auszug = new GVRKontoauszug.GVRKontoauszugEntry();
        list.getEntries().add(auszug);
        auszug.setFormat(GVRKontoauszug.Format.PDF);
        String start = result.getProperty(header + ".TimeRange.startdate");
        String end = result.getProperty(header + ".TimeRange.enddate");
        String date = result.getProperty(header + ".date");
        String year = result.getProperty(header + ".year");
        String number = result.getProperty(header + ".number");
        if (start != null && start.length() > 0) {
            auszug.setStartDate(HBCIUtils.string2DateISO(start));
        }
        if (end != null && end.length() > 0) {
            auszug.setEndDate(HBCIUtils.string2DateISO(end));
        }
        if (date != null && date.length() > 0) {
            auszug.setDate(HBCIUtils.string2DateISO(date));
        }
        if (year != null && year.length() > 0) {
            auszug.setYear(Integer.parseInt(year));
        }
        if (number != null && number.length() > 0) {
            auszug.setNumber(Integer.parseInt(number));
        }
        auszug.setIBAN(result.getProperty(header + ".iban"));
        auszug.setBIC(result.getProperty(header + ".bic"));
        auszug.setName(result.getProperty(header + ".name"));
        auszug.setName2(result.getProperty(header + ".name2"));
        auszug.setName3(result.getProperty(header + ".name3"));
        auszug.setFilename(result.getProperty(header + ".filename"));
        String data = result.getProperty(header + ".booked");
        if (data != null && data.length() > 0) {
            if (data.startsWith("%PDF-")) {
                try {
                    auszug.setData(data.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException e) {
                    HBCIUtils.log((Exception)e, 2);
                }
            } else {
                auszug.setData(HBCIUtils.decodeBase64(data));
            }
        }
        if ((receipt = result.getProperty(header + ".receipt")) != null) {
            try {
                auszug.setReceipt(receipt.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                HBCIUtils.log((Exception)e, 2);
                auszug.setReceipt(receipt.getBytes());
            }
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

