/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class GVSaldoReq
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "Saldo";
    }

    public GVSaldoReq(HBCIHandler handler, String name) {
        super(handler, name, new GVRSaldoReq());
    }

    public GVSaldoReq(HBCIHandler handler) {
        this(handler, GVSaldoReq.getLowlevelName());
        int version = -1;
        try {
            version = Integer.parseInt(this.getSegVersion());
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
        boolean sepa = version >= 7;
        boolean nat = this.canNationalAcc(handler);
        if (sepa) {
            this.addConstraint("my.bic", "KTV.bic", null, 3);
            this.addConstraint("my.iban", "KTV.iban", null, 2);
        }
        if (version < 5) {
            this.addConstraint("my.curr", "curr", "EUR", 0);
        }
        if (nat || !sepa) {
            this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
            this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
            this.addConstraint("my.number", "KTV.number", null, 2);
            this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
        }
        this.addConstraint("dummyall", "allaccounts", "N", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRSaldoReq.Info info = new GVRSaldoReq.Info();
        info.konto = new Konto();
        info.konto.country = result.getProperty(header + ".KTV.KIK.country");
        info.konto.blz = result.getProperty(header + ".KTV.KIK.blz");
        info.konto.number = result.getProperty(header + ".KTV.number");
        info.konto.subnumber = result.getProperty(header + ".KTV.subnumber");
        info.konto.bic = result.getProperty(header + ".KTV.bic");
        info.konto.iban = result.getProperty(header + ".KTV.iban");
        info.konto.type = result.getProperty(header + ".kontobez");
        info.konto.curr = result.getProperty(header + ".curr");
        this.getMainPassport().fillAccountInfo(info.konto);
        info.ready = new Saldo();
        String cd = result.getProperty(header + ".booked.CreditDebit");
        String st = (cd.equals("D") ? "-" : "") + result.getProperty(header + ".booked.BTG.value", "0");
        info.ready.value = new Value(st, result.getProperty(header + ".booked.BTG.curr"));
        info.ready.timestamp = HBCIUtils.strings2DateTimeISO(result.getProperty(header + ".booked.date"), result.getProperty(header + ".booked.time"));
        cd = result.getProperty(header + ".pending.CreditDebit");
        if (cd != null) {
            st = (cd.equals("D") ? "-" : "") + result.getProperty(header + ".pending.BTG.value", "0");
            info.unready = new Saldo();
            info.unready.value = new Value(st, result.getProperty(header + ".pending.BTG.curr"));
            info.unready.timestamp = HBCIUtils.strings2DateTimeISO(result.getProperty(header + ".pending.date"), result.getProperty(header + ".pending.time"));
        }
        if ((st = result.getProperty(header + ".kredit.value")) != null) {
            info.kredit = new Value(st, result.getProperty(header + ".kredit.curr"));
        }
        if ((st = result.getProperty(header + ".available.value")) != null) {
            info.available = new Value(st, result.getProperty(header + ".available.curr"));
        }
        if ((st = result.getProperty(header + ".used.value")) != null) {
            info.used = new Value(st, result.getProperty(header + ".used.curr"));
        }
        ((GVRSaldoReq)this.jobResult).store(info);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

