/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.dialog.KnownReturncode;
import org.kapott.hbci.dialog.KnownTANProcess;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.tools.StringUtil;

public class GVTAN2Step
extends HBCIJobImpl {
    private GVTAN2Step step2;
    private KnownTANProcess process = null;
    private HBCIJobImpl task;
    private HBCIJobImpl redo;

    public static String getLowlevelName() {
        return "TAN2Step";
    }

    public void setProcess(KnownTANProcess p) {
        this.process = p;
        this.setParam("process", p.getCode());
    }

    public GVTAN2Step(HBCIHandler handler) {
        super(handler, GVTAN2Step.getLowlevelName(), new GVRSaldoReq());
        int version = 5;
        try {
            version = Integer.parseInt(this.getSegVersion());
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
        this.addConstraint("process", "process", null, 0);
        this.addConstraint("ordersegcode", "ordersegcode", "", 0);
        this.addConstraint("orderaccount.bic", "OrderAccount.bic", null, 3);
        this.addConstraint("orderaccount.iban", "OrderAccount.iban", null, 2);
        this.addConstraint("orderaccount.number", "OrderAccount.number", null, 2);
        this.addConstraint("orderaccount.subnumber", "OrderAccount.subnumber", "", 3);
        this.addConstraint("orderaccount.blz", "OrderAccount.KIK.blz", null, 3);
        this.addConstraint("orderaccount.country", "OrderAccount.KIK.country", "DE", 0);
        this.addConstraint("orderhash", "orderhash", "", 0);
        this.addConstraint("orderref", "orderref", "", 0);
        if (version < 6) {
            this.addConstraint("listidx", "listidx", "", 0);
        }
        this.addConstraint("notlasttan", "notlasttan", "", 0);
        if (version <= 1) {
            this.addConstraint("info", "info", "", 0);
        }
        this.addConstraint("storno", "storno", "", 0);
        this.addConstraint("challengeklass", "challengeklass", "", 0);
        this.addConstraint("ChallengeKlassParam1", "ChallengeKlassParams.param1", "", 2);
        this.addConstraint("ChallengeKlassParam2", "ChallengeKlassParams.param2", "", 2);
        this.addConstraint("ChallengeKlassParam3", "ChallengeKlassParams.param3", "", 2);
        this.addConstraint("ChallengeKlassParam4", "ChallengeKlassParams.param4", "", 2);
        this.addConstraint("ChallengeKlassParam5", "ChallengeKlassParams.param5", "", 2);
        this.addConstraint("ChallengeKlassParam6", "ChallengeKlassParams.param6", "", 2);
        this.addConstraint("ChallengeKlassParam7", "ChallengeKlassParams.param7", "", 2);
        this.addConstraint("ChallengeKlassParam8", "ChallengeKlassParams.param8", "", 2);
        this.addConstraint("ChallengeKlassParam9", "ChallengeKlassParams.param9", "", 2);
        this.addConstraint("tanmedia", "tanmedia", "", 2);
        this.addConstraint("HHDUCAnswer", "HHDUCAnswer.atc", "", 2);
        this.addConstraint("HHDUCAnswer", "HHDUCAnswer.appcrypto_ac", "", 2);
        this.addConstraint("HHDUCAnswer", "HHDUCAnswer.ef_id_data", "", 2);
        this.addConstraint("HHDUCAnswer", "HHDUCAnswer.cvr", "", 2);
        this.addConstraint("HHDUCAnswer", "HHDUCAnswer.versioninfo", "", 2);
    }

    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("orderhash")) {
            value = "B" + value;
        }
        super.setParam(paramName, value);
    }

    public void setStep2(GVTAN2Step step2) {
        this.step2 = step2;
    }

    public void setTask(HBCIJobImpl task) {
        this.task = task;
    }

    @Override
    protected void saveReturnValues(HBCIMsgStatus status, int sref) {
        super.saveReturnValues(status, sref);
        if (this.task != null) {
            int orig_segnum = Integer.parseInt(this.task.getJobResult().getSegNum());
            HBCIUtils.log("storing return values in orig task (segnum=" + orig_segnum + ")", 4);
            this.task.saveReturnValues(status, orig_segnum);
        }
    }

    @Override
    public HBCIJobImpl redo() {
        return this.redo;
    }

    @Override
    public boolean haveTan() {
        return true;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String segCode = result.getProperty(header + ".SegHead.code");
        HBCIUtils.log("found HKTAN response with segcode " + segCode, 4);
        if ((this.process == KnownTANProcess.PROCESS2_STEP2 || this.process == KnownTANProcess.PROCESS2_STEPS) && this.task != null) {
            if (StringUtil.toInsCode(this.getHBCICode()).equals(segCode) && KnownReturncode.W3040.searchReturnValue(msgstatus.segStatus.getWarnings()) != null && this.task.redoAllowed()) {
                HBCIUtils.log("found status code 3040, need to repeat task " + this.task.getHBCICode(), 4);
                HBCIUtils.log("Weitere Daten folgen", 3);
                this.redo = this.task;
            }
            if (StringUtil.toInsCode(this.task.getHBCICode()).equals(segCode)) {
                HBCIUtils.log("this is a response segment for the original task (" + this.task.getName() + ") - storing results in the original job", 4);
                this.task.fillJobResultFromTanJob(msgstatus, header, idx);
            }
            return;
        }
        this.redo = null;
        HBCIPassportInternal p = this.getMainPassport();
        if (!(this.process != KnownTANProcess.PROCESS1 && this.process != KnownTANProcess.PROCESS2_STEP1 || KnownReturncode.W3076.searchReturnValue(msgstatus.segStatus.getWarnings()) == null && KnownReturncode.W3076.searchReturnValue(msgstatus.globStatus.getWarnings()) == null)) {
            HBCIUtils.log("found status code 3076, no SCA required", 4);
            p.setPersistentData("__pintan_sca___", "true");
            if (this.step2 != null) {
                this.step2.skip();
            }
            return;
        }
        String challenge = result.getProperty(header + ".challenge");
        if (challenge != null) {
            HBCIUtils.log("found challenge '" + challenge + "' in HITAN - saving it temporarily in passport", 4);
            p.setPersistentData("__pintan_challenge___", challenge);
        }
        p.setPersistentData("externalid", this.getExternalId());
        String hhdUc = result.getProperty(header + ".challenge_hhd_uc");
        if (hhdUc != null) {
            HBCIUtils.log("found Challenge HHDuc '" + hhdUc + "' in HITAN - saving it temporarily in passport", 4);
            p.setPersistentData("__pintan_hhduc___", hhdUc);
        }
        String orderref = result.getProperty(header + ".orderref");
        if (this.step2 != null && orderref != null) {
            HBCIUtils.log("found orderref '" + orderref + "' in HITAN", 4);
            this.step2.setParam("orderref", orderref);
        }
    }
}

