/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRTANMediaList;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTANMediaList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "TANMediaList";
    }

    public GVTANMediaList(HBCIHandler handler) {
        super(handler, GVTANMediaList.getLowlevelName(), new GVRTANMediaList());
        this.addConstraint("mediatype", "mediatype", "0", 0);
        this.addConstraint("mediacategory", "mediacategory", "A", 0);
    }

    @Override
    protected boolean redoAllowed() {
        return true;
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String mediaheader;
        String st;
        Properties result = msgstatus.getData();
        String s = result.getProperty(header + ".tanoption");
        if (s != null) {
            ((GVRTANMediaList)this.jobResult).setTanOption(Integer.parseInt(s));
        }
        StringBuffer mediaNames = new StringBuffer();
        int i = 0;
        while ((st = result.getProperty((mediaheader = HBCIUtilsInternal.withCounter(header + ".MediaInfo", i)) + ".mediacategory")) != null) {
            boolean haveName;
            GVRTANMediaList.TANMediaInfo info = new GVRTANMediaList.TANMediaInfo();
            info.mediaCategory = st;
            info.cardNumber = result.getProperty(mediaheader + ".cardnumber");
            info.cardSeqNumber = result.getProperty(mediaheader + ".cardseqnumber");
            info.mediaName = result.getProperty(mediaheader + ".medianame");
            info.mobileNumber = result.getProperty(mediaheader + ".mobilenumber");
            info.mobileNumberSecure = result.getProperty(mediaheader + ".mobilenumber_secure");
            info.status = result.getProperty(mediaheader + ".status");
            info.tanListNumber = result.getProperty(mediaheader + ".tanlistnumber");
            st = result.getProperty(mediaheader + ".freetans");
            if (st != null) {
                info.freeTans = Integer.parseInt(st);
            }
            if ((st = result.getProperty(mediaheader + ".cardtype")) != null) {
                info.cardType = Integer.parseInt(st);
            }
            if ((st = result.getProperty(mediaheader + ".validfrom")) != null) {
                info.validFrom = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.getProperty(mediaheader + ".validto")) != null) {
                info.validTo = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.getProperty(mediaheader + ".lastuse")) != null) {
                info.lastUse = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.getProperty(mediaheader + ".activatedon")) != null) {
                info.activatedOn = HBCIUtils.string2DateISO(st);
            }
            ((GVRTANMediaList)this.jobResult).add(info);
            boolean isActive = info.status != null && info.status.equals("1");
            boolean bl = haveName = info.mediaName != null && info.mediaName.length() > 0;
            if (isActive && haveName) {
                if (mediaNames.length() != 0) {
                    mediaNames.append("|");
                }
                mediaNames.append(info.mediaName);
            }
            ++i;
        }
        String names = mediaNames.toString();
        if (names.length() > 0) {
            HBCIUtils.log("TAN-Medienbezeichnungen empfangen: " + names, 3);
            HBCIUtils.log("adding TAN media names to UPD: " + names, 4);
            HBCIPassportInternal p = (HBCIPassportInternal)this.getParentHandler().getPassport();
            Properties upd = p.getUPD();
            if (upd == null) {
                upd = new Properties();
                p.setUPD(upd);
            }
            upd.setProperty("tanmedia.names", names);
        }
    }
}

