/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.generators.AbstractSEPAGenerator;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.AccountReport22;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BalanceType10Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BalanceType13;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BankToCustomerAccountReportV07;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BankTransactionCodeStructure4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BranchAndFinancialInstitutionIdentification5;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CashAccount24;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CashAccount36;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CashBalance8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CreditDebitCode;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.DateAndDateTime2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.Document;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.EntryDetails8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.EntryStatus1Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.EntryTransaction9;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.FinancialInstitutionIdentification8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.GroupHeader73;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ObjectFactory;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.Party35Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.PartyIdentification125;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ProprietaryBankTransactionCodeStructure1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ProprietaryReference1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.RemittanceInformation15;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ReportEntry9;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.TransactionAgents4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.TransactionParties4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.TransactionReferences3;
import org.kapott.hbci.structures.Saldo;

public class GenKUmsAllCamt05200107
extends AbstractSEPAGenerator<List<GVRKUms.BTag>> {
    @Override
    public void generate(List<GVRKUms.BTag> source, OutputStream os, boolean validate) throws Exception {
        long now = System.currentTimeMillis();
        Document doc = new Document();
        BankToCustomerAccountReportV07 container = new BankToCustomerAccountReportV07();
        doc.setBkToCstmrAcctRpt(container);
        GroupHeader73 grphdr = new GroupHeader73();
        grphdr.setMsgId(Long.toString(now));
        grphdr.setCreDtTm(this.createCalendar(now));
        container.setGrpHdr(grphdr);
        for (GVRKUms.BTag tag : source) {
            AccountReport22 report = this.createDay(tag);
            report.setId("camt05200107");
            report.setCreDtTm(this.createCalendar(now));
            container.getRpt().add(report);
            List<ReportEntry9> entries = report.getNtry();
            for (GVRKUms.UmsLine line : tag.lines) {
                entries.add(this.createLine(tag, line));
            }
        }
        ObjectFactory of = new ObjectFactory();
        this.marshal(of.createDocument(doc), os, validate);
    }

    private ReportEntry9 createLine(GVRKUms.BTag tag, GVRKUms.UmsLine line) throws Exception {
        String s;
        DateAndDateTime2Choice d;
        FinancialInstitutionIdentification8 bic;
        BranchAndFinancialInstitutionIdentification5 bank;
        PartyIdentification125 pi;
        Party35Choice party;
        AccountIdentification4Choice id;
        CashAccount24 acc;
        ReportEntry9 entry = new ReportEntry9();
        EntryStatus1Choice status = new EntryStatus1Choice();
        status.setCd("BOOK");
        entry.setSts(status);
        EntryDetails8 detail = new EntryDetails8();
        entry.getNtryDtls().add(detail);
        EntryTransaction9 tx = new EntryTransaction9();
        detail.getTxDtls().add(tx);
        boolean haben = line.value != null && line.value.getBigDecimalValue().compareTo(BigDecimal.ZERO) > 0;
        entry.setCdtDbtInd(haben ? CreditDebitCode.CRDT : CreditDebitCode.DBIT);
        TransactionReferences3 ref = new TransactionReferences3();
        tx.setRefs(ref);
        ProprietaryReference1 prt = new ProprietaryReference1();
        prt.setTp("UNKNOWN");
        prt.setRef(line.id);
        ref.getPrtry().add(prt);
        TransactionParties4 other = new TransactionParties4();
        tx.setRltdPties(other);
        TransactionAgents4 banks = new TransactionAgents4();
        tx.setRltdAgts(banks);
        if (tag != null && tag.my != null) {
            acc = new CashAccount24();
            if (haben) {
                other.setCdtrAcct(acc);
            } else {
                other.setDbtrAcct(acc);
            }
            id = new AccountIdentification4Choice();
            acc.setId(id);
            id.setIBAN(tag.my.iban);
            party = new Party35Choice();
            pi = new PartyIdentification125();
            pi.setNm(tag.my.name);
            party.setPty(pi);
            if (haben) {
                other.setCdtr(party);
            } else {
                other.setDbtr(party);
            }
            bank = new BranchAndFinancialInstitutionIdentification5();
            if (haben) {
                banks.setCdtrAgt(bank);
            } else {
                banks.setDbtrAgt(bank);
            }
            bic = new FinancialInstitutionIdentification8();
            bank.setFinInstnId(bic);
            bic.setBICFI(tag.my.bic);
        }
        if (line.other != null) {
            acc = new CashAccount24();
            if (haben) {
                other.setDbtrAcct(acc);
            } else {
                other.setCdtrAcct(acc);
            }
            id = new AccountIdentification4Choice();
            acc.setId(id);
            id.setIBAN(line.other.iban);
            party = new Party35Choice();
            pi = new PartyIdentification125();
            pi.setNm(line.other.name);
            party.setPty(pi);
            if (haben) {
                other.setDbtr(party);
            } else {
                other.setCdtr(party);
            }
            bank = new BranchAndFinancialInstitutionIdentification5();
            if (haben) {
                banks.setDbtrAgt(bank);
            } else {
                banks.setCdtrAgt(bank);
            }
            bic = new FinancialInstitutionIdentification8();
            bank.setFinInstnId(bic);
            bic.setBICFI(line.other.bic);
        }
        if (line.usage != null && line.usage.size() > 0) {
            RemittanceInformation15 usages = new RemittanceInformation15();
            usages.getUstrd().addAll(line.usage);
            tx.setRmtInf(usages);
        }
        if (line.value != null) {
            ActiveOrHistoricCurrencyAndAmount amt = new ActiveOrHistoricCurrencyAndAmount();
            entry.setAmt(amt);
            BigDecimal val = line.value.getBigDecimalValue();
            amt.setValue(val.abs());
            amt.setCcy(line.value.getCurr());
        }
        if (line.isStorno) {
            entry.setRvslInd(Boolean.TRUE);
        }
        Date bdate = line.bdate;
        Date valuta = line.valuta;
        if (bdate == null) {
            bdate = valuta;
        }
        if (valuta == null) {
            valuta = bdate;
        }
        if (bdate != null) {
            d = new DateAndDateTime2Choice();
            d.setDt(this.createCalendar(bdate.getTime()));
            entry.setBookgDt(d);
        }
        if (valuta != null) {
            d = new DateAndDateTime2Choice();
            d.setDt(this.createCalendar(valuta.getTime()));
            entry.setValDt(d);
        }
        entry.setAddtlNtryInf(line.text);
        entry.setAcctSvcrRef(line.customerref);
        StringBuilder sb = new StringBuilder();
        if (line.gvcode != null && line.gvcode.length() > 0) {
            sb.append(line.gvcode);
            sb.append("+");
        }
        if (line.primanota != null && line.primanota.length() > 0) {
            sb.append(line.primanota);
            sb.append("+");
        }
        if (line.addkey != null && line.addkey.length() > 0) {
            sb.append(line.addkey);
        }
        if ((s = sb.toString()).length() > 0) {
            BankTransactionCodeStructure4 b = new BankTransactionCodeStructure4();
            tx.setBkTxCd(b);
            ProprietaryBankTransactionCodeStructure1 pb = new ProprietaryBankTransactionCodeStructure1();
            pb.setCd(s);
            b.setPrtry(pb);
        }
        if (line.purposecode != null) {
            Purpose2Choice c = new Purpose2Choice();
            c.setCd(line.purposecode);
            tx.setPurp(c);
        }
        return entry;
    }

    private AccountReport22 createDay(GVRKUms.BTag tag) throws Exception {
        AccountReport22 report = new AccountReport22();
        if (tag != null) {
            report.getBal().add(this.createSaldo(tag.start, true));
            report.getBal().add(this.createSaldo(tag.end, false));
        }
        if (tag != null && tag.my != null) {
            CashAccount36 acc = new CashAccount36();
            report.setAcct(acc);
            AccountIdentification4Choice id = new AccountIdentification4Choice();
            id.setIBAN(tag.my.iban);
            acc.setId(id);
            acc.setCcy(tag.my.curr);
            BranchAndFinancialInstitutionIdentification5 svc = new BranchAndFinancialInstitutionIdentification5();
            acc.setSvcr(svc);
            FinancialInstitutionIdentification8 inst = new FinancialInstitutionIdentification8();
            svc.setFinInstnId(inst);
            inst.setBICFI(tag.my.bic);
        }
        return report;
    }

    private CashBalance8 createSaldo(Saldo saldo, boolean start) throws Exception {
        long ts;
        CashBalance8 bal = new CashBalance8();
        BalanceType13 bt = new BalanceType13();
        bt.setCdOrPrtry(new BalanceType10Choice());
        bt.getCdOrPrtry().setCd(start ? "PRCD" : "CLBD");
        bal.setTp(bt);
        ActiveOrHistoricCurrencyAndAmount amt = new ActiveOrHistoricCurrencyAndAmount();
        bal.setAmt(amt);
        if (saldo != null && saldo.value != null) {
            amt.setCcy(saldo.value.getCurr());
            amt.setValue(saldo.value.getBigDecimalValue());
            boolean haben = saldo.value.getBigDecimalValue().compareTo(BigDecimal.ZERO) > 0;
            bal.setCdtDbtInd(haben ? CreditDebitCode.CRDT : CreditDebitCode.DBIT);
        }
        long l = ts = saldo != null && saldo.timestamp != null ? saldo.timestamp.getTime() : 0L;
        if (start && ts > 0L) {
            ts -= 86400000L;
        }
        DateAndDateTime2Choice date = new DateAndDateTime2Choice();
        date.setDt(this.createCalendar(ts));
        bal.setDt(date);
        return bal;
    }

    private XMLGregorianCalendar createCalendar(Long timestamp) throws Exception {
        DatatypeFactory df = DatatypeFactory.newInstance();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(timestamp != null ? timestamp : System.currentTimeMillis());
        XMLGregorianCalendar xml = df.newXMLGregorianCalendar(cal);
        xml.setTimezone(Integer.MIN_VALUE);
        return xml;
    }
}

