/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXB;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractCamtParser;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.AccountIdentification3Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.AccountReport9;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.BalanceType8Code;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.BankToCustomerAccountReportV01;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.BankTransactionCodeStructure1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.BranchAndFinancialInstitutionIdentification3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.CashAccount13;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.CashAccount7;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.CashBalance1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.CreditDebitCode;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.CurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.DateAndDateTimeChoice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.Document;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.EntryTransaction1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.FinancialInstitutionIdentification5Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.GenericIdentification4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.Party2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.PartyIdentification8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.PersonIdentification3;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.Purpose1Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.ReportEntry1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.TransactionAgents1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.TransactionParty1;
import org.kapott.hbci.sepa.jaxb.camt_052_001_01.TransactionReferences1;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class ParseCamt05200101
extends AbstractCamtParser {
    @Override
    public void parse(InputStream xml, List<GVRKUms.BTag> tage) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        BankToCustomerAccountReportV01 container = doc.getBkToCstmrAcctRptV01();
        if (container == null) {
            HBCIUtils.log("camt document empty", 2);
            return;
        }
        List<AccountReport9> reports = container.getRpt();
        if (reports == null || reports.size() == 0) {
            HBCIUtils.log("camt document empty", 2);
            return;
        }
        for (AccountReport9 report : reports) {
            GVRKUms.UmsLine line;
            GVRKUms.BTag tag = this.createDay(report);
            tage.add(tag);
            BigDecimal saldo = tag.start.value.getBigDecimalValue();
            for (ReportEntry1 entry : report.getNtry()) {
                line = this.createLine(entry, saldo);
                if (line == null) continue;
                tag.lines.add(line);
                saldo = line.saldo.value.getBigDecimalValue();
            }
            if (tag.start.timestamp != null || tag.end.timestamp == null) continue;
            BigDecimal endSaldo = tag.end.value.getBigDecimalValue();
            int n = tag.lines.size();
            while (n > 0) {
                line = tag.lines.get(--n);
                line.saldo.value.setValue(endSaldo);
                endSaldo = endSaldo.subtract(line.value.getBigDecimalValue());
            }
        }
    }

    private GVRKUms.UmsLine createLine(ReportEntry1 entry, BigDecimal currSaldo) {
        Purpose1Choice purp;
        String[] parts;
        BankTransactionCodeStructure1 b;
        String code;
        List<String> usages;
        TransactionAgents1 banks;
        TransactionParty1 other;
        GVRKUms.UmsLine line = new GVRKUms.UmsLine();
        line.isSepa = true;
        line.isCamt = true;
        line.other = new Konto();
        CurrencyAndAmount amt = entry.getAmt();
        BigDecimal bd = amt.getValue() != null ? amt.getValue() : BigDecimal.ZERO;
        line.value = new Value(this.checkDebit(bd, entry.getCdtDbtInd()));
        line.value.setCurr(amt.getCcy());
        line.isStorno = entry.isRvslInd() != null ? entry.isRvslInd() : false;
        DateAndDateTimeChoice bdate = entry.getBookgDt();
        line.bdate = bdate != null ? SepaUtil.toDate(bdate.getDt()) : null;
        DateAndDateTimeChoice vdate = entry.getValDt();
        Date date = line.valuta = vdate != null ? SepaUtil.toDate(vdate.getDt()) : null;
        if (line.bdate == null) {
            line.bdate = line.valuta;
        }
        if (line.valuta == null) {
            line.valuta = line.bdate;
        }
        line.saldo = new Saldo();
        line.saldo.value = new Value(currSaldo.add(line.value.getBigDecimalValue()));
        line.saldo.value.setCurr(line.value.getCurr());
        line.saldo.timestamp = line.bdate;
        line.text = this.trim(entry.getAddtlNtryInf());
        line.customerref = this.trim(entry.getAcctSvcrRef());
        List<EntryTransaction1> txList = entry.getTxDtls();
        if (txList.size() == 0) {
            line.usage.add(this.trim(entry.getAddtlNtryInf()));
            return line;
        }
        boolean haben = entry.getCdtDbtInd() != null && entry.getCdtDbtInd() == CreditDebitCode.CRDT;
        EntryTransaction1 tx = txList.get(0);
        TransactionReferences1 ref = tx.getRefs();
        if (ref != null) {
            line.id = this.trim(ref.getPrtry() != null ? ref.getPrtry().getRef() : null);
            if (line.id == null) {
                line.id = Optional.ofNullable(entry.getAcctSvcrRef()).orElse(ref.getAcctSvcrRef());
            }
            line.endToEndId = this.trim(ref.getEndToEndId());
            line.mandateId = this.trim(ref.getMndtId());
        }
        if ((other = tx.getRltdPties()) != null) {
            CashAccount7 acc = haben ? other.getDbtrAcct() : other.getCdtrAcct();
            AccountIdentification3Choice id = acc != null ? acc.getId() : null;
            line.other.iban = this.trim(id != null ? id.getIBAN() : null);
            PartyIdentification8 name = haben ? other.getDbtr() : other.getCdtr();
            line.other.name = this.trim(name != null ? name.getNm() : null);
            Party2Choice id2 = name != null ? name.getId() : null;
            List<PersonIdentification3> prvtId = id2 != null ? id2.getPrvtId() : null;
            PersonIdentification3 pi3 = prvtId != null && !prvtId.isEmpty() ? prvtId.get(0) : null;
            GenericIdentification4 genericIdentification4 = pi3 != null ? pi3.getOthrId() : null;
            line.other.creditorid = this.trim(genericIdentification4 != null ? genericIdentification4.getId() : null);
            name = haben ? other.getUltmtDbtr() : other.getUltmtCdtr();
            line.other.name2 = this.trim(name != null ? name.getNm() : null);
        }
        if ((banks = tx.getRltdAgts()) != null) {
            BranchAndFinancialInstitutionIdentification3 bank = haben ? banks.getDbtrAgt() : banks.getCdtrAgt();
            FinancialInstitutionIdentification5Choice bic = bank != null ? bank.getFinInstnId() : null;
            line.other.bic = this.trim(bic != null ? bic.getBIC() : null);
        }
        List<String> list = usages = tx.getRmtInf() != null ? tx.getRmtInf().getUstrd() : null;
        if (usages != null && usages.size() > 0) {
            line.usage.addAll(this.trim(usages));
        }
        String string = code = (b = tx.getBkTxCd()) != null && b.getPrtry() != null ? b.getPrtry().getCd() : null;
        if (code != null && code.contains("+") && (parts = code.split("\\+")).length == 4) {
            line.gvcode = parts[1];
            line.primanota = parts[2];
            line.addkey = parts[3];
        }
        line.purposecode = this.trim((purp = tx.getPurp()) != null ? purp.getCd() : null);
        return line;
    }

    private GVRKUms.BTag createDay(AccountReport9 report) {
        GVRKUms.BTag tag = new GVRKUms.BTag();
        tag.starttype = (char)70;
        tag.endtype = (char)70;
        tag.start = new Saldo();
        tag.end = new Saldo();
        long day = 86400000L;
        if (report.getBal().size() > 0) {
            CashBalance1 secondBal;
            BalanceType8Code secondCode;
            CashBalance1 firstBal = report.getBal().get(0);
            BalanceType8Code firstCode = firstBal.getTp().getCd();
            if (firstCode == BalanceType8Code.PRCD || firstCode == BalanceType8Code.ITBD || firstCode == BalanceType8Code.OPBD) {
                tag.start.value = new Value(this.checkDebit(firstBal.getAmt().getValue(), firstBal.getCdtDbtInd()));
                tag.start.value.setCurr(firstBal.getAmt().getCcy());
                tag.start.timestamp = firstCode == BalanceType8Code.PRCD ? new Date(SepaUtil.toDate(firstBal.getDt().getDt()).getTime() + 86400000L) : new Date(SepaUtil.toDate(firstBal.getDt().getDt()).getTime());
            }
            if (report.getBal().size() > 1 && ((secondCode = (secondBal = report.getBal().get(1)).getTp().getCd()) == BalanceType8Code.CLBD || secondCode == BalanceType8Code.ITBD)) {
                tag.end.value = new Value(this.checkDebit(secondBal.getAmt().getValue(), secondBal.getCdtDbtInd()));
                tag.end.value.setCurr(secondBal.getAmt().getCcy());
                tag.end.timestamp = SepaUtil.toDate(secondBal.getDt().getDt());
            }
        }
        CashAccount13 acc = report.getAcct();
        tag.my = new Konto();
        tag.my.iban = this.trim(acc.getId().getIBAN());
        tag.my.curr = this.trim(acc.getCcy());
        BranchAndFinancialInstitutionIdentification3 bank = acc.getSvcr();
        if (bank != null && bank.getFinInstnId() != null) {
            tag.my.bic = this.trim(bank.getFinInstnId().getBIC());
        }
        return tag;
    }

    private BigDecimal checkDebit(BigDecimal d, CreditDebitCode code) {
        if (d == null || code == null || code == CreditDebitCode.CRDT) {
            return d;
        }
        return BigDecimal.ZERO.subtract(d);
    }
}

