/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.ActiveOrHistoricCurrencyAndAmountSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.CreditTransferTransactionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.CustomerCreditTransferInitiationV03;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.PaymentIdentificationSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.PaymentInstructionInformationSCT;
import org.kapott.hbci.sepa.jaxb.pain_001_003_03.PurposeSEPA;

public class ParsePain00100303
extends AbstractSepaParser<List<Properties>> {
    @Override
    public void parse(InputStream xml, List<Properties> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        CustomerCreditTransferInitiationV03 pain = doc.getCstmrCdtTrfInitn();
        if (pain == null) {
            return;
        }
        List<PaymentInstructionInformationSCT> pmtInfs = pain.getPmtInf();
        for (PaymentInstructionInformationSCT pmtInf : pmtInfs) {
            List<CreditTransferTransactionInformationSCT> txList = pmtInf.getCdtTrfTxInf();
            for (CreditTransferTransactionInformationSCT tx : txList) {
                PaymentIdentificationSEPA pmtId;
                XMLGregorianCalendar date;
                PurposeSEPA purp;
                Properties prop = new Properties();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getDbtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getDbtrAgt().getFinInstnId().getBIC());
                this.put(prop, ISEPAParser.Names.BATCHBOOK, pmtInf.isBtchBookg() != null ? pmtInf.isBtchBookg().toString() : null);
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getCdtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getCdtrAcct().getId().getIBAN());
                try {
                    this.put(prop, ISEPAParser.Names.DST_BIC, tx.getCdtrAgt().getFinInstnId().getBIC());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActiveOrHistoricCurrencyAndAmountSEPA amt = tx.getAmt().getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy().value());
                if (tx.getRmtInf() != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                if ((date = pmtInf.getReqdExctnDt()) != null) {
                    this.put(prop, ISEPAParser.Names.DATE, SepaUtil.format(date, null));
                }
                if ((pmtId = tx.getPmtId()) != null) {
                    this.put(prop, ISEPAParser.Names.ENDTOENDID, pmtId.getEndToEndId());
                }
                sepaResults.add(prop);
            }
        }
    }
}

