/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.callback;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.exceptions.AbortedException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.INILetter;

public class HBCICallbackSwing
extends HBCICallbackConsole {
    public static final boolean ACTION_BLOCKING = true;
    public static final boolean ACTION_NOT_BLOCKING = false;
    public static final boolean DIALOG_MODAL = true;
    public static final boolean DIALOG_NOT_MODAL = false;
    protected Hashtable<HBCIPassport, Hashtable<String, Object>> passports = new Hashtable();

    @Override
    public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
        Hashtable<String, Object> currentData;
        if (msg == null) {
            msg = "";
        }
        if ((currentData = this.passports.get(passport)) == null) {
            currentData = new Hashtable();
            currentData.put("passport", passport);
            currentData.put("dataRequested", Boolean.FALSE);
            currentData.put("proxyRequested", Boolean.FALSE);
            currentData.put("msgcounter", new Integer(0));
            this.passports.put(passport, currentData);
        }
        currentData.put("reason", new Integer(reason));
        currentData.put("msg", msg);
        if (retData != null) {
            currentData.put("retData", retData);
        }
        try {
            switch (reason) {
                case 21: 
                case 22: {
                    this.needSecret(currentData, "passphrase");
                    break;
                }
                case 4: {
                    this.needSecret(currentData, "softpin");
                    break;
                }
                case 16: {
                    this.needSecret(currentData, "ptpin");
                    break;
                }
                case 17: 
                case 33: 
                case 34: {
                    this.needSecret(currentData, "pttan");
                    break;
                }
                case 7: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_country"));
                    break;
                }
                case 8: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_blz"));
                    break;
                }
                case 9: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_host"));
                    break;
                }
                case 10: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_port"));
                    break;
                }
                case 26: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_filter"));
                    break;
                }
                case 11: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_userid"));
                    break;
                }
                case 18: {
                    if (!((Boolean)currentData.get("dataRequested")).booleanValue()) {
                        this.needRDHData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("data_customerid"));
                    break;
                }
                case 2: {
                    this.needAction(currentData, false, "chipcard");
                    break;
                }
                case 3: {
                    this.needAction(currentData, false, "hardpin");
                    break;
                }
                case 15: {
                    this.needAction(currentData, true, "remove");
                    break;
                }
                case 6: {
                    this.removeActionWindow(currentData, "chipcard");
                    break;
                }
                case 5: {
                    this.removeActionWindow(currentData, "hardpin");
                    break;
                }
                case 12: {
                    this.ackInstKeys(currentData, "ackinstkeys");
                    break;
                }
                case 13: {
                    this.haveNewMyKeys(currentData, "ackmykeys");
                    break;
                }
                case 14: {
                    this.showInstMessage(currentData, "instmsg", retData != null);
                    break;
                }
                case 24: 
                case 25: {
                    this.showConnectionMessage(currentData, "connmsg");
                    break;
                }
                case 19: {
                    this.correctAccountData(currentData, "crcerror");
                    break;
                }
                case 30: {
                    this.correctIBANData(currentData, "ibanerror");
                    break;
                }
                case 20: {
                    this.handleError(currentData, "error");
                    break;
                }
                case 23: {
                    this.needSIZEntrySelect(currentData, "sizentryselect");
                    break;
                }
                case 27: {
                    this.needPTSecMech(currentData, "pt_method");
                    break;
                }
                case 28: {
                    if (!((Boolean)currentData.get("proxyRequested")).booleanValue()) {
                        this.needProxyData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("proxy_user"));
                    break;
                }
                case 29: {
                    if (!((Boolean)currentData.get("proxyRequested")).booleanValue()) {
                        this.needProxyData(currentData);
                    }
                    retData.replace(0, retData.length(), (String)currentData.get("proxy_pass"));
                    break;
                }
                default: {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_UNKNOWN", Integer.toString(reason)));
                }
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_ERR"), e);
        }
    }

    private void needSecret(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        final int[] aborted = new int[]{0};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                final JPasswordField input = new JPasswordField(10);
                mainbox.add(input);
                mainbox.add(Box.createVerticalStrut(8));
                JPasswordField tempinput = null;
                if ((Integer)currentData.get("reason") == 22) {
                    tempinput = new JPasswordField(10);
                    mainbox.add(tempinput);
                    mainbox.add(Box.createVerticalStrut(8));
                }
                final JPasswordField input2 = tempinput;
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String passphrase2;
                        String passphrase = String.valueOf(input.getPassword());
                        if (input2 != null && !passphrase.equals(passphrase2 = String.valueOf(input2.getPassword()))) {
                            aborted[0] = 2;
                        }
                        if (aborted[0] == 0) {
                            StringBuffer retData = (StringBuffer)currentData.get("retData");
                            retData.replace(0, retData.length(), passphrase);
                        }
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        aborted[0] = 1;
                        sync.stopWaiting();
                    }
                });
                input.requestFocus();
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
        if (aborted[0] == 1) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
        if (aborted[0] == 2) {
            throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_PWDONTMATCH"));
        }
    }

    private void correctAccountData(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        final boolean[] aborted = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                JPanel table = new JPanel(new GridBagLayout());
                mainbox.add(table);
                GridBagConstraints constr = new GridBagConstraints();
                constr.anchor = 18;
                constr.insets = new Insets(2, 2, 2, 2);
                final StringBuffer retData = (StringBuffer)currentData.get("retData");
                int idx = retData.indexOf("|");
                constr.gridx = 0;
                constr.gridy = 0;
                l = new JLabel(HBCIUtilsInternal.getLocMsg("BLZ"));
                table.add((Component)l, constr);
                ++constr.gridx;
                final JTextField blz = new JTextField(retData.substring(0, idx), 10);
                table.add((Component)blz, constr);
                constr.gridx = 0;
                ++constr.gridy;
                l = new JLabel(HBCIUtilsInternal.getLocMsg("ACCNUMBER"));
                table.add((Component)l, constr);
                ++constr.gridx;
                final JTextField number = new JTextField(retData.substring(idx + 1), 10);
                table.add((Component)number, constr);
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        retData.replace(0, retData.length(), blz.getText() + "|" + number.getText());
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        aborted[0] = true;
                        sync.stopWaiting();
                    }
                });
                blz.requestFocus();
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
        if (aborted[0]) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
    }

    private void correctIBANData(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        final boolean[] aborted = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                JPanel table = new JPanel(new GridBagLayout());
                mainbox.add(table);
                GridBagConstraints constr = new GridBagConstraints();
                constr.anchor = 18;
                constr.insets = new Insets(2, 2, 2, 2);
                final StringBuffer retData = (StringBuffer)currentData.get("retData");
                constr.gridx = 0;
                constr.gridy = 0;
                l = new JLabel(HBCIUtilsInternal.getLocMsg("IBAN"));
                table.add((Component)l, constr);
                ++constr.gridx;
                final JTextField iban = new JTextField(retData.toString(), 10);
                table.add((Component)iban, constr);
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        retData.replace(0, retData.length(), iban.getText());
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        aborted[0] = true;
                        sync.stopWaiting();
                    }
                });
                iban.requestFocus();
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
        if (aborted[0]) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
    }

    private void needRDHData(final Hashtable<String, Object> currentData) {
        final SyncObject sync = new SyncObject();
        final boolean[] aborted = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", "rdhdata");
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_NEEDRDHDATA")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                JPanel table = new JPanel(new GridBagLayout());
                mainbox.add(table);
                mainbox.add(Box.createVerticalStrut(8));
                GridBagConstraints constr = new GridBagConstraints();
                constr.anchor = 18;
                constr.fill = 2;
                constr.insets = new Insets(4, 0, 4, 8);
                HBCIPassport passport = (HBCIPassport)currentData.get("passport");
                constr.gridx = 0;
                constr.gridy = 0;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("COUNTRY")), constr);
                final JTextField input_country = new JTextField(passport.getCountry(), 3);
                ++constr.gridx;
                table.add((Component)input_country, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("BLZ")), constr);
                final JTextField input_blz = new JTextField(passport.getBLZ(), 25);
                ++constr.gridx;
                table.add((Component)input_blz, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("HOST")), constr);
                final JTextField input_host = new JTextField(passport.getHost(), 25);
                ++constr.gridx;
                table.add((Component)input_host, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("PORT")), constr);
                final JTextField input_port = new JTextField(passport.getPort().toString(), 25);
                ++constr.gridx;
                table.add((Component)input_port, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("FILTER")), constr);
                final JTextField input_filter = new JTextField(passport.getFilterType(), 25);
                ++constr.gridx;
                table.add((Component)input_filter, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("USERID")), constr);
                final JTextField input_userid = new JTextField(passport.getUserId(), 25);
                ++constr.gridx;
                table.add((Component)input_userid, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("CUSTOMERID")), constr);
                final JTextField input_customerid = new JTextField(passport.getCustomerId(), 25);
                ++constr.gridx;
                constr.weightx = 1.0;
                constr.weighty = 1.0;
                table.add((Component)input_customerid, constr);
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        currentData.put("data_country", input_country.getText());
                        currentData.put("data_blz", input_blz.getText());
                        currentData.put("data_host", input_host.getText());
                        currentData.put("data_port", input_port.getText());
                        currentData.put("data_filter", input_filter.getText());
                        currentData.put("data_userid", input_userid.getText());
                        currentData.put("data_customerid", input_customerid.getText());
                        currentData.put("dataRequested", Boolean.TRUE);
                        HBCICallbackSwing.this.removeWin(currentData, "rdhdata");
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, "rdhdata");
                        aborted[0] = true;
                        sync.stopWaiting();
                    }
                });
                input_country.requestFocus();
                HBCICallbackSwing.this.drawWin(currentData, "rdhdata");
            }
        });
        sync.startWaiting();
        if (aborted[0]) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
    }

    private void needProxyData(final Hashtable<String, Object> currentData) {
        final SyncObject sync = new SyncObject();
        final boolean[] aborted = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", "proxydata");
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_NEED_PROXYDATA")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                JPanel table = new JPanel(new GridBagLayout());
                mainbox.add(table);
                mainbox.add(Box.createVerticalStrut(8));
                GridBagConstraints constr = new GridBagConstraints();
                constr.anchor = 18;
                constr.fill = 2;
                constr.insets = new Insets(4, 0, 4, 8);
                AbstractPinTanPassport passport = (AbstractPinTanPassport)currentData.get("passport");
                constr.gridx = 0;
                constr.gridy = 0;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_PROXY_USERNAME")), constr);
                final JTextField input_user = new JTextField(passport.getProxyUser(), 3);
                ++constr.gridx;
                table.add((Component)input_user, constr);
                constr.gridx = 0;
                ++constr.gridy;
                table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_PROXY_PASSWD")), constr);
                final JPasswordField input_pass = new JPasswordField(passport.getProxyPass(), 25);
                ++constr.gridx;
                table.add((Component)input_pass, constr);
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        currentData.put("proxy_user", input_user.getText());
                        currentData.put("proxy_pass", new String(input_pass.getPassword()));
                        HBCICallbackSwing.this.removeWin(currentData, "proxydata");
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, "proxydata");
                        aborted[0] = true;
                        sync.stopWaiting();
                    }
                });
                input_user.requestFocus();
                HBCICallbackSwing.this.drawWin(currentData, "proxydata");
            }
        });
        sync.startWaiting();
        if (aborted[0]) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
    }

    private void needAction(final Hashtable<String, Object> currentData, final boolean blocking, final String winname) {
        final SyncObject sync = new SyncObject();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container tempWin = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                tempWin.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CLOSE"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                if (!blocking) {
                    sync.stopWaiting();
                }
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
    }

    private void removeActionWindow(Hashtable<String, Object> currentData, String winname) {
        this.removeWin(currentData, winname);
    }

    private void ackInstKeys(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int i;
                    Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                    Box framebox = Box.createHorizontalBox();
                    win.add(framebox);
                    framebox.add(Box.createHorizontalStrut(8));
                    Box mainbox = Box.createVerticalBox();
                    framebox.add(mainbox);
                    framebox.add(Box.createHorizontalStrut(8));
                    mainbox.add(Box.createVerticalStrut(8));
                    Box box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                    l.setFont(new Font("Arial", 0, 10));
                    box2.add(Box.createHorizontalGlue());
                    box2.add(l);
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(8));
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    box2.add(new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_NEW_INST_KEYS")));
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(10));
                    JPanel table = new JPanel(new GridBagLayout());
                    mainbox.add(table);
                    mainbox.add(Box.createVerticalStrut(8));
                    GridBagConstraints constr = new GridBagConstraints();
                    constr.anchor = 18;
                    constr.fill = 2;
                    constr.insets = new Insets(4, 0, 4, 8);
                    HBCIPassport passport = (HBCIPassport)currentData.get("passport");
                    INILetter iniletter = new INILetter(passport, 1);
                    String exp_st = HBCIUtils.data2hex(iniletter.getKeyExponentDisplay());
                    String mod_st = HBCIUtils.data2hex(iniletter.getKeyModulusDisplay());
                    String hash_st = HBCIUtils.data2hex(iniletter.getKeyHashDisplay());
                    Font font = new Font("Monospaced", 0, 10);
                    constr.gridx = 0;
                    constr.gridy = 0;
                    constr.gridheight = 8;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("EXPONENT")), constr);
                    ++constr.gridx;
                    constr.gridheight = 1;
                    for (i = 0; i <= exp_st.length() / 3 / 16; ++i) {
                        constr.insets = i == 0 ? new Insets(8, 0, 1, 8) : new Insets(1, 0, 1, 8);
                        l = new JLabel(exp_st.substring(i * 16 * 3, Math.min((i + 1) * 16 * 3 - 1, exp_st.length())));
                        l.setFont(font);
                        l.setForeground(Color.BLUE);
                        table.add((Component)l, constr);
                        ++constr.gridy;
                    }
                    constr.gridx = 0;
                    constr.gridheight = 8;
                    constr.insets = new Insets(4, 0, 4, 8);
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("MODULUS")), constr);
                    ++constr.gridx;
                    constr.gridheight = 1;
                    for (i = 0; i <= mod_st.length() / 3 / 16; ++i) {
                        constr.insets = i == 0 ? new Insets(8, 0, 1, 8) : new Insets(1, 0, 1, 8);
                        l = new JLabel(mod_st.substring(i * 16 * 3, Math.min((i + 1) * 16 * 3 - 1, mod_st.length())));
                        l.setFont(font);
                        l.setForeground(Color.BLUE);
                        table.add((Component)l, constr);
                        ++constr.gridy;
                    }
                    constr.gridx = 0;
                    constr.gridheight = 2;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("HASH")), constr);
                    constr.insets = new Insets(4, 0, 4, 8);
                    ++constr.gridx;
                    constr.gridheight = 1;
                    for (i = 0; i <= hash_st.length() / 3 / 10; ++i) {
                        constr.insets = i == 0 ? new Insets(8, 0, 1, 8) : new Insets(1, 0, 1, 8);
                        l = new JLabel(hash_st.substring(i * 10 * 3, Math.min((i + 1) * 10 * 3 - 1, hash_st.length())));
                        l.setFont(font);
                        l.setForeground(Color.MAGENTA);
                        table.add((Component)l, constr);
                        ++constr.gridy;
                    }
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    mainbox.add(Box.createVerticalStrut(4));
                    box2.add(Box.createHorizontalGlue());
                    JButton ok = new JButton("OK");
                    box2.add(ok);
                    ((JComponent)win).getRootPane().setDefaultButton(ok);
                    JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                    box2.add(cancel);
                    box2.add(Box.createHorizontalGlue());
                    final StringBuffer retData = (StringBuffer)currentData.get("retData");
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            retData.replace(0, retData.length(), "");
                            HBCICallbackSwing.this.removeWin(currentData, winname);
                            sync.stopWaiting();
                        }
                    });
                    cancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            retData.replace(0, retData.length(), "ERROR");
                            HBCICallbackSwing.this.removeWin(currentData, winname);
                            sync.stopWaiting();
                        }
                    });
                    ok.requestFocus();
                    HBCICallbackSwing.this.drawWin(currentData, winname);
                }
                catch (Exception e) {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_ERR"), e);
                }
            }
        });
        sync.startWaiting();
    }

    private void handleError(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                    Box framebox = Box.createHorizontalBox();
                    win.add(framebox);
                    framebox.add(Box.createHorizontalStrut(8));
                    Box mainbox = Box.createVerticalBox();
                    framebox.add(mainbox);
                    framebox.add(Box.createHorizontalStrut(8));
                    mainbox.add(Box.createVerticalStrut(8));
                    Box box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                    l.setFont(new Font("Arial", 0, 10));
                    box2.add(Box.createHorizontalGlue());
                    box2.add(l);
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(8));
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    box2.add(new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_ERROR_OCCURED")));
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(6));
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    box2.add(new JLabel((String)currentData.get("msg")));
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(10));
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    mainbox.add(Box.createVerticalStrut(4));
                    box2.add(Box.createHorizontalGlue());
                    JButton ok = new JButton(HBCIUtilsInternal.getLocMsg("IGNORE"));
                    box2.add(ok);
                    ((JComponent)win).getRootPane().setDefaultButton(ok);
                    JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("ABORT"));
                    box2.add(cancel);
                    box2.add(Box.createHorizontalGlue());
                    final StringBuffer retData = (StringBuffer)currentData.get("retData");
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            retData.replace(0, retData.length(), "");
                            HBCICallbackSwing.this.removeWin(currentData, winname);
                            sync.stopWaiting();
                        }
                    });
                    cancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            retData.replace(0, retData.length(), "ERROR");
                            HBCICallbackSwing.this.removeWin(currentData, winname);
                            sync.stopWaiting();
                        }
                    });
                    ok.requestFocus();
                    HBCICallbackSwing.this.drawWin(currentData, winname);
                }
                catch (Exception e) {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_ERR"), e);
                }
            }
        });
        sync.startWaiting();
    }

    private void haveNewMyKeys(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int i;
                    Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                    Box framebox = Box.createHorizontalBox();
                    win.add(framebox);
                    framebox.add(Box.createHorizontalStrut(8));
                    Box mainbox = Box.createVerticalBox();
                    framebox.add(mainbox);
                    framebox.add(Box.createHorizontalStrut(8));
                    mainbox.add(Box.createVerticalStrut(8));
                    Box box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                    l.setFont(new Font("Arial", 0, 10));
                    box2.add(Box.createHorizontalGlue());
                    box2.add(l);
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(8));
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    box2.add(new JLabel(HBCIUtilsInternal.getLocMsg("CALLB_NEW_USER_KEYS")));
                    box2.add(Box.createHorizontalGlue());
                    mainbox.add(Box.createVerticalStrut(10));
                    JPanel table = new JPanel(new GridBagLayout());
                    mainbox.add(table);
                    mainbox.add(Box.createVerticalStrut(8));
                    GridBagConstraints constr = new GridBagConstraints();
                    constr.anchor = 18;
                    constr.fill = 2;
                    constr.insets = new Insets(4, 0, 4, 8);
                    HBCIPassport passport = (HBCIPassport)currentData.get("passport");
                    INILetter iniletter = new INILetter(passport, 2);
                    String exp_st = HBCIUtils.data2hex(iniletter.getKeyExponentDisplay());
                    String mod_st = HBCIUtils.data2hex(iniletter.getKeyModulusDisplay());
                    String hash_st = HBCIUtils.data2hex(iniletter.getKeyHashDisplay());
                    Font font = new Font("Monospaced", 0, 10);
                    Date date = new Date();
                    constr.gridx = 0;
                    constr.gridy = 0;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("DATE")), constr);
                    ++constr.gridx;
                    table.add((Component)new JLabel(HBCIUtils.date2StringLocal(date)), constr);
                    constr.gridx = 0;
                    ++constr.gridy;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("TIME")), constr);
                    ++constr.gridx;
                    table.add((Component)new JLabel(HBCIUtils.time2StringLocal(date)), constr);
                    constr.gridx = 0;
                    ++constr.gridy;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("BLZ")), constr);
                    ++constr.gridx;
                    table.add((Component)new JLabel(passport.getBLZ()), constr);
                    constr.gridx = 0;
                    ++constr.gridy;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("USERID")), constr);
                    ++constr.gridx;
                    table.add((Component)new JLabel(passport.getUserId()), constr);
                    constr.gridx = 0;
                    ++constr.gridy;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("KEYNUM")), constr);
                    ++constr.gridx;
                    table.add((Component)new JLabel(passport.getMyPublicSigKey().num), constr);
                    constr.gridx = 0;
                    ++constr.gridy;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("KEYVERSION")), constr);
                    ++constr.gridx;
                    table.add((Component)new JLabel(passport.getMyPublicSigKey().version), constr);
                    constr.gridx = 0;
                    ++constr.gridy;
                    constr.gridheight = 8;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("EXPONENT")), constr);
                    ++constr.gridx;
                    constr.gridheight = 1;
                    for (i = 0; i <= exp_st.length() / 3 / 16; ++i) {
                        constr.insets = i == 0 ? new Insets(8, 0, 1, 8) : new Insets(1, 0, 1, 8);
                        l = new JLabel(exp_st.substring(i * 16 * 3, Math.min((i + 1) * 16 * 3 - 1, exp_st.length())));
                        l.setFont(font);
                        l.setForeground(Color.BLUE);
                        table.add((Component)l, constr);
                        ++constr.gridy;
                    }
                    constr.gridx = 0;
                    constr.gridheight = 8;
                    constr.insets = new Insets(4, 0, 4, 8);
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("MODULUS")), constr);
                    ++constr.gridx;
                    constr.gridheight = 1;
                    for (i = 0; i <= mod_st.length() / 3 / 16; ++i) {
                        constr.insets = i == 0 ? new Insets(8, 0, 1, 8) : new Insets(1, 0, 1, 8);
                        l = new JLabel(mod_st.substring(i * 16 * 3, Math.min((i + 1) * 16 * 3 - 1, mod_st.length())));
                        l.setFont(font);
                        l.setForeground(Color.BLUE);
                        table.add((Component)l, constr);
                        ++constr.gridy;
                    }
                    constr.gridx = 0;
                    constr.gridheight = 2;
                    table.add((Component)new JLabel(HBCIUtilsInternal.getLocMsg("HASH")), constr);
                    constr.insets = new Insets(4, 0, 4, 8);
                    ++constr.gridx;
                    constr.gridheight = 1;
                    for (i = 0; i <= hash_st.length() / 3 / 10; ++i) {
                        constr.insets = i == 0 ? new Insets(8, 0, 1, 8) : new Insets(1, 0, 1, 8);
                        l = new JLabel(hash_st.substring(i * 10 * 3, Math.min((i + 1) * 10 * 3 - 1, hash_st.length())));
                        l.setFont(font);
                        l.setForeground(Color.MAGENTA);
                        table.add((Component)l, constr);
                        ++constr.gridy;
                    }
                    box2 = Box.createHorizontalBox();
                    mainbox.add(box2);
                    mainbox.add(Box.createVerticalStrut(4));
                    box2.add(Box.createHorizontalGlue());
                    JButton ok = new JButton("OK");
                    box2.add(ok);
                    box2.add(Box.createHorizontalGlue());
                    ((JComponent)win).getRootPane().setDefaultButton(ok);
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HBCICallbackSwing.this.removeWin(currentData, winname);
                            sync.stopWaiting();
                        }
                    });
                    ok.requestFocus();
                    sync.stopWaiting();
                    HBCICallbackSwing.this.drawWin(currentData, winname);
                }
                catch (Exception e) {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CALLB_ERR"), e);
                }
            }
        });
        sync.startWaiting();
    }

    protected void showInstMessage(Hashtable<String, Object> currentData, String winname) {
        this.showInstMessage(currentData, winname, true);
    }

    protected void showInstMessage(final Hashtable<String, Object> currentData, final String winname, final boolean blocking) {
        final SyncObject sync = new SyncObject();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int msgcounter = (Integer)currentData.get("msgcounter");
                final String winname2 = winname + "_" + msgcounter;
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname2);
                currentData.put("msgcounter", new Integer(msgcounter + 1));
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel label = new JLabel(HBCIUtilsInternal.getLocMsg("GUI_HAVEINSTMSG"));
                label.setFont(new Font("Arial", 0, 10));
                box2.add(label);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(4));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton cancel = new JButton("OK");
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ((JComponent)win).getRootPane().setDefaultButton(cancel);
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname2);
                        sync.stopWaiting();
                    }
                });
                if (!blocking) {
                    sync.stopWaiting();
                }
                HBCICallbackSwing.this.drawWin(currentData, winname2);
            }
        });
        sync.startWaiting();
    }

    protected void showConnectionMessage(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                box2.add(Box.createHorizontalGlue());
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
    }

    private void needSIZEntrySelect(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        final boolean[] aborted = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                final StringBuffer retData = (StringBuffer)currentData.get("retData");
                Object[] tableCols = new String[]{"ID", HBCIUtilsInternal.getLocMsg("BLZ"), HBCIUtilsInternal.getLocMsg("USERID")};
                ArrayList<String[]> data = new ArrayList<String[]>();
                StringTokenizer tok = new StringTokenizer(retData.toString(), "|");
                while (tok.hasMoreTokens()) {
                    String entry = tok.nextToken();
                    StringTokenizer tok2 = new StringTokenizer(entry, ";");
                    data.add(new String[]{tok2.nextToken(), tok2.nextToken(), tok2.nextToken()});
                }
                Object[][] tableData = (String[][])data.toArray((T[])new String[data.size()][]);
                final JTable table = new JTable(tableData, tableCols);
                table.setCellSelectionEnabled(false);
                table.setColumnSelectionAllowed(false);
                table.setRowSelectionAllowed(true);
                table.setSelectionMode(0);
                mainbox.add(table);
                mainbox.add(Box.createVerticalStrut(10));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        retData.replace(0, retData.length(), table.getModel().getValueAt(table.getSelectedRow(), 0).toString());
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        aborted[0] = true;
                        sync.stopWaiting();
                    }
                });
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
        if (aborted[0]) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
    }

    private void needPTSecMech(final Hashtable<String, Object> currentData, final String winname) {
        final SyncObject sync = new SyncObject();
        final boolean[] aborted = new boolean[]{false};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container win = HBCICallbackSwing.this.createWin(currentData, "HBCI", winname);
                Box framebox = Box.createHorizontalBox();
                win.add(framebox);
                framebox.add(Box.createHorizontalStrut(8));
                Box mainbox = Box.createVerticalBox();
                framebox.add(mainbox);
                framebox.add(Box.createHorizontalStrut(8));
                mainbox.add(Box.createVerticalStrut(8));
                Box box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                JLabel l = new JLabel("Passport: " + (String)((HBCIPassport)currentData.get("passport")).getClientData("init"));
                l.setFont(new Font("Arial", 0, 10));
                box2.add(Box.createHorizontalGlue());
                box2.add(l);
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(8));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                box2.add(new JLabel((String)currentData.get("msg")));
                box2.add(Box.createHorizontalGlue());
                mainbox.add(Box.createVerticalStrut(10));
                final StringBuffer retData = (StringBuffer)currentData.get("retData");
                Object[] tableCols = new String[]{"ID", "Name"};
                ArrayList<String[]> data = new ArrayList<String[]>();
                for (String entry : retData.toString().split("\\|")) {
                    String[] values = entry.split(":");
                    data.add(new String[]{values[0], values[1]});
                }
                Object[][] tableData = (String[][])data.toArray((T[])new String[data.size()][]);
                final JTable table = new JTable(tableData, tableCols);
                table.setCellSelectionEnabled(false);
                table.setColumnSelectionAllowed(false);
                table.setRowSelectionAllowed(true);
                table.setSelectionMode(0);
                mainbox.add(table);
                mainbox.add(Box.createVerticalStrut(10));
                box2 = Box.createHorizontalBox();
                mainbox.add(box2);
                mainbox.add(Box.createVerticalStrut(4));
                box2.add(Box.createHorizontalGlue());
                JButton ok = new JButton("OK");
                box2.add(ok);
                ((JComponent)win).getRootPane().setDefaultButton(ok);
                JButton cancel = new JButton(HBCIUtilsInternal.getLocMsg("CANCEL"));
                box2.add(cancel);
                box2.add(Box.createHorizontalGlue());
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        retData.replace(0, retData.length(), table.getModel().getValueAt(table.getSelectedRow(), 0).toString());
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        sync.stopWaiting();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HBCICallbackSwing.this.removeWin(currentData, winname);
                        aborted[0] = true;
                        sync.stopWaiting();
                    }
                });
                HBCICallbackSwing.this.drawWin(currentData, winname);
            }
        });
        sync.startWaiting();
        if (aborted[0]) {
            throw new AbortedException(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_ABORT"));
        }
    }

    protected Container createWin(Hashtable<String, Object> currentData, String title, String winname) {
        JDialog swingDialog = new JDialog((Frame)null, title, true);
        swingDialog.setDefaultCloseOperation(0);
        swingDialog.setResizable(false);
        currentData.put("win_" + winname, swingDialog);
        return swingDialog.getContentPane();
    }

    protected void removeWin(Hashtable<String, Object> currentData, String winname) {
        JDialog swingDialog = (JDialog)currentData.get("win_" + winname);
        swingDialog.dispose();
    }

    protected void drawWin(Hashtable<String, Object> currentData, String winname) {
        JDialog swingDialog = (JDialog)currentData.get("win_" + winname);
        swingDialog.pack();
        swingDialog.setVisible(true);
    }

    private final class SyncObject {
        private boolean stopCalled = false;

        private SyncObject() {
        }

        public synchronized void startWaiting() {
            if (!this.stopCalled) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    throw new HBCI_Exception("*** error in sync object", e);
                }
            }
        }

        public synchronized void stopWaiting() {
            this.stopCalled = true;
            this.notify();
        }
    }
}

