/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.callback;

import java.util.Date;
import java.util.Hashtable;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.ThreadSyncer;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;

public final class HBCICallbackThreaded
extends AbstractHBCICallback {
    private HBCICallback realCallback;

    public HBCICallbackThreaded(HBCICallback realCallback) {
        this.realCallback = realCallback;
    }

    @Override
    public void log(String msg, int level, Date date, StackTraceElement trace) {
        this.realCallback.log(msg, level, date, trace);
    }

    @Override
    public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
        HBCIUtils.log("hbci thread: threaded callback received", 4);
        ThreadSyncer sync_main = (ThreadSyncer)((HBCIPassportInternal)passport).getPersistentData("thread_syncer_main");
        if (sync_main == null) {
            HBCIUtils.log("hbci-thread: non-execute-callback, calling real callback", 4);
            this.realCallback.callback(passport, reason, msg, datatype, retData);
        } else {
            HBCIUtils.log("hbci-thread: this callback is triggered in HBCIHandler.execute()", 4);
            if (this.realCallback.useThreadedCallback(passport, reason, msg, datatype, retData)) {
                Hashtable<String, Object> callbackData = new Hashtable<String, Object>();
                callbackData.put("method", "callback");
                callbackData.put("passport", passport);
                callbackData.put("reason", new Integer(reason));
                callbackData.put("msg", msg);
                callbackData.put("dataType", new Integer(datatype));
                callbackData.put("retData", retData);
                sync_main.setData("callbackData", callbackData);
                sync_main.setData("execStatus", null);
                HBCIUtils.log("hbci thread: callback: awaking main thread with callbackData", 4);
                sync_main.stopWaiting();
                ThreadSyncer sync_hbci = new ThreadSyncer("sync_hbci");
                ((HBCIPassportInternal)passport).setPersistentData("thread_syncer_hbci", sync_hbci);
                HBCIUtils.log("hbci thread: callback: waiting for callback response from main thread;", 4);
                sync_hbci.startWaiting(Integer.parseInt(HBCIUtils.getParam("kernel.threaded.maxwaittime", "300")), "no callback data received from main thread - timeout");
                HBCIUtils.log("hbci thread: callback: got response from main thread - returning callback answer to kernel", 4);
                if (retData != null) {
                    retData.setLength(0);
                    String retValue = (String)sync_hbci.getData("retData");
                    if (retValue != null) {
                        retData.append(retValue);
                    }
                }
            } else {
                this.realCallback.callback(passport, reason, msg, datatype, retData);
            }
        }
    }

    @Override
    public void status(HBCIPassport passport, int statusTag, Object[] o) {
        this.realCallback.status(passport, statusTag, o);
    }
}

