/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.kapott.hbci.comm.Filter;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.protocol.factory.MSGFactory;
import org.kapott.hbci.rewrite.Rewrite;

public abstract class Comm {
    public static final String ENCODING = "ISO-8859-1";
    protected Filter filter;
    private HBCIPassportInternal parentPassport;

    protected abstract void ping(MSG var1);

    protected abstract StringBuffer pong(MsgGen var1);

    protected abstract void closeConnection();

    protected Comm(HBCIPassportInternal parentPassport) {
        this.parentPassport = parentPassport;
        this.filter = parentPassport.getCommFilter();
        HBCIUtilsInternal.getCallback().callback(parentPassport, 24, HBCIUtilsInternal.getLocMsg("CALLB_NEED_CONN"), 0, new StringBuffer());
    }

    public MSG pingpong(String msgName, MSG msg) {
        IHandlerData handler = this.getParentPassport().getParentHandlerData();
        MsgGen gen = handler.getMsgGen();
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.getParentPassport(), 24, null);
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.getParentPassport(), 30, msg.toString(0));
        this.ping(msg);
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.getParentPassport(), 27, null);
        String st = this.pong(gen).toString();
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.getParentPassport(), 32, st);
        HBCIUtils.log("received message: " + st, 5);
        MSG retmsg = null;
        try {
            String rewriters_st = HBCIUtils.getParam("kernel.rewriter");
            ArrayList<Rewrite> al = new ArrayList<Rewrite>();
            StringTokenizer tok = new StringTokenizer(rewriters_st, ",");
            while (tok.hasMoreTokens()) {
                String rewriterName = tok.nextToken().trim();
                if (rewriterName.length() == 0) continue;
                Class<?> cl = this.getClass().getClassLoader().loadClass("org.kapott.hbci.rewrite.R" + rewriterName);
                Constructor<?> con = cl.getConstructor(null);
                Rewrite rewriter = (Rewrite)con.newInstance(null);
                al.add(rewriter);
            }
            Rewrite[] rewriters = al.toArray(new Rewrite[al.size()]);
            for (int i = 0; i < rewriters.length; ++i) {
                st = rewriters[i].incomingCrypted(st, gen);
            }
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.getParentPassport(), 28, "CryptedRes");
            try {
                HBCIUtils.log("trying to parse message as crypted message", 4);
                retmsg = MSGFactory.getInstance().createMSG("CryptedRes", st, st.length(), gen, false);
            }
            catch (ParseErrorException e) {
                HBCIUtils.log("message seems not to be encrypted; tring to parse it as " + msgName + "Res message", 4);
                gen.set("_origSignedMsg", st);
                for (int i = 0; i < rewriters.length; ++i) {
                    st = rewriters[i].incomingClearText(st, gen);
                }
                HBCIUtilsInternal.getCallback().status((HBCIPassport)this.getParentPassport(), 28, msgName + "Res");
                retmsg = MSGFactory.getInstance().createMSG(msgName + "Res", st, st.length(), gen);
            }
        }
        catch (Exception ex) {
            throw new CanNotParseMessageException(HBCIUtilsInternal.getLocMsg("EXCMSG_CANTPARSE"), st, ex);
        }
        return retmsg;
    }

    public static Comm getInstance(String name, HBCIPassportInternal passport) {
        try {
            Class<?> cl = Class.forName("org.kapott.hbci.comm.Comm" + name);
            Constructor<?> cons = cl.getConstructor(HBCIPassportInternal.class);
            return (Comm)cons.newInstance(passport);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANTCREATECOMM", name), e);
        }
    }

    protected HBCIPassportInternal getParentPassport() {
        return this.parentPassport;
    }

    public void close() {
        this.closeConnection();
        HBCIUtilsInternal.getCallback().callback(this.getParentPassport(), 25, HBCIUtilsInternal.getLocMsg("CALLB_CLOSE_CONN"), 0, new StringBuffer());
    }
}

