/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.kapott.hbci.comm.LoggingInputStream;
import org.kapott.hbci.comm.LoggingOutputStream;

public class LoggingSocket
extends SSLSocket {
    private SSLSocket targetSocket;
    private OutputStream logger;

    public LoggingSocket(Socket targetSocket, OutputStream logger) {
        this.targetSocket = (SSLSocket)targetSocket;
        this.logger = logger;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        LoggingInputStream logInputStream = new LoggingInputStream(this.targetSocket.getInputStream(), this.logger);
        return logInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        LoggingOutputStream outputStream = new LoggingOutputStream(this.targetSocket.getOutputStream(), this.logger);
        return outputStream;
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.targetSocket.addHandshakeCompletedListener(arg0);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.targetSocket.bind(bindpoint);
    }

    @Override
    public void close() throws IOException {
        this.targetSocket.close();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.targetSocket.connect(endpoint, timeout);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.targetSocket.connect(endpoint);
    }

    public boolean equals(Object obj) {
        return this.targetSocket.equals(obj);
    }

    @Override
    public SocketChannel getChannel() {
        return this.targetSocket.getChannel();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.targetSocket.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.targetSocket.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.targetSocket.getEnableSessionCreation();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.targetSocket.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.targetSocket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.targetSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.targetSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.targetSocket.getLocalSocketAddress();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.targetSocket.getNeedClientAuth();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.targetSocket.getOOBInline();
    }

    @Override
    public int getPort() {
        return this.targetSocket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.targetSocket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.targetSocket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.targetSocket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.targetSocket.getSendBufferSize();
    }

    @Override
    public SSLSession getSession() {
        return this.targetSocket.getSession();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.targetSocket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.targetSocket.getSoTimeout();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.targetSocket.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.targetSocket.getSupportedProtocols();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.targetSocket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.targetSocket.getTrafficClass();
    }

    @Override
    public boolean getUseClientMode() {
        return this.targetSocket.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.targetSocket.getWantClientAuth();
    }

    public int hashCode() {
        return this.targetSocket.hashCode();
    }

    @Override
    public boolean isBound() {
        return this.targetSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.targetSocket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.targetSocket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.targetSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.targetSocket.isOutputShutdown();
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.targetSocket.removeHandshakeCompletedListener(arg0);
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.targetSocket.sendUrgentData(data);
    }

    @Override
    public void setEnabledCipherSuites(String[] arg0) {
        this.targetSocket.setEnabledCipherSuites(arg0);
    }

    @Override
    public void setEnabledProtocols(String[] arg0) {
        this.targetSocket.setEnabledProtocols(arg0);
    }

    @Override
    public void setEnableSessionCreation(boolean arg0) {
        this.targetSocket.setEnableSessionCreation(arg0);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.targetSocket.setKeepAlive(on);
    }

    @Override
    public void setNeedClientAuth(boolean arg0) {
        this.targetSocket.setNeedClientAuth(arg0);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.targetSocket.setOOBInline(on);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.targetSocket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.targetSocket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.targetSocket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.targetSocket.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.targetSocket.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.targetSocket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.targetSocket.setTrafficClass(tc);
    }

    @Override
    public void setUseClientMode(boolean arg0) {
        this.targetSocket.setUseClientMode(arg0);
    }

    @Override
    public void setWantClientAuth(boolean arg0) {
        this.targetSocket.setWantClientAuth(arg0);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.targetSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.targetSocket.shutdownOutput();
    }

    @Override
    public void startHandshake() throws IOException {
        this.targetSocket.startHandshake();
    }

    @Override
    public String toString() {
        return this.targetSocket.toString();
    }
}

