/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.kapott.hbci.comm.HBCI4JavaLogOutputStream;
import org.kapott.hbci.comm.LoggingSocket;
import org.kapott.hbci.comm.PinTanSSLTrustManager;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractPinTanPassport;

public class PinTanSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory realSocketFactory;

    public PinTanSSLSocketFactory(AbstractPinTanPassport passport) {
        try {
            if (!passport.getCheckCert()) {
                HBCIUtils.log("creating socket factory with disabled cert checking", 2);
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new PinTanSSLTrustManager()}, new SecureRandom());
                this.realSocketFactory = sslContext.getSocketFactory();
            } else {
                HBCIUtils.log("using system socket factory", 4);
                this.realSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean debug() {
        return HBCIUtils.getParam("log.ssl.enable", "0").equals("1");
    }

    private OutputStream getLogger() {
        OutputStream result;
        String filename = HBCIUtils.getParam("log.ssl.filename");
        if (filename == null || filename.length() == 0) {
            HBCIUtils.log("no log.ssl.filename specified - logging to HBCI4Java logger", 2);
            result = new HBCI4JavaLogOutputStream();
        } else {
            try {
                result = new FileOutputStream(filename, true);
                result.write(10);
                result.write(HBCIUtils.datetime2StringISO(new Date()).getBytes("ISO-8859-1"));
                result.write(10);
                result.flush();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public Socket createSocket() throws IOException {
        HBCIUtils.log("createSocket()", 5);
        Socket sock = this.realSocketFactory.createSocket();
        if (this.debug()) {
            sock = new LoggingSocket(sock, this.getLogger());
        }
        return sock;
    }

    @Override
    public Socket createSocket(Socket sock, String host, int port, boolean autoClose) throws IOException {
        HBCIUtils.log("createSocket(sock,host,port,autoClose)", 5);
        Socket result = this.realSocketFactory.createSocket(sock, host, port, autoClose);
        if (this.debug()) {
            result = new LoggingSocket(result, this.getLogger());
        }
        return result;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.realSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.realSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        HBCIUtils.log("createSocket(host,port)", 5);
        Socket sock = this.realSocketFactory.createSocket(host, port);
        if (this.debug()) {
            sock = new LoggingSocket(sock, this.getLogger());
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        HBCIUtils.log("createSocket(addr,port)", 5);
        Socket sock = this.realSocketFactory.createSocket(addr, port);
        if (this.debug()) {
            sock = new LoggingSocket(sock, this.getLogger());
        }
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        HBCIUtils.log("createSocket(host,port,localHost,localPort)", 5);
        Socket sock = this.realSocketFactory.createSocket(host, port, localHost, localPort);
        if (this.debug()) {
            sock = new LoggingSocket(sock, this.getLogger());
        }
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress localHost, int localPort) throws IOException {
        HBCIUtils.log("createSocket(addr,port,localHost,localPort)", 5);
        Socket sock = this.realSocketFactory.createSocket(addr, port, localHost, localPort);
        if (this.debug()) {
            sock = new LoggingSocket(sock, this.getLogger());
        }
        return sock;
    }
}

