/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.concurrent;

import java.util.Properties;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.concurrent.HBCIPassportFactory;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;

public abstract class HBCIRunnable
implements Runnable {
    private final Properties properties;
    private final HBCICallback callback;
    private HBCIPassportFactory passportFactory;
    protected HBCIPassport passport = null;
    protected HBCIHandler handler = null;

    public HBCIRunnable(Properties properties, HBCICallback callback, HBCIPassportFactory passportFactory) {
        this.properties = properties;
        this.callback = callback;
        this.passportFactory = passportFactory;
    }

    @Override
    public final void run() {
        this.init();
        try {
            this.prepare();
            this.execute();
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
        finally {
            this.done();
        }
    }

    private void init() {
        HBCIUtils.initThread(this.properties, this.callback);
    }

    private void prepare() throws Exception {
        this.passport = this.passportFactory.createPassport();
        if (this.passport != null) {
            String version = this.passport.getHBCIVersion();
            this.handler = new HBCIHandler(version.length() != 0 ? version : "plus", this.passport);
        }
    }

    protected abstract void execute() throws Exception;

    private void done() {
        if (this.handler != null) {
            this.handler.close();
        }
        if (this.passport != null) {
            this.passport.close();
        }
        HBCIUtils.doneThread();
    }
}

