/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.manager.HBCIUtilsInternal;

public abstract class SyntaxDE {
    private String content;

    private void initData(String x, int minsize, int maxsize) {
        this.content = null;
        this.setContent(x, minsize, maxsize);
    }

    public SyntaxDE(String x, int minsize, int maxsize) {
        this.initData(x, minsize, maxsize);
    }

    public void init(String x, int minsize, int maxsize) {
        this.initData(x, minsize, maxsize);
    }

    public void init(StringBuffer x, int minsize, int maxsize) {
        this.initData(x.toString(), minsize, maxsize);
    }

    private void initData() {
        this.content = null;
    }

    protected SyntaxDE() {
        this.initData();
    }

    protected void init() {
        this.initData();
    }

    protected final void setContent(String st, int minsize, int maxsize) {
        int len = st.length();
        if (len < minsize || maxsize != 0 && len > maxsize) {
            String msg = HBCIUtilsInternal.getLocMsg("EXC_DT_INV_STRINGLEN", new Object[]{st, Integer.toString(len), Integer.toString(minsize), Integer.toString(maxsize)});
            if (len == 0 || !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreWrongDataLengthErrors", msg)) {
                throw new InvalidArgumentException(msg);
            }
        }
        this.content = st;
    }

    public String toString(int zero) {
        return this.content != null ? this.content : "";
    }

    protected String getContent() {
        return this.content;
    }

    protected static int skipPreDelim(StringBuffer res) {
        char ch;
        int ret = 0;
        if (res.length() != 0 && ((ch = res.charAt(0)) == '\'' || ch == '+' || ch == ':')) {
            ++ret;
        }
        return ret;
    }

    public static int findNextDelim(StringBuffer res, int startidx) {
        int ret = startidx;
        boolean quoted = false;
        boolean quit = false;
        boolean inBinLen = false;
        int binLenStart = 0;
        int len = res.length();
        while (ret < len && !quit) {
            char ch = res.charAt(ret++);
            if (!quoted) {
                if (ch == '?') {
                    quoted = true;
                    continue;
                }
                if (ch == '@') {
                    if (!inBinLen) {
                        inBinLen = true;
                        binLenStart = ret;
                        continue;
                    }
                    int binLenEnd = ret - 1;
                    String st = res.substring(binLenStart, binLenEnd);
                    int binLen = Integer.parseInt(st);
                    ret += binLen;
                    inBinLen = false;
                    continue;
                }
                if (ch != '\'' && ch != '+' && ch != ':') continue;
                --ret;
                quit = true;
                continue;
            }
            quoted = false;
        }
        return ret;
    }

    public String toString() {
        return this.content == null ? "" : this.content;
    }

    public void destroy() {
        this.content = null;
    }
}

