/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InitializingException;
import org.kapott.hbci.exceptions.NoSuchConstructorException;
import org.kapott.hbci.exceptions.NoSuchSyntaxException;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.tools.ObjectFactory;

public class SyntaxDEFactory {
    private static SyntaxDEFactory instance;
    private Hashtable<String, ObjectFactory> factories = new Hashtable();

    public static synchronized SyntaxDEFactory getInstance() {
        if (instance == null) {
            instance = new SyntaxDEFactory();
        }
        return instance;
    }

    private SyntaxDEFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxDE createSyntaxDE(String dataType, String path, String value, int minsize, int maxsize) {
        ObjectFactory factory;
        SyntaxDE ret = null;
        SyntaxDEFactory syntaxDEFactory = this;
        synchronized (syntaxDEFactory) {
            factory = this.factories.get(dataType);
            if (factory == null) {
                factory = new ObjectFactory(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.Syntax", "1024")));
                this.factories.put(dataType, factory);
            }
        }
        ret = (SyntaxDE)factory.getFreeObject();
        if (ret == null) {
            Constructor<?> con;
            Class<?> c;
            try {
                c = Class.forName("org.kapott.hbci.datatypes.Syntax" + dataType, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchSyntaxException(dataType, path);
            }
            try {
                con = c.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchConstructorException(dataType);
            }
            try {
                ret = (SyntaxDE)con.newInstance(value, new Integer(minsize), new Integer(maxsize));
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new InitializingException((Exception)e.getCause(), path);
            }
            if (ret != null) {
                factory.addToUsedPool(ret);
            }
        } else {
            try {
                ret.init(value, minsize, maxsize);
                factory.addToUsedPool(ret);
            }
            catch (RuntimeException e) {
                factory.addToFreePool(ret);
                throw new InitializingException(e, path);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxDE createSyntaxDE(String dataType, String path, StringBuffer res, int minsize, int maxsize) {
        ObjectFactory factory;
        SyntaxDE ret = null;
        SyntaxDEFactory syntaxDEFactory = this;
        synchronized (syntaxDEFactory) {
            factory = this.factories.get(dataType);
            if (factory == null) {
                factory = new ObjectFactory(Integer.parseInt(HBCIUtils.getParam("kernel.objpool.Syntax", "1024")));
                this.factories.put(dataType, factory);
            }
        }
        ret = (SyntaxDE)factory.getFreeObject();
        if (ret == null) {
            Constructor<?> con;
            Class<?> c;
            try {
                c = Class.forName("org.kapott.hbci.datatypes.Syntax" + dataType, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchSyntaxException(dataType, path);
            }
            try {
                con = c.getConstructor(StringBuffer.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchConstructorException(dataType);
            }
            try {
                ret = (SyntaxDE)con.newInstance(res, new Integer(minsize), new Integer(maxsize));
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new ParseErrorException(HBCIUtilsInternal.getLocMsg("EXCMSG_PROT_ERRSYNDE", path), (Exception)e.getCause());
            }
            if (ret != null) {
                factory.addToUsedPool(ret);
            }
        } else {
            try {
                ret.init(res, minsize, maxsize);
                factory.addToUsedPool(ret);
            }
            catch (RuntimeException e) {
                factory.addToFreePool(ret);
                throw new ParseErrorException(HBCIUtilsInternal.getLocMsg("EXCMSG_PROT_ERRSYNDE", path), (Exception)e.getCause());
            }
        }
        return ret;
    }

    public void unuseObject(SyntaxDE sde, String type) {
        if (sde != null) {
            sde.destroy();
            ObjectFactory fac = this.factories.get(type);
            fac.unuseObject(sde);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Enumeration<String> e = this.factories.keys();
        while (e.hasMoreElements()) {
            String type = e.nextElement();
            ObjectFactory fac = this.factories.get(type);
            ret.append(type).append(": ").append(fac.toString()).append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }
}

