/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kapott.hbci.dialog.AbstractRawHBCIDialog;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public class HBCIDialogEnd
extends AbstractRawHBCIDialog {
    private List<Flag> flags = new ArrayList<Flag>();

    public HBCIDialogEnd(Flag ... flags) {
        super(KnownDialogTemplate.END);
        if (flags != null) {
            this.flags.addAll(Arrays.asList(flags));
        }
    }

    @Override
    protected void applyData(DialogContext ctx) {
        super.applyData(ctx);
        HBCIKernelImpl k = ctx.getKernel();
        k.rawSet("DialogEndS.dialogid", ctx.getDialogId());
    }

    @Override
    protected HBCIMsgStatus sendData(DialogContext ctx) {
        if (this.flags.contains((Object)Flag.SIG_ID)) {
            HBCIPassportInternal p = ctx.getPassport();
            return ctx.getKernel().rawDoIt(p.hasMySigKey(), true, p.hasMyEncKey());
        }
        return super.sendData(ctx);
    }

    @Override
    protected void checkResult(DialogContext ctx) {
        super.checkResult(ctx);
        HBCIMsgStatus ret = ctx.getMsgStatus();
        HBCIUtilsInternal.getCallback().status((HBCIPassport)ctx.getPassport(), 20, ret);
        if (ret.isOK()) {
            return;
        }
        String msg = HBCIUtilsInternal.getLocMsg("ERR_INST_ENDFAILED");
        boolean ignore = ctx.isAnonymous() || this.flags.contains((Object)Flag.ACCEPT_ERROR) || HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreDialogEndErrors", msg + ": " + ret.getErrorString());
        HBCIUtils.log("dialog end failed: " + ret.getErrorString(), ignore ? 2 : 1);
        ProcessException e = new ProcessException(msg, ret);
        ret.addException(e);
        if (!ignore) {
            throw e;
        }
    }

    @Override
    protected String getActualTemplate(DialogContext ctx) {
        return this.getTemplate().getName() + (ctx.isAnonymous() ? "Anon" : "");
    }

    public static enum Flag {
        SIG_ID,
        ACCEPT_ERROR;

    }
}

