/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import org.kapott.hbci.dialog.AbstractRawHBCIDialogInit;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public class HBCIDialogSync
extends AbstractRawHBCIDialogInit {
    private Mode mode = null;

    public HBCIDialogSync(Mode mode) {
        super(KnownDialogTemplate.SYNC);
        this.mode = mode;
    }

    @Override
    protected void applyData(DialogContext ctx) {
        super.applyData(ctx);
        HBCIPassportInternal p = ctx.getPassport();
        HBCIKernelImpl k = ctx.getKernel();
        k.rawSet("Idn.customerid", p.getCustomerId());
        if (this.mode == Mode.SYS_ID) {
            k.rawSet("Idn.sysid", "0");
            k.rawSet("Idn.sysStatus", "1");
            k.rawSet("Sync.mode", "0");
        } else {
            k.rawSet("Idn.sysid", p.getSysId());
            k.rawSet("Idn.sysStatus", p.getSysStatus());
            k.rawSet("Sync.mode", "2");
        }
        if (!ctx.isAnonymous()) {
            k.rawSet("ProcPrep.BPD", "0");
        }
    }

    @Override
    protected HBCIMsgStatus sendData(DialogContext ctx) {
        if (this.mode == Mode.SIG_ID) {
            HBCIPassportInternal p = ctx.getPassport();
            return ctx.getKernel().rawDoIt(p.hasMySigKey(), true, p.hasMyEncKey());
        }
        return super.sendData(ctx);
    }

    @Override
    protected void checkResult(DialogContext ctx) {
        super.checkResult(ctx);
        HBCIMsgStatus ret = ctx.getMsgStatus();
        if (ret.isOK()) {
            return;
        }
        throw new ProcessException(HBCIUtilsInternal.getLocMsg(this.mode == Mode.SIG_ID ? "EXCMSG_SYNCSIGIDFAIL" : "EXCMSG_SYNCSYSIDFAIL"), ret);
    }

    public static enum Mode {
        SYS_ID,
        SIG_ID;

    }
}

