/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Objects;
import java.util.Properties;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.HBCIDialogEnd;
import org.kapott.hbci.dialog.HBCIDialogInit;
import org.kapott.hbci.dialog.HBCIDialogTanMedia;
import org.kapott.hbci.dialog.HBCIProcess;
import org.kapott.hbci.dialog.SCARequest;
import org.kapott.hbci.manager.Feature;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;

public class HBCIProcessTanMedia
implements HBCIProcess {
    private HBCIDialogTanMedia dialog = new HBCIDialogTanMedia();
    private boolean force = false;

    public HBCIProcessTanMedia(boolean force) {
        this.force = force;
    }

    @Override
    public HBCIMsgStatus execute(DialogContext ctx) {
        if (!this.dialog.supported(ctx)) {
            return null;
        }
        if (!this.force && !this.dialog.required(ctx)) {
            return null;
        }
        boolean skip = Feature.PINTAN_INIT_SKIPONESTEPSCA.isEnabled();
        try {
            return this.execute(ctx, skip);
        }
        catch (Exception e) {
            HBCIUtils.log("failed: " + e.getMessage(), 3);
            HBCIUtils.log(e, 4);
            if (skip) {
                try {
                    return this.execute(ctx, false);
                }
                catch (Exception e2) {
                    HBCIUtils.log("fetching of TAN media names failed: " + e.getMessage(), 3);
                    HBCIUtils.log(e, 4);
                }
            }
            return null;
        }
    }

    private HBCIMsgStatus execute(DialogContext ctx, final boolean skipSCA) {
        HBCIUtils.log("trying to fetch TAN media names [skip sca: " + skipSCA + "]", 3);
        HBCIDialogInit init = new HBCIDialogInit(){

            @Override
            public SCARequest createSCARequest(Properties secmechInfo, int hktanVersion) {
                if (!skipSCA) {
                    return null;
                }
                SCARequest r = super.createSCARequest(secmechInfo, hktanVersion);
                r.setTanReference("HKTAB");
                String needed = secmechInfo != null ? secmechInfo.getProperty("needtanmedia", "") : "";
                r.setTanMedia(Objects.equals(needed, "2") ? "noref" : "");
                return r;
            }
        };
        init.execute(ctx);
        this.dialog.execute(ctx);
        HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
        return end.execute(ctx);
    }
}

