/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Objects;
import org.kapott.hbci.tools.StringUtil;

public enum KnownTANProcess {
    PROCESS1("1"),
    PROCESS2_STEP1("4"),
    PROCESS2_STEP2("2"),
    PROCESS2_STEPS("S");

    private String code = null;

    private KnownTANProcess(String code) {
        this.code = code;
    }

    public boolean is(String code) {
        return code != null && this.code.equals(code);
    }

    public String getCode() {
        return this.code;
    }

    public static KnownTANProcess get(Variant v, int step) {
        if (v == Variant.V1) {
            return PROCESS1;
        }
        return step == 2 ? PROCESS2_STEP2 : PROCESS2_STEP1;
    }

    public static enum Variant {
        V1("1"),
        V2("2");

        private static final Variant DEFAULT;
        private String code = null;

        private Variant(String code) {
            this.code = code;
        }

        public static final Variant determine(String code) {
            if (!StringUtil.hasText(code)) {
                return DEFAULT;
            }
            for (Variant v : Variant.values()) {
                if (!Objects.equals(code, v.code)) continue;
                return v;
            }
            return DEFAULT;
        }

        static {
            DEFAULT = V2;
        }
    }
}

