/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.examples;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class UmsatzAbrufPinTan {
    private static final String BLZ = "12345678";
    private static final String USER = "1234567890";
    private static final String PIN = "12345";
    private static final HBCIVersion VERSION = HBCIVersion.HBCI_300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        HBCIUtils.init(props, new MyHBCICallback());
        File passportFile = new File("testpassport.dat");
        HBCIUtils.setParam("client.passport.default", "PinTan");
        HBCIUtils.setParam("client.passport.PinTan.init", "1");
        HBCIPassport passport = AbstractHBCIPassport.getInstance(passportFile);
        passport.setCountry("DE");
        BankInfo info = HBCIUtils.getBankInfo(BLZ);
        passport.setHost(info.getPinTanAddress());
        passport.setPort(443);
        passport.setFilterType("Base64");
        HBCIHandler handle = null;
        try {
            GVRSaldoReq saldoResult;
            handle = new HBCIHandler(VERSION.getId(), passport);
            Konto[] konten = passport.getAccounts();
            if (konten == null || konten.length == 0) {
                UmsatzAbrufPinTan.error("Keine Konten ermittelbar");
            }
            UmsatzAbrufPinTan.log("Anzahl Konten: " + konten.length);
            Konto k = konten[0];
            HBCIJob saldoJob = handle.newJob("SaldoReq");
            saldoJob.setParam("my", k);
            saldoJob.addToQueue();
            HBCIJob umsatzJob = handle.newJob("KUmsAll");
            umsatzJob.setParam("my", k);
            umsatzJob.addToQueue();
            HBCIExecStatus status = handle.execute();
            if (!status.isOK()) {
                UmsatzAbrufPinTan.error(status.toString());
            }
            if (!(saldoResult = (GVRSaldoReq)saldoJob.getJobResult()).isOK()) {
                UmsatzAbrufPinTan.error(saldoResult.toString());
            }
            Value s = saldoResult.getEntries()[0].ready.value;
            UmsatzAbrufPinTan.log("Saldo: " + s.toString());
            GVRKUms result = (GVRKUms)umsatzJob.getJobResult();
            if (!result.isOK()) {
                UmsatzAbrufPinTan.error(result.toString());
            }
            List<GVRKUms.UmsLine> buchungen = result.getFlatData();
            for (GVRKUms.UmsLine buchung : buchungen) {
                List<String> zweck;
                StringBuilder sb = new StringBuilder();
                sb.append(buchung.valuta);
                Value v = buchung.value;
                if (v != null) {
                    sb.append(": ");
                    sb.append(v);
                }
                if ((zweck = buchung.usage) != null && zweck.size() > 0) {
                    sb.append(" - ");
                    sb.append(zweck.get(0));
                }
                UmsatzAbrufPinTan.log(sb.toString());
            }
        }
        finally {
            if (handle != null) {
                handle.close();
            }
            if (passport != null) {
                passport.close();
            }
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static class MyHBCICallback
    extends AbstractHBCICallback {
        private MyHBCICallback() {
        }

        @Override
        public void log(String msg, int level, Date date, StackTraceElement trace) {
        }

        @Override
        public void callback(HBCIPassport passport, int reason, String msg, int datatype, StringBuffer retData) {
            switch (reason) {
                case 21: 
                case 22: {
                    retData.replace(0, retData.length(), UmsatzAbrufPinTan.PIN);
                    break;
                }
                case 16: {
                    retData.replace(0, retData.length(), UmsatzAbrufPinTan.PIN);
                    break;
                }
                case 8: {
                    retData.replace(0, retData.length(), UmsatzAbrufPinTan.BLZ);
                    break;
                }
                case 11: {
                    retData.replace(0, retData.length(), UmsatzAbrufPinTan.USER);
                    break;
                }
                case 18: {
                    retData.replace(0, retData.length(), UmsatzAbrufPinTan.USER);
                    break;
                }
                case 33: {
                    try {
                        String tan = null;
                        retData.replace(0, retData.length(), tan);
                        break;
                    }
                    catch (Exception e) {
                        throw new HBCI_Exception(e);
                    }
                }
                case 34: {
                    try {
                        String tan = null;
                        retData.replace(0, retData.length(), tan);
                        break;
                    }
                    catch (Exception e) {
                        throw new HBCI_Exception(e);
                    }
                }
                case 27: {
                    String code = "";
                    retData.replace(0, retData.length(), code);
                    break;
                }
                case 17: {
                    String flicker = retData.toString();
                    if (flicker != null && flicker.length() > 0) {
                        String tan = null;
                        retData.replace(0, retData.length(), tan);
                        break;
                    }
                    String tan = null;
                    retData.replace(0, retData.length(), tan);
                    break;
                }
                case 32: {
                    String alias = null;
                    retData.replace(0, retData.length(), alias);
                    break;
                }
                case 20: {
                    UmsatzAbrufPinTan.log(msg);
                    break;
                }
            }
        }

        @Override
        public void status(HBCIPassport passport, int statusTag, Object[] o) {
        }
    }
}

