/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.exceptions;

import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.LogFilter;

public class HBCI_Exception
extends RuntimeException {
    private boolean fatal = false;

    protected static String applyLogFilter(String st) {
        try {
            int filterLevel = Integer.parseInt(HBCIUtils.getParam("log.filter", "2"));
            if (filterLevel != 0) {
                st = LogFilter.getInstance().filterLine(st, filterLevel);
            }
        }
        catch (Exception e) {
            System.out.println("strange exception: " + e);
        }
        return st;
    }

    public HBCI_Exception() {
    }

    public HBCI_Exception(String s) {
        super(HBCI_Exception.applyLogFilter(s));
    }

    public HBCI_Exception(Throwable e) {
        super(null, e);
    }

    public HBCI_Exception(String st, Throwable e) {
        super(HBCI_Exception.applyLogFilter(st), e);
    }

    public void setFatal(boolean b) {
        this.fatal = b;
    }

    public boolean isFatal() {
        if (this.fatal) {
            return true;
        }
        Throwable t = this.getCause();
        if (t == this) {
            return false;
        }
        if (t instanceof HBCI_Exception) {
            return ((HBCI_Exception)t).isFatal();
        }
        return false;
    }
}

