/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.lang.reflect.Constructor;
import java.security.KeyPair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.GV.GVTemplate;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.Feature;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIUser;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.manager.ThreadSyncer;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIExecThreadedStatus;

public final class HBCIHandler
implements IHandlerData,
AutoCloseable {
    public static final int REFRESH_BPD = 1;
    public static final int REFRESH_UPD = 2;
    private HBCIKernelImpl kernel;
    private HBCIPassportInternal passport;
    private Map<String, HBCIDialog> dialogs;

    public HBCIHandler(String hbciversion, HBCIPassport passport) {
        this(hbciversion, passport, false);
    }

    public HBCIHandler(String hbciversion, HBCIPassport passport, boolean lazyInit) {
        try {
            if (passport == null) {
                throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_NULL"));
            }
            if (hbciversion == null) {
                hbciversion = passport.getHBCIVersion();
            }
            if (hbciversion.length() == 0) {
                throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_NO_HBCIVERSION"));
            }
            this.kernel = new HBCIKernelImpl(this, hbciversion);
            this.passport = (HBCIPassportInternal)passport;
            this.passport.setParentHandlerData(this);
            if (!lazyInit) {
                if (passport instanceof AbstractPinTanPassport && Feature.INIT_FLIP_USER_INST.isEnabled()) {
                    this.registerUser();
                    this.registerInstitute();
                } else {
                    this.registerInstitute();
                    this.registerUser();
                }
            }
            if (!passport.getHBCIVersion().equals(hbciversion)) {
                this.passport.setHBCIVersion(hbciversion);
                this.passport.saveChanges();
            }
            this.dialogs = new Hashtable<String, HBCIDialog>();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANT_CREATE_HANDLE"), e);
        }
    }

    public HBCIExecThreadedStatus initThreaded() {
        HBCIUtils.log("main thread: starting new threaded init", 4);
        final ThreadSyncer sync_main = new ThreadSyncer("sync_main");
        this.passport.setPersistentData("thread_syncer_main", sync_main);
        new Thread(){

            @Override
            public void run() {
                try {
                    HBCIUtils.log("hbci thread: starting init()", 4);
                    if (Feature.INIT_FLIP_USER_INST.isEnabled()) {
                        HBCIHandler.this.registerUser();
                        HBCIHandler.this.registerInstitute();
                    } else {
                        HBCIHandler.this.registerInstitute();
                        HBCIHandler.this.registerUser();
                    }
                    sync_main.setData("execStatus", null);
                }
                catch (Exception e) {
                    sync_main.setData("execStatus", null);
                }
                finally {
                    HBCIHandler.this.passport.setPersistentData("thread_syncer_main", null);
                    HBCIUtils.log("hbci thread: awaking main thread with hbci result data", 4);
                    sync_main.setData("callbackData", null);
                    sync_main.stopWaiting();
                    HBCIUtils.log("hbci thread: thread finished", 4);
                }
            }
        }.start();
        HBCIUtils.log("main thread: waiting for hbci result or callback data from hbci thread", 4);
        sync_main.startWaiting(Integer.parseInt(HBCIUtils.getParam("kernel.threaded.maxwaittime", "300")), "no response from hbci thread - timeout");
        HBCIExecThreadedStatus threadStatus = new HBCIExecThreadedStatus();
        threadStatus.setCallbackData((Hashtable)sync_main.getData("callbackData"));
        threadStatus.setExecStatus((HBCIExecStatus)sync_main.getData("execStatus"));
        HBCIUtils.log("main thread: received answer from hbci thread, returning status (isCallback=" + threadStatus.isCallback() + ", isFinished=" + threadStatus.isFinished() + ")", 4);
        return threadStatus;
    }

    private void registerInstitute() {
        try {
            HBCIUtils.log("registering institute", 4);
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.register();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANT_REG_INST"), ex);
        }
    }

    private void registerUser() {
        try {
            HBCIUtils.log("registering user", 4);
            HBCIUser user = new HBCIUser(this.kernel, this.passport, false);
            user.register();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANT_REG_USER"), ex);
        }
    }

    @Override
    public void sync(boolean force) {
        HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
        inst.sync(force);
        HBCIUser user = new HBCIUser(this.kernel, this.passport, false);
        user.sync(force);
    }

    @Override
    public void close() {
        if (this.passport != null) {
            try {
                this.passport.close();
            }
            catch (Exception e) {
                HBCIUtils.log(e);
            }
        }
        this.passport = null;
        this.kernel = null;
        this.dialogs = null;
    }

    private String fixUnspecifiedCustomerId(String customerId) {
        if (customerId == null) {
            customerId = this.passport.getCustomerId();
            HBCIUtils.log("using default customerid " + customerId, 4);
        }
        return customerId;
    }

    private HBCIDialog getDialogFor(String customerId) {
        HBCIDialog dialog = this.dialogs.get(customerId);
        if (dialog == null) {
            HBCIUtils.log("have to create new dialog for customerid " + customerId, 4);
            dialog = new HBCIDialog(this);
            this.dialogs.put(customerId, dialog);
        }
        return dialog;
    }

    public void newMsg(String customerId) {
        HBCIUtils.log("have to create new message for dialog for customer " + customerId, 4);
        this.getDialogFor(this.fixUnspecifiedCustomerId(customerId)).newMsg();
    }

    public void newMsg() {
        this.newMsg(null);
    }

    public HBCIJob newJob(String jobname) {
        HBCIJobImpl ret;
        block4: {
            HBCIUtils.log("creating new job " + jobname, 4);
            if (jobname == null || jobname.length() == 0) {
                throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
            }
            ret = null;
            String className = "org.kapott.hbci.GV.GV" + jobname;
            try {
                Class<?> cl = Class.forName(className);
                Constructor<?> cons = cl.getConstructor(HBCIHandler.class);
                ret = (HBCIJobImpl)cons.newInstance(this);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidUserDataException("*** there is no highlevel job named " + jobname + " - need class " + className);
            }
            catch (Exception e) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_JOB_CREATE_ERR", jobname);
                if (HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreCreateJobErrors", msg)) break block4;
                throw new HBCI_Exception(msg, e);
            }
        }
        return ret;
    }

    public HBCIJob newLowlevelJob(String gvname) {
        HBCIUtils.log("generating new lowlevel-job " + gvname, 4);
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        GVTemplate ret = new GVTemplate(gvname, this);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobToDialog(String customerId, HBCIJob job) {
        customerId = this.fixUnspecifiedCustomerId(customerId);
        HBCIDialog dialog = null;
        try {
            dialog = this.getDialogFor(customerId);
            dialog.addTask((HBCIJobImpl)job);
        }
        finally {
            if (dialog != null && dialog.getMessageQueue().getTaskCount() == 0) {
                HBCIUtils.log("removing empty dialog for customerid " + customerId + " from list of dialogs", 4);
                this.dialogs.remove(customerId);
            }
        }
    }

    public void addJob(String customerId, HBCIJob job) {
        this.addJobToDialog(customerId, job);
    }

    public void addJob(HBCIJob job) {
        this.addJob(null, job);
    }

    public void createEmptyDialog(String customerId) {
        customerId = this.fixUnspecifiedCustomerId(customerId);
        HBCIUtils.log("creating empty dialog for customerid " + customerId, 4);
        this.getDialogFor(customerId);
    }

    public void createEmptyDialog() {
        this.createEmptyDialog(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBCIExecStatus execute() {
        HBCIExecStatus hBCIExecStatus;
        String origCustomerId = this.passport.getCustomerId();
        try {
            HBCIExecStatus ret = new HBCIExecStatus();
            while (!this.dialogs.isEmpty()) {
                String customerid = this.dialogs.keySet().iterator().next();
                HBCIUtils.log("executing dialog for customerid " + customerid, 4);
                this.passport.setCustomerId(customerid);
                try {
                    HBCIDialog dialog = this.getDialogFor(customerid);
                    HBCIDialogStatus dialogStatus = dialog.doIt();
                    ret.addDialogStatus(customerid, dialogStatus);
                }
                catch (Exception e) {
                    ret.addException(customerid, e);
                }
                finally {
                    this.dialogs.remove(customerid);
                }
            }
            hBCIExecStatus = ret;
            this.reset();
        }
        catch (Throwable throwable) {
            this.reset();
            this.passport.setCustomerId(origCustomerId);
            try {
                this.passport.closeComm();
            }
            catch (Exception e) {
                HBCIUtils.log("nested exception while closing passport: ", 1);
                HBCIUtils.log(e);
            }
            throw throwable;
        }
        this.passport.setCustomerId(origCustomerId);
        try {
            this.passport.closeComm();
        }
        catch (Exception e) {
            HBCIUtils.log("nested exception while closing passport: ", 1);
            HBCIUtils.log(e);
        }
        return hBCIExecStatus;
    }

    public HBCIExecThreadedStatus executeThreaded() {
        HBCIUtils.log("main thread: starting new threaded execute", 4);
        final ThreadSyncer sync_main = new ThreadSyncer("sync_main");
        this.passport.setPersistentData("thread_syncer_main", sync_main);
        new Thread(){

            @Override
            public void run() {
                try {
                    HBCIUtils.log("hbci thread: starting execute()", 4);
                    HBCIExecStatus execStatus = HBCIHandler.this.execute();
                    sync_main.setData("execStatus", execStatus);
                }
                catch (Exception e) {
                    sync_main.setData("execStatus", null);
                }
                finally {
                    HBCIHandler.this.passport.setPersistentData("thread_syncer_main", null);
                    HBCIUtils.log("hbci thread: awaking main thread with hbci result data", 4);
                    sync_main.setData("callbackData", null);
                    sync_main.stopWaiting();
                    HBCIUtils.log("hbci thread: thread finished", 4);
                }
            }
        }.start();
        HBCIUtils.log("main thread: waiting for hbci result or callback data from hbci thread", 4);
        sync_main.startWaiting(Integer.parseInt(HBCIUtils.getParam("kernel.threaded.maxwaittime", "300")), "no response from hbci thread - timeout");
        HBCIExecThreadedStatus threadStatus = new HBCIExecThreadedStatus();
        threadStatus.setCallbackData((Hashtable)sync_main.getData("callbackData"));
        threadStatus.setExecStatus((HBCIExecStatus)sync_main.getData("execStatus"));
        HBCIUtils.log("main thread: received answer from hbci thread, returning status (isCallback=" + threadStatus.isCallback() + ", isFinished=" + threadStatus.isFinished() + ")", 4);
        return threadStatus;
    }

    public HBCIExecThreadedStatus continueThreaded(String retData) {
        HBCIUtils.log("main thread: continuing hbci dialog with callback retData", 4);
        ThreadSyncer sync_hbci = (ThreadSyncer)this.passport.getPersistentData("thread_syncer_hbci");
        sync_hbci.setData("retData", retData);
        HBCIUtils.log("main thread: awaking hbci thread with callback data from application", 4);
        sync_hbci.stopWaiting();
        ThreadSyncer sync_main = (ThreadSyncer)this.passport.getPersistentData("thread_syncer_main");
        HBCIUtils.log("main thread: waiting for hbci result or new callback data from hbci thread", 4);
        sync_main.startWaiting(Integer.parseInt(HBCIUtils.getParam("kernel.threaded.maxwaittime", "300")), "no response from hbci thread - timeout");
        HBCIExecThreadedStatus threadStatus = new HBCIExecThreadedStatus();
        threadStatus.setCallbackData((Hashtable)sync_main.getData("callbackData"));
        threadStatus.setExecStatus((HBCIExecStatus)sync_main.getData("execStatus"));
        HBCIUtils.log("main thread: received answer from hbci thread, returning status (isCallback=" + threadStatus.isCallback() + ", isFinished=" + threadStatus.isFinished() + ")", 4);
        return threadStatus;
    }

    public void lockKeys() {
        try {
            new HBCIUser(this.kernel, this.passport, false).lockKeys();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), ex);
        }
    }

    public void newKeys() {
        try {
            new HBCIUser(this.kernel, this.passport, false).generateNewKeys();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GENKEYS_ERR"), ex);
        }
    }

    public void setKeys(KeyPair sigKey, KeyPair encKey) {
        try {
            new HBCIUser(this.kernel, this.passport, false).manuallySetNewKeys(sigKey, encKey);
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SETKEYS_ERR"), ex);
        }
    }

    public HBCIExecStatus verifyTAN(String customerId) {
        this.reset();
        this.createEmptyDialog(customerId);
        ((AbstractPinTanPassport)this.passport).activateTANVerifyMode();
        return this.execute();
    }

    public HBCIExecStatus verifyTAN() {
        return this.verifyTAN(null);
    }

    public void reset() {
        this.dialogs.clear();
    }

    @Override
    public HBCIPassport getPassport() {
        return this.passport;
    }

    public HBCIKernel getKernel() {
        return this.kernel;
    }

    @Override
    public MsgGen getMsgGen() {
        return this.kernel.getMsgGen();
    }

    public String getHBCIVersion() {
        return this.kernel.getHBCIVersion();
    }

    public Properties getSupportedLowlevelJobs() {
        Hashtable<String, List<String>> allValidJobNames = this.kernel.getAllLowlevelJobs();
        Properties paramSegments = this.passport.getParamSegmentNames();
        Properties result = new Properties();
        Enumeration<?> e = paramSegments.propertyNames();
        while (e.hasMoreElements()) {
            String segName = (String)e.nextElement();
            if (!allValidJobNames.containsKey(segName)) continue;
            result.put(segName, paramSegments.getProperty(segName));
        }
        return result;
    }

    public List<String> getLowlevelJobParameterNames(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.kernel.getLowlevelJobParameterNames(gvname, version);
    }

    public List<String> getLowlevelJobResultNames(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.kernel.getLowlevelJobResultNames(gvname, version);
    }

    public Properties getLowlevelJobRestrictions(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs().getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.passport.getJobRestrictions(gvname, version);
    }

    public boolean isSupported(String jobnameHL) {
        if (jobnameHL == null || jobnameHL.length() == 0) {
            throw new InvalidArgumentException(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        try {
            Class<?> cl = Class.forName("org.kapott.hbci.GV.GV" + jobnameHL);
            String lowlevelName = (String)cl.getMethod("getLowlevelName", null).invoke(null, (Object[])null);
            return this.getSupportedLowlevelJobs().keySet().contains(lowlevelName);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_HANDLER_HLCHECKERR", jobnameHL), e);
        }
    }

    public HBCIDialogStatus refreshXPD(int selectX) {
        if ((selectX & 1) != 0) {
            this.passport.clearBPD();
        }
        if ((selectX & 2) != 0) {
            this.passport.clearUPD();
        }
        this.reset();
        String customerId = this.passport.getCustomerId();
        this.getDialogFor(customerId);
        HBCIDialogStatus result = this.execute().getDialogStatus(customerId);
        return result;
    }
}

