/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.HBCIDialogEnd;
import org.kapott.hbci.dialog.HBCIDialogFirstKeyRequest;
import org.kapott.hbci.dialog.HBCIDialogInit;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIInstitute
implements IHandlerData {
    private static final String BPD_KEY_LASTUPDATE = "_lastupdate";
    private static final String BPD_KEY_HBCIVERSION = "_hbciversion";
    private HBCIPassportInternal passport;
    private HBCIKernelImpl kernel;

    public HBCIInstitute(HBCIKernelImpl kernel, HBCIPassportInternal passport, boolean forceAsParent) {
        this.kernel = kernel;
        if (forceAsParent || this.kernel.getParentHandlerData() == null) {
            this.kernel.setParentHandlerData(this);
        }
        this.passport = passport;
        if (forceAsParent || this.passport.getParentHandlerData() == null) {
            this.passport.setParentHandlerData(this);
        }
    }

    void updateBPD(Properties result) {
        HBCIUtils.log("extracting BPD from results", 4);
        Properties p = new Properties();
        Enumeration<Object> e = result.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("BPD.")) continue;
            p.setProperty(key.substring("BPD.".length()), result.getProperty(key));
        }
        if (p.size() != 0) {
            p.setProperty(BPD_KEY_HBCIVERSION, this.kernel.getHBCIVersion());
            p.setProperty(BPD_KEY_LASTUPDATE, String.valueOf(System.currentTimeMillis()));
            this.passport.setBPD(p);
            HBCIUtils.log("installed new BPD with version " + this.passport.getBPDVersion(), 4);
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 4, this.passport.getBPD());
        }
    }

    void extractKeys(Properties result) {
        boolean foundChanges;
        block5: {
            foundChanges = false;
            try {
                HBCIUtils.log("extracting public institute keys from results", 4);
                for (int i = 0; i < 3; ++i) {
                    String head = HBCIUtilsInternal.withCounter("SendPubKey", i);
                    String keyType = result.getProperty(head + ".KeyName.keytype");
                    if (keyType == null) continue;
                    String keyCountry = result.getProperty(head + ".KeyName.KIK.country");
                    String keyBLZ = result.getProperty(head + ".KeyName.KIK.blz");
                    String keyUserId = result.getProperty(head + ".KeyName.userid");
                    String keyNum = result.getProperty(head + ".KeyName.keynum");
                    String keyVersion = result.getProperty(head + ".KeyName.keyversion");
                    HBCIUtils.log("found key " + keyCountry + "_" + keyBLZ + "_" + keyUserId + "_" + keyType + "_" + keyNum + "_" + keyVersion, 4);
                    byte[] keyExponent = result.getProperty(head + ".PubKey.exponent").getBytes("ISO-8859-1");
                    byte[] keyModulus = result.getProperty(head + ".PubKey.modulus").getBytes("ISO-8859-1");
                    KeyFactory fac = KeyFactory.getInstance("RSA");
                    RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, keyModulus), new BigInteger(1, keyExponent));
                    PublicKey key = fac.generatePublic(spec);
                    if (keyType.equals("S")) {
                        this.passport.setInstSigKey(new HBCIKey(keyCountry, keyBLZ, keyUserId, keyNum, keyVersion, key));
                        foundChanges = true;
                        continue;
                    }
                    if (!keyType.equals("V")) continue;
                    this.passport.setInstEncKey(new HBCIKey(keyCountry, keyBLZ, keyUserId, keyNum, keyVersion, key));
                    foundChanges = true;
                }
            }
            catch (Exception e) {
                String msg = HBCIUtilsInternal.getLocMsg("EXCMSG_EXTR_IKEYS_ERR");
                if (HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreExtractKeysErrors", msg + ": " + HBCIUtils.exception2String(e))) break block5;
                throw new HBCI_Exception(msg, e);
            }
        }
        if (foundChanges) {
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 6, null);
            this.acknowledgeNewKeys();
        }
    }

    private void acknowledgeNewKeys() {
        StringBuffer answer = new StringBuffer();
        HBCIUtilsInternal.getCallback().callback(this.passport, 12, HBCIUtilsInternal.getLocMsg("CALLB_NEW_INST_KEYS"), 3, answer);
        if (answer.length() > 0) {
            try {
                this.passport.setInstSigKey(null);
                this.passport.setInstEncKey(null);
                this.passport.saveChanges();
            }
            catch (Exception e) {
                HBCIUtils.log(e);
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_KEYSNOTACK"));
        }
    }

    private boolean isBPDExpired() {
        Properties bpd = this.passport.getBPD();
        String maxAge = HBCIUtils.getParam("bpd.maxage.days", "7");
        HBCIUtils.log("[BPD] max age: " + maxAge + " days", 4);
        long maxMillis = -1L;
        try {
            int days = Integer.parseInt(maxAge);
            if (days == 0) {
                HBCIUtils.log("[BPD] auto-expiry disabled", 4);
                return false;
            }
            if (days > 0) {
                maxMillis = (long)(days * 24 * 60 * 60) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            HBCIUtils.log(e);
            return false;
        }
        long lastUpdate = 0L;
        if (bpd != null) {
            String s = bpd.getProperty(BPD_KEY_LASTUPDATE, Long.toString(lastUpdate));
            try {
                lastUpdate = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                HBCIUtils.log(e);
                return false;
            }
            HBCIUtils.log("[BPD] last update: " + (lastUpdate == 0L ? "never" : new Date(lastUpdate)), 4);
        }
        long now = System.currentTimeMillis();
        if (maxMillis < 0L || now - lastUpdate > maxMillis) {
            HBCIUtils.log("[BPD] expired, will be updated now", 4);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchBPD() {
        Properties bpd = this.passport.getBPD();
        String hbciVersionOfBPD = bpd != null ? bpd.getProperty(BPD_KEY_HBCIVERSION) : null;
        String version = this.passport.getBPDVersion();
        if (version.equals("0") || this.isBPDExpired() || hbciVersionOfBPD == null || !hbciVersionOfBPD.equals(this.kernel.getHBCIVersion())) {
            try {
                if (!version.equals("0")) {
                    HBCIUtils.log("resetting BPD version from " + version + " to 0", 4);
                    this.passport.getBPD().setProperty("BPA.version", "0");
                    this.passport.saveChanges();
                }
                HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 3, null);
                HBCIUtils.log("Aktualisiere Bankparameter (BPD)", 3);
                DialogContext ctx = DialogContext.create(this.kernel, this.passport);
                ctx.setAnonymous(true);
                HBCIDialogInit init = new HBCIDialogInit();
                HBCIMsgStatus ret = init.execute(ctx);
                Properties result = ret.getData();
                this.updateBPD(result);
                this.passport.saveChanges();
                HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
                end.execute(ctx);
                if (!ret.isOK()) {
                    HBCIUtils.log("fetching BPD failed: " + ret.getErrorString(), 1);
                    throw new ProcessException(HBCIUtilsInternal.getLocMsg("ERR_INST_BPDFAILED"), ret);
                }
            }
            catch (Exception e) {
                HBCI_Exception he;
                if (e instanceof HBCI_Exception && (he = (HBCI_Exception)e).isFatal()) {
                    throw he;
                }
                HBCIUtils.log(e, 3);
                HBCIUtils.log("FAILED! - maybe this institute does not support anonymous logins", 3);
                HBCIUtils.log("we will nevertheless go on", 3);
            }
            finally {
                this.passport.closeComm();
            }
        }
        HBCIUtils.log("checking if requested hbci parameters are supported", 4);
        if (this.passport.getBPD() != null) {
            String msg;
            if (!this.passport.isSupported() && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreSecMechCheckErrors", msg = HBCIUtilsInternal.getLocMsg("EXCMSG_SECMETHNOTSUPP"))) {
                throw new InvalidUserDataException(msg);
            }
            if (!Arrays.asList(this.passport.getSuppVersions()).contains(this.kernel.getHBCIVersion(0)) && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreVersionCheckErrors", msg = HBCIUtilsInternal.getLocMsg("EXCMSG_VERSIONNOTSUPP"))) {
                throw new InvalidUserDataException(msg);
            }
        } else {
            HBCIUtils.log("can not check if requested parameters are supported", 2);
        }
    }

    public void fetchKeys() {
        if (!this.passport.needInstKeys() || this.passport.hasInstEncKey()) {
            return;
        }
        try {
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 5, null);
            HBCIUtils.log("Rufe Institutsschl\u00fcssel ab", 3);
            DialogContext ctx = DialogContext.create(this.kernel, this.passport);
            ctx.setAnonymous(true);
            HBCIDialogFirstKeyRequest init = new HBCIDialogFirstKeyRequest();
            HBCIMsgStatus ret = init.execute(ctx);
            Properties result = ret.getData();
            this.updateBPD(result);
            this.extractKeys(result);
            this.passport.saveChanges();
            HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
            end.execute(ctx);
            if (!ret.isOK()) {
                HBCIUtils.log("fetching institute keys failed: " + ret.getErrorString(), 1);
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("ERR_INST_GETKEYSFAILED"), ret);
            }
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_FETCH_IKEYS_ERR"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    public void register() {
        this.fetchBPD();
        this.fetchKeys();
    }

    @Override
    public void sync(boolean force) {
        Properties bpd;
        if (force && (bpd = this.passport.getBPD()) != null) {
            bpd.remove(BPD_KEY_LASTUPDATE);
        }
        this.register();
    }

    @Override
    public MsgGen getMsgGen() {
        return this.kernel.getMsgGen();
    }

    @Override
    public HBCIPassport getPassport() {
        return this.passport;
    }
}

