/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.HBCIPassportList;
import org.kapott.hbci.protocol.factory.MSGFactory;
import org.kapott.hbci.rewrite.Rewrite;
import org.kapott.hbci.security.factory.CryptFactory;
import org.kapott.hbci.security.factory.SigFactory;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class HBCIKernelImpl
implements HBCIKernel {
    public static final boolean SIGNIT = true;
    public static final boolean DONT_SIGNIT = false;
    public static final boolean CRYPTIT = true;
    public static final boolean DONT_CRYPTIT = false;
    public static final boolean NEED_CRYPT = true;
    public static final boolean DONT_NEED_CRYPT = false;
    private String hbciversion;
    private MsgGen gen;
    private String currentMsgName;
    private IHandlerData parentHandlerData;

    public HBCIKernelImpl(IHandlerData parentHandlerData, String hbciversion) {
        String filename;
        ClassLoader cl;
        this.parentHandlerData = parentHandlerData;
        this.hbciversion = hbciversion;
        String xmlpath = HBCIUtils.getParam("kernel.kernel.xmlpath");
        InputStream syntaxStream = null;
        if (xmlpath == null) {
            xmlpath = "";
        }
        if ((syntaxStream = (cl = this.getClass().getClassLoader()).getResourceAsStream(filename = xmlpath + "hbci-" + hbciversion + ".xml")) == null) {
            throw new InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_KRNL_CANTLOAD_SYN", filename));
        }
        try {
            this.gen = new MsgGen(syntaxStream);
            this.currentMsgName = null;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_MSGGEN_INIT"), e);
        }
    }

    @Override
    public String getHBCIVersion() {
        return this.hbciversion;
    }

    public void setParentHandlerData(IHandlerData parentHandlerData) {
        if (this.parentHandlerData != null) {
            throw new HBCI_Exception("*** can not overwrite existing handler object");
        }
        this.parentHandlerData = parentHandlerData;
    }

    public IHandlerData getParentHandlerData() {
        return this.parentHandlerData;
    }

    public String getHBCIVersion(int dummy) {
        String ret = "";
        NodeList nodes = this.gen.getSyntax().getElementById("MsgHeadUser").getElementsByTagName("value");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Element node = (Element)nodes.item(i);
            if (!node.getAttribute("path").equals("hbciversion")) continue;
            ret = node.getFirstChild().getNodeValue();
            break;
        }
        return ret;
    }

    public void rawNewMsg(String name) {
        if (name == null || name.length() == 0) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_EMPTY_MSGNAME"));
        }
        this.currentMsgName = name;
        HBCIUtils.log("creating new raw message " + name, 5);
        this.gen.reset();
    }

    public void rawSet(String key, String value) {
        HBCIUtils.log("setting raw property " + this.currentMsgName + "." + key + " to \"" + value + "\"", 5);
        if (this.currentMsgName == null) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_NORAWMSG"));
        }
        if (key == null) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_KEYNULL"));
        }
        if (value == null) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_VALUENULL", key));
        }
        if (value.length() != 0) {
            this.gen.set(this.currentMsgName + "." + key, value);
        }
    }

    public HBCIMsgStatus rawDoIt(boolean signit, boolean cryptit, boolean needCrypt) {
        HBCIPassportList passports = new HBCIPassportList();
        HBCIPassportInternal passport = (HBCIPassportInternal)this.getParentHandlerData().getPassport();
        passports.addPassport(passport, "1");
        return this.rawDoIt(passports, signit, cryptit, needCrypt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public HBCIMsgStatus rawDoIt(HBCIPassportList passports, boolean signit, boolean cryptit, boolean needCrypt) {
        ret = new HBCIMsgStatus();
        msg = null;
        try {
            block50: {
                mainPassport = passports.getMainPassport();
                HBCIUtils.log("generating raw message " + this.currentMsgName, 4);
                HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 21, this.currentMsgName);
                msg = this.gen.generate(this.currentMsgName);
                Rewrite.setData("passports", passports);
                Rewrite.setData("msgStatus", ret);
                Rewrite.setData("msgName", this.currentMsgName);
                Rewrite.setData("signIt", signit);
                Rewrite.setData("cryptIt", cryptit);
                rewriters_st = HBCIUtils.getParam("kernel.rewriter");
                al = new ArrayList<Rewrite>();
                tok = new StringTokenizer(rewriters_st, ",");
                while (tok.hasMoreTokens()) {
                    rewriterName = tok.nextToken().trim();
                    if (rewriterName.length() == 0) continue;
                    cl = this.getClass().getClassLoader().loadClass("org.kapott.hbci.rewrite.R" + rewriterName);
                    con = cl.getConstructor(null);
                    rewriter = (Rewrite)con.newInstance(null);
                    al.add(rewriter);
                }
                rewriters = al.toArray(new Rewrite[al.size()]);
                for (i = 0; i < rewriters.length; ++i) {
                    old = msg;
                    if ((msg = rewriters[i].outgoingClearText(old, this.gen)) == old) continue;
                    MSGFactory.getInstance().unuseObject(old);
                }
                if (signit) {
                    HBCIUtils.log("trying to insert signature", 4);
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 22, null);
                    sig = SigFactory.getInstance().createSig(this.getParentHandlerData(), msg, passports);
                    try {
                        if (!sig.signIt() && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreSignErrors", errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_CANTSIGN"))) {
                            throw new HBCI_Exception(errmsg);
                        }
                    }
                    finally {
                        SigFactory.getInstance().unuseObject(sig);
                    }
                    for (i = 0; i < rewriters.length; ++i) {
                        old = msg;
                        if ((msg = rewriters[i].outgoingSigned(old, this.gen)) == old) continue;
                        MSGFactory.getInstance().unuseObject(old);
                    }
                }
                paths = new Properties();
                msg.getElementPaths(paths, null, null, null);
                ret.addData(paths);
                current = new Hashtable<String, String>();
                msg.extractValues(current);
                origs = new Properties();
                e = current.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    value = current.get(key);
                    origs.setProperty("orig_" + key, value);
                }
                ret.addData(origs);
                outstring = msg.toString(0);
                HBCIUtils.log("sending message: " + outstring, 5);
                maxmsgsize = mainPassport.getMaxMsgSizeKB();
                if (maxmsgsize != 0 && outstring.length() >> 10 > maxmsgsize && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreMsgSizeErrors", errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_MSGTOOLARGE", new Object[]{Integer.toString(outstring.length() >> 10), Integer.toString(maxmsgsize)}))) {
                    throw new HBCI_Exception(errmsg);
                }
                if (cryptit) {
                    HBCIUtils.log("trying to encrypt message", 4);
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 23, null);
                    old = msg;
                    crypt = CryptFactory.getInstance().createCrypt(this.getParentHandlerData(), old);
                    try {
                        msg = crypt.cryptIt("Crypted");
                    }
                    finally {
                        CryptFactory.getInstance().unuseObject(crypt);
                        if (msg != old) {
                            MSGFactory.getInstance().unuseObject(old);
                        }
                    }
                    if (!msg.getName().equals("Crypted") && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreCryptErrors", errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_CANTCRYPT"))) {
                        throw new HBCI_Exception(errmsg);
                    }
                    for (i = 0; i < rewriters.length; ++i) {
                        oldMsg = msg;
                        if ((msg = rewriters[i].outgoingCrypted(oldMsg, this.gen)) == oldMsg) continue;
                        MSGFactory.getInstance().unuseObject(oldMsg);
                    }
                    HBCIUtils.log("encrypted message to be sent: " + msg.toString(0), 5);
                }
                msgPath = msg.getPath();
                msgnum = msg.getValueOfDE(msgPath + ".MsgHead.msgnum");
                dialogid = msg.getValueOfDE(msgPath + ".MsgHead.dialogid");
                hbciversion = msg.getValueOfDE(msgPath + ".MsgHead.hbciversion");
                HBCIUtils.log("communicating dialogid/msgnum " + dialogid + "/" + msgnum, 4);
                old = msg;
                msg = mainPassport.getComm().pingpong(this.currentMsgName, old);
                if (msg != old) {
                    MSGFactory.getInstance().unuseObject(old);
                }
                if (crypted = msg.getName().equals("CryptedRes")) {
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 25, null);
                    HBCIUtils.log("acquire crypt instance", 4);
                    crypt = CryptFactory.getInstance().createCrypt(this.getParentHandlerData(), msg);
                    try {
                        HBCIUtils.log("decrypting using " + crypt, 4);
                        newmsgstring = crypt.decryptIt();
                        HBCIUtils.log("decrypted", 4);
                        HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 31, newmsgstring);
                    }
                    finally {
                        HBCIUtils.log("free crypt", 4);
                        CryptFactory.getInstance().unuseObject(crypt);
                        HBCIUtils.log("crypt freed", 4);
                    }
                    this.gen.set("_origSignedMsg", newmsgstring);
                    HBCIUtils.log("rewriting message", 4);
                    for (i = 0; i < rewriters.length; ++i) {
                        HBCIUtils.log("applying rewriter " + rewriters[i].getClass().getSimpleName(), 4);
                        newmsgstring = rewriters[i].incomingClearText(newmsgstring, this.gen);
                    }
                    HBCIUtils.log("rewriting done", 4);
                    HBCIUtils.log("decrypted message after rewriting: " + newmsgstring, 5);
                    try {
                        HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 28, this.currentMsgName + "Res");
                        HBCIUtils.log("message to pe parsed: " + msg.toString(0), 5);
                        oldMsg = msg;
                        msg = MSGFactory.getInstance().createMSG(this.currentMsgName + "Res", newmsgstring, newmsgstring.length(), this.gen);
                        if (msg == oldMsg) ** GOTO lbl133
                        MSGFactory.getInstance().unuseObject(oldMsg);
                    }
                    catch (Exception ex) {
                        throw new CanNotParseMessageException(HBCIUtilsInternal.getLocMsg("EXCMSG_CANTPARSE"), newmsgstring, ex);
                    }
                } else {
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 31, msg.toString(0));
                }
lbl133:
                // 3 sources

                HBCIUtils.log("received message after decryption: " + msg.toString(0), 5);
                for (i = 0; i < rewriters.length; ++i) {
                    oldMsg = msg;
                    if ((msg = rewriters[i].incomingData(oldMsg, this.gen)) == oldMsg) continue;
                    MSGFactory.getInstance().unuseObject(oldMsg);
                }
                HBCIUtils.log("extracting data from received message", 4);
                p = msg.getData();
                p.setProperty("_msg", this.gen.get("_origSignedMsg"));
                ret.addData(p);
                msgPath = msg.getPath();
                try {
                    hbciversion2 = msg.getValueOfDE(msgPath + ".MsgHead.hbciversion");
                    if (!hbciversion2.equals(hbciversion)) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVVERSION", new Object[]{hbciversion2, hbciversion}));
                    }
                    msgnum2 = msg.getValueOfDE(msgPath + ".MsgHead.msgnum");
                    if (!msgnum2.equals(msgnum)) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVMSGNUM_HEAD", new Object[]{msgnum2, msgnum}));
                    }
                    msgnum2 = msg.getValueOfDE(msgPath + ".MsgTail.msgnum");
                    if (!msgnum2.equals(msgnum)) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVMSGNUM_TAIL", new Object[]{msgnum2, msgnum}));
                    }
                    dialogid2 = msg.getValueOfDE(msgPath + ".MsgHead.dialogid");
                    if (!dialogid.equals("0") && !dialogid2.equals(dialogid)) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVDIALOGID", new Object[]{dialogid2, dialogid}));
                    }
                    if (!dialogid.equals("0") && !msg.getValueOfDE(msgPath + ".MsgHead.MsgRef.dialogid").equals(dialogid)) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVDIALOGID_REF"));
                    }
                    if (!msg.getValueOfDE(msgPath + ".MsgHead.MsgRef.msgnum").equals(msgnum)) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_INVMSGNUM_REF"));
                    }
                }
                catch (HBCI_Exception e) {
                    errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_MSGCHECK") + ": " + HBCIUtils.exception2String(e);
                    if (HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreMsgCheckErrors", errmsg)) break block50;
                    throw e;
                }
            }
            HBCIUtils.log("looking for a signature", 4);
            HBCIUtilsInternal.getCallback().status((HBCIPassport)mainPassport, 26, null);
            sigOk = false;
            sig = SigFactory.getInstance().createSig(this.getParentHandlerData(), msg, passports);
            try {
                sigOk = sig.verify();
            }
            finally {
                SigFactory.getInstance().unuseObject(sig);
            }
            HBCIUtils.log("looking if message is encrypted", 4);
            if (needCrypt && !crypted && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreCryptErrors", errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_NOTCRYPTED"))) {
                throw new HBCI_Exception(errmsg);
            }
            if (!sigOk && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreSignErrors", errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_INVSIG"))) {
                throw new HBCI_Exception(errmsg);
            }
            MSGFactory.getInstance().unuseObject(msg);
            this.currentMsgName = null;
            this.gen.reset();
        }
        catch (Exception e) {
            paramName = "client.errors.ignoreDialogEndErrors";
            if (this.currentMsgName.startsWith("DialogEnd") && HBCIUtils.getParam(paramName, "no").equals("yes")) {
                HBCIUtils.log(e, 2);
                HBCIUtils.log("error while receiving DialogEnd response - but ignoring it because of special setting", 2);
            } else {
                ret.addException(e);
            }
        }
        finally {
            MSGFactory.getInstance().unuseObject(msg);
            this.currentMsgName = null;
            this.gen.reset();
        }
        return ret;
    }

    public void reset() {
        this.gen.reset();
        this.currentMsgName = null;
    }

    @Override
    public Hashtable<String, List<String>> getAllLowlevelJobs() {
        return this.getMsgGen().getLowlevelGVs();
    }

    @Override
    public List<String> getLowlevelJobParameterNames(String gvname, String version) {
        return this.getMsgGen().getGVParameterNames(gvname, version);
    }

    @Override
    public List<String> getLowlevelJobResultNames(String gvname, String version) {
        return this.getMsgGen().getGVResultNames(gvname, version);
    }

    @Override
    public List<String> getLowlevelJobRestrictionNames(String gvname, String version) {
        return this.getMsgGen().getGVRestrictionNames(gvname, version);
    }

    public MsgGen getMsgGen() {
        return this.gen;
    }
}

