/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.HBCIDialogEnd;
import org.kapott.hbci.dialog.HBCIDialogInit;
import org.kapott.hbci.dialog.HBCIDialogLockKeys;
import org.kapott.hbci.dialog.HBCIDialogSync;
import org.kapott.hbci.dialog.HBCIProcess;
import org.kapott.hbci.dialog.HBCIProcessSepaInfo;
import org.kapott.hbci.dialog.HBCIProcessTanMedia;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.NeedKeyAckException;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.Feature;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.tools.StringUtil;

public final class HBCIUser
implements IHandlerData {
    public static final String UPD_KEY_HBCIVERSION = "_hbciversion";
    public static final String UPD_KEY_TANMEDIA = "tanmedia.names";
    public static final String UPD_KEY_FETCH_SEPAINFO = "_fetchedSepaInfo";
    public static final String UPD_KEY_FETCH_TANMEDIA = "_fetchedTanMedia";
    private static final List<String> UPD_PROTECT_KEYS = Arrays.asList("_fetchedTanMedia", "_fetchedSepaInfo", "tanmedia.names");
    private HBCIPassportInternal passport;
    private HBCIKernelImpl kernel;
    private boolean isAnon;
    private String anonSuffix;

    public HBCIUser(HBCIKernelImpl kernel, HBCIPassportInternal passport, boolean forceAsParent) {
        this.kernel = kernel;
        if (forceAsParent || this.kernel.getParentHandlerData() == null) {
            this.kernel.setParentHandlerData(this);
        }
        this.passport = passport;
        if (forceAsParent || this.passport.getParentHandlerData() == null) {
            this.passport.setParentHandlerData(this);
        }
        this.isAnon = passport.isAnonymous();
        this.anonSuffix = this.isAnon ? "Anon" : "";
    }

    @Deprecated
    private void doDialogEnd(String dialogid, String msgnum, boolean signIt, boolean cryptIt, boolean needCrypt) {
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 19, null);
        this.kernel.rawNewMsg("DialogEnd" + this.anonSuffix);
        this.kernel.rawSet("MsgHead.dialogid", dialogid);
        this.kernel.rawSet("MsgHead.msgnum", msgnum);
        this.kernel.rawSet("DialogEndS.dialogid", dialogid);
        this.kernel.rawSet("MsgTail.msgnum", msgnum);
        HBCIMsgStatus status = this.kernel.rawDoIt(!this.isAnon && signIt, !this.isAnon && cryptIt, !this.isAnon && needCrypt);
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 20, status);
        if (!status.isOK()) {
            HBCIUtils.log("dialog end failed: " + status.getErrorString(), 1);
            String msg = HBCIUtilsInternal.getLocMsg("ERR_INST_ENDFAILED");
            if (!HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreDialogEndErrors", msg + ": " + status.getErrorString())) {
                throw new ProcessException(msg, status);
            }
        }
    }

    private void sendAndActivateNewUserKeys(HBCIKey[] sigKey, HBCIKey[] encKey) {
        block21: {
            try {
                HBCIUtils.log("Sende neue Benutzerschl\u00fcssel", 3);
                String country = this.passport.getCountry();
                String blz = this.passport.getBLZ();
                String[] exponent = new String[2];
                String[] modulus = new String[2];
                for (int i = 0; i < 2; ++i) {
                    int startpos;
                    KeyFactory fac = KeyFactory.getInstance("RSA");
                    RSAPublicKeySpec spec = null;
                    if (i == 0) {
                        spec = fac.getKeySpec(sigKey[0].key, RSAPublicKeySpec.class);
                    } else if (i == 1) {
                        spec = fac.getKeySpec(encKey[0].key, RSAPublicKeySpec.class);
                    }
                    byte[] ba = spec.getPublicExponent().toByteArray();
                    int len = ba.length;
                    for (startpos = 0; startpos < len && ba[startpos] == 0; ++startpos) {
                    }
                    exponent[i] = new String(ba, startpos, len - startpos, "ISO-8859-1");
                    ba = spec.getModulus().toByteArray();
                    len = ba.length;
                    for (startpos = 0; startpos < len && ba[startpos] == 0; ++startpos) {
                    }
                    modulus[i] = new String(ba, startpos, len - startpos, "ISO-8859-1");
                }
                if (!this.passport.hasMySigKey()) {
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 7, null);
                    this.passport.setSigId(new Long(1L));
                    this.kernel.rawNewMsg("SendKeys");
                    this.kernel.rawSet("Idn.KIK.blz", blz);
                    this.kernel.rawSet("Idn.KIK.country", country);
                    this.kernel.rawSet("Idn.customerid", this.passport.getCustomerId());
                    this.kernel.rawSet("Idn.sysid", this.passport.getSysId());
                    this.kernel.rawSet("KeyChange.KeyName.KIK.blz", blz);
                    this.kernel.rawSet("KeyChange.KeyName.KIK.country", country);
                    this.kernel.rawSet("KeyChange.KeyName.userid", this.passport.getUserId());
                    this.kernel.rawSet("KeyChange.KeyName.keynum", sigKey[0].num);
                    this.kernel.rawSet("KeyChange.KeyName.keytype", "S");
                    this.kernel.rawSet("KeyChange.KeyName.keyversion", sigKey[0].version);
                    this.kernel.rawSet("KeyChange.SecProfile.method", this.passport.getProfileMethod());
                    this.kernel.rawSet("KeyChange.SecProfile.version", this.passport.getProfileVersion());
                    this.kernel.rawSet("KeyChange.PubKey.mode", "16");
                    this.kernel.rawSet("KeyChange.PubKey.exponent", "B" + exponent[0]);
                    this.kernel.rawSet("KeyChange.PubKey.modulus", "B" + modulus[0]);
                    this.kernel.rawSet("KeyChange.PubKey.usage", "6");
                    this.kernel.rawSet("KeyChange_2.KeyName.KIK.blz", blz);
                    this.kernel.rawSet("KeyChange_2.KeyName.KIK.country", country);
                    this.kernel.rawSet("KeyChange_2.KeyName.userid", this.passport.getUserId());
                    this.kernel.rawSet("KeyChange_2.KeyName.keynum", encKey[0].num);
                    this.kernel.rawSet("KeyChange_2.KeyName.keytype", "V");
                    this.kernel.rawSet("KeyChange_2.KeyName.keyversion", encKey[0].version);
                    this.kernel.rawSet("KeyChange_2.SecProfile.method", this.passport.getProfileMethod());
                    this.kernel.rawSet("KeyChange_2.SecProfile.version", this.passport.getProfileVersion());
                    this.kernel.rawSet("KeyChange_2.PubKey.mode", "16");
                    this.kernel.rawSet("KeyChange_2.PubKey.exponent", "B" + exponent[1]);
                    this.kernel.rawSet("KeyChange_2.PubKey.modulus", "B" + modulus[1]);
                    this.kernel.rawSet("KeyChange_2.PubKey.usage", "5");
                    this.passport.setMyPublicSigKey(sigKey[0]);
                    this.passport.setMyPrivateSigKey(sigKey[1]);
                    this.passport.setMyPublicEncKey(encKey[0]);
                    this.passport.setMyPrivateEncKey(encKey[1]);
                    this.passport.saveChanges();
                    HBCIMsgStatus ret = this.kernel.rawDoIt(true, true, false);
                    Properties result = ret.getData();
                    HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 8, ret);
                    if (!ret.isOK()) {
                        if (!ret.hasExceptions()) {
                            HBCIUtils.log("deleting locally generated user keys", 2);
                            this.passport.clearMySigKey();
                            this.passport.clearMyEncKey();
                            this.passport.clearMyDigKey();
                            this.passport.saveChanges();
                        } else {
                            HBCIUtils.log(ret.getExceptions());
                            HBCIUtils.log("keys have not been thrown away", 2);
                        }
                        throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_SENDKEYERR"), ret);
                    }
                    try {
                        this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "2", false, true, false);
                    }
                    catch (Exception e) {
                        HBCIUtils.log(e);
                    }
                    this.triggerNewKeysEvent();
                    break block21;
                }
                HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 17, null);
                DialogContext ctx = DialogContext.create(this.kernel, this.passport);
                HBCIDialogInit init = new HBCIDialogInit();
                HBCIMsgStatus ret = init.execute(ctx);
                if (!ret.isOK()) {
                    throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_GETUPDFAIL"), ret);
                }
                Properties result = ret.getData();
                HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
                inst.updateBPD(result);
                this.updateUPD(result);
                this.passport.saveChanges();
                HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 18, new Object[]{ret, result.getProperty("MsgHead.dialogid")});
                HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 7, null);
                this.kernel.rawNewMsg("ChangeKeys");
                this.kernel.rawSet("MsgHead.dialogid", result.getProperty("MsgHead.dialogid"));
                this.kernel.rawSet("MsgHead.msgnum", "2");
                this.kernel.rawSet("MsgTail.msgnum", "2");
                this.kernel.rawSet("KeyChange.KeyName.KIK.blz", blz);
                this.kernel.rawSet("KeyChange.KeyName.KIK.country", country);
                this.kernel.rawSet("KeyChange.KeyName.userid", this.passport.getUserId());
                this.kernel.rawSet("KeyChange.KeyName.keynum", sigKey[0].num);
                this.kernel.rawSet("KeyChange.KeyName.keytype", "S");
                this.kernel.rawSet("KeyChange.KeyName.keyversion", sigKey[0].version);
                this.kernel.rawSet("KeyChange.SecProfile.method", this.passport.getProfileMethod());
                this.kernel.rawSet("KeyChange.SecProfile.version", this.passport.getProfileVersion());
                this.kernel.rawSet("KeyChange.PubKey.mode", "16");
                this.kernel.rawSet("KeyChange.PubKey.exponent", "B" + exponent[0]);
                this.kernel.rawSet("KeyChange.PubKey.modulus", "B" + modulus[0]);
                this.kernel.rawSet("KeyChange.PubKey.usage", "6");
                this.kernel.rawSet("KeyChange_2.KeyName.KIK.blz", blz);
                this.kernel.rawSet("KeyChange_2.KeyName.KIK.country", country);
                this.kernel.rawSet("KeyChange_2.KeyName.userid", this.passport.getUserId());
                this.kernel.rawSet("KeyChange_2.KeyName.keynum", encKey[0].num);
                this.kernel.rawSet("KeyChange_2.KeyName.keytype", "V");
                this.kernel.rawSet("KeyChange_2.KeyName.keyversion", encKey[0].version);
                this.kernel.rawSet("KeyChange_2.SecProfile.method", this.passport.getProfileMethod());
                this.kernel.rawSet("KeyChange_2.SecProfile.version", this.passport.getProfileVersion());
                this.kernel.rawSet("KeyChange_2.PubKey.mode", "16");
                this.kernel.rawSet("KeyChange_2.PubKey.exponent", "B" + exponent[1]);
                this.kernel.rawSet("KeyChange_2.PubKey.modulus", "B" + modulus[1]);
                this.kernel.rawSet("KeyChange_2.PubKey.usage", "5");
                HBCIKey[] oldEncKeys = new HBCIKey[]{this.passport.getMyPublicEncKey(), this.passport.getMyPrivateEncKey()};
                this.passport.setMyPublicEncKey(encKey[0]);
                this.passport.setMyPrivateEncKey(encKey[1]);
                this.passport.saveChanges();
                ret = this.kernel.rawDoIt(true, true, true);
                if (!ret.isOK()) {
                    if (!ret.hasExceptions()) {
                        HBCIUtils.log("deleting locally generated user keys", 2);
                        this.passport.setMyPublicEncKey(oldEncKeys[0]);
                        this.passport.setMyPrivateEncKey(oldEncKeys[1]);
                        this.passport.saveChanges();
                    } else {
                        HBCIUtils.log("keys have not been thrown away", 2);
                    }
                    throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_SENDKEYERR"), ret);
                }
                this.passport.setSigId(new Long(1L));
                this.passport.setMyPublicSigKey(sigKey[0]);
                this.passport.setMyPrivateSigKey(sigKey[1]);
                this.passport.saveChanges();
                result = ret.getData();
                HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 8, ret);
                this.doDialogEnd(result.getProperty("MsgHead.dialogid"), "3", true, true, true);
            }
            catch (Exception e) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SENDABORT"), e);
            }
            finally {
                this.passport.closeComm();
            }
        }
    }

    private void triggerNewKeysEvent() {
        HBCIUtilsInternal.getCallback().callback(this.passport, 13, HBCIUtilsInternal.getLocMsg("CALLB_NEW_USER_KEYS"), 0, new StringBuffer());
        throw new NeedKeyAckException();
    }

    public void generateNewKeys() {
        if (!this.passport.needUserKeys()) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USRKEYS_UNSUPP"));
        }
        HBCIKey[][] newUserKeys = this.passport.generateNewUserKeys();
        this.sendAndActivateNewUserKeys(newUserKeys[0], newUserKeys[1]);
    }

    public void manuallySetNewKeys(KeyPair sigKey, KeyPair encKey) {
        HBCIKey[] newEncKey;
        HBCIKey[] newSigKey;
        if (this.passport.needUserKeys()) {
            newSigKey = null;
            newEncKey = null;
            try {
                HBCIUtils.log("Speichere neue Benutzerschl\u00fcssel", 3);
                String blz = this.passport.getBLZ();
                String country = this.passport.getCountry();
                String userid = this.passport.getUserId();
                newSigKey = new HBCIKey[2];
                newEncKey = new HBCIKey[2];
                for (int i = 0; i < 2; ++i) {
                    String num;
                    if (i == 0) {
                        num = this.passport.hasMySigKey() ? this.passport.getMyPublicSigKey().num : "0";
                        num = Integer.toString(Integer.parseInt(num) + 1);
                        newSigKey[0] = new HBCIKey(country, blz, userid, num, "1", sigKey.getPublic());
                        newSigKey[1] = new HBCIKey(country, blz, userid, num, "1", sigKey.getPrivate());
                        continue;
                    }
                    num = this.passport.hasMyEncKey() ? this.passport.getMyPublicEncKey().num : "0";
                    num = Integer.toString(Integer.parseInt(num) + 1);
                    newEncKey[0] = new HBCIKey(country, blz, userid, num, "1", encKey.getPublic());
                    newEncKey[1] = new HBCIKey(country, blz, userid, num, "1", encKey.getPrivate());
                }
            }
            catch (Exception ex) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GENKEYS_ERR"), ex);
            }
        } else {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USRKEYS_UNSUPP"));
        }
        this.sendAndActivateNewUserKeys(newSigKey, newEncKey);
    }

    public void fetchSysId() {
        try {
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 9, null);
            HBCIUtils.log("Rufe neue System-ID ab", 3);
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            this.passport.setSysId("0");
            DialogContext ctx = DialogContext.create(this.kernel, this.passport);
            HBCIDialogSync sync = new HBCIDialogSync(HBCIDialogSync.Mode.SYS_ID);
            HBCIMsgStatus ret = sync.execute(ctx);
            Properties result = ret.getData();
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.updateBPD(result);
            this.updateUPD(result);
            this.passport.setSysId(result.getProperty("SyncRes.sysid"));
            this.passport.saveChanges();
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 10, new Object[]{ret, this.passport.getSysId()});
            HBCIUtils.log("new sys-id is " + this.passport.getSysId(), 4);
            HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
            end.execute(ctx);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    public void fetchSigId() {
        try {
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 15, null);
            HBCIUtils.log("Synchronisiere Signatur-ID", 3);
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            this.passport.setSigId(new Long("9999999999999999"));
            DialogContext ctx = DialogContext.create(this.kernel, this.passport);
            HBCIDialogSync sync = new HBCIDialogSync(HBCIDialogSync.Mode.SIG_ID);
            HBCIMsgStatus ret = sync.execute(ctx);
            Properties result = ret.getData();
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.updateBPD(result);
            this.updateUPD(result);
            this.passport.setSigId(new Long(result.getProperty("SyncRes.sigid", "1")));
            this.passport.incSigId();
            this.passport.saveChanges();
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 16, new Object[]{ret, this.passport.getSigId()});
            HBCIUtils.log("signature id set to " + this.passport.getSigId(), 4);
            HBCIDialogEnd end = new HBCIDialogEnd(HBCIDialogEnd.Flag.SIG_ID);
            end.execute(ctx);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    public void updateUPD(Properties result) {
        HBCIUtils.log("extracting UPD from results", 4);
        Properties p = new Properties();
        Enumeration<Object> e = result.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("UPD.")) continue;
            p.setProperty(key.substring("UPD.".length()), result.getProperty(key));
        }
        if (p.size() == 0) {
            return;
        }
        p.setProperty(UPD_KEY_HBCIVERSION, this.kernel.getHBCIVersion());
        HashMap<String, String> protectedKeys = new HashMap<String, String>();
        Properties upd = this.passport.getUPD();
        if (upd != null && upd.size() > 0) {
            for (String key : UPD_PROTECT_KEYS) {
                String value = upd.getProperty(key);
                if (value == null) continue;
                protectedKeys.put(key, value);
            }
            p.putAll((Map<?, ?>)protectedKeys);
        }
        if (upd != null && upd.size() > 0) {
            Konto[] konten = this.passport.getAccounts();
            Pattern pattern = Pattern.compile("UPD\\.(KInfo(.*?)\\.KTV)\\.number");
            for (Object okey : result.keySet()) {
                String kinfo;
                String key = okey.toString();
                Matcher m = pattern.matcher(key);
                if (!m.matches() || p.contains((kinfo = m.group(1)) + ".bic") && p.contains(kinfo + ".iban")) continue;
                Optional<Konto> matchingKonto = Arrays.asList(konten).stream().filter(konto -> Objects.equals(konto.number, result.get(okey)) && Objects.equals(konto.blz, result.get("UPD." + kinfo + ".KIK.blz")) && Objects.equals(konto.country, result.get("UPD." + kinfo + ".KIK.country"))).findAny();
                matchingKonto.ifPresent(konto -> {
                    if (StringUtil.hasText(konto.iban) && StringUtil.hasText(konto.bic)) {
                        HBCIUtils.log(kinfo + ".iban / .bic is missing, using the previous UPD's value", 4);
                        p.put(kinfo + ".bic", konto.bic);
                        p.put(kinfo + ".iban", konto.iban);
                    }
                });
            }
        }
        String oldVersion = this.passport.getUPDVersion();
        this.passport.setUPD(p);
        String newVersion = this.passport.getUPDVersion();
        HBCIUtils.log("Benutzerparameter (UPD) aktualisiert [Bisherige Version: " + oldVersion + ", neue Version: " + newVersion + "]", 3);
        HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 12, this.passport.getUPD());
    }

    public void fetchUPD() {
        try {
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 11, null);
            HBCIUtils.log("updating UPD (BPD-Version: " + this.passport.getBPDVersion() + ")", 4);
            HBCIUtils.log("Aktualisiere Benutzerparameter (UPD)", 3);
            HBCIUtils.log("checking whether passport is supported (but ignoring result)", 4);
            boolean s = this.passport.isSupported();
            HBCIUtils.log("passport supported: " + s, 4);
            String version = this.passport.getUPDVersion();
            if (!version.equals("0")) {
                HBCIUtils.log("resetting UPD version from " + version + " to 0", 4);
                this.passport.getBPD().setProperty("UPA.version", "0");
                this.passport.saveChanges();
            }
            DialogContext ctx = DialogContext.create(this.kernel, this.passport);
            ctx.setAnonymous(this.isAnon);
            HBCIDialogInit init = new HBCIDialogInit();
            HBCIMsgStatus ret = init.execute(ctx);
            if (!ret.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_GETUPDFAIL"), ret);
            }
            Properties result = ret.getData();
            HBCIInstitute inst = new HBCIInstitute(this.kernel, this.passport, false);
            inst.updateBPD(result);
            this.updateUPD(result);
            this.passport.saveChanges();
            HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
            end.execute(ctx);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GETUPDFAIL"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    @Override
    public void sync(boolean force) {
        if (this.passport.getSysStatus().equals("1")) {
            if (this.passport.getSysId().equals("0")) {
                this.fetchSysId();
            }
            if (this.passport.getSigId() == -1L) {
                this.fetchSigId();
            }
        }
        Properties upd = this.passport.getUPD();
        Properties bpd = this.passport.getBPD();
        String hbciVersion = upd != null ? upd.getProperty(UPD_KEY_HBCIVERSION) : null;
        DialogContext ctx = DialogContext.create(this.kernel, this.passport);
        HBCIProcess p = new HBCIProcessTanMedia(force);
        p.execute(ctx);
        if (force || bpd == null || this.passport.getUPD() == null || hbciVersion == null || !hbciVersion.equals(this.kernel.getHBCIVersion())) {
            this.fetchUPD();
        }
        if (Feature.SYNC_SEPAINFO.isEnabled()) {
            ctx = DialogContext.create(this.kernel, this.passport);
            p = new HBCIProcessSepaInfo(force);
            p.execute(ctx);
        }
    }

    public void register() {
        if (this.passport.needUserKeys() && !this.passport.hasMySigKey()) {
            this.generateNewKeys();
        }
        this.sync(false);
    }

    public void lockKeys() {
        if (!this.passport.needUserKeys() || !this.passport.hasMySigKey()) {
            if (!this.passport.needUserKeys()) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_DONTHAVEUSRKEYS"));
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_USR_NOUSRKEYSAVAIL"));
        }
        try {
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 17, null);
            HBCIUtils.log("Sperre Benutzerschl\u00fcssel", 3);
            DialogContext ctx = DialogContext.create(this.kernel, this.passport);
            HBCIDialogInit init = new HBCIDialogInit();
            HBCIMsgStatus ret = init.execute(ctx);
            if (!ret.isOK()) {
                throw new ProcessException(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), ret);
            }
            Properties result = ret.getData();
            String dialogid = result.getProperty("MsgHead.dialogid");
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 18, new Object[]{ret, dialogid});
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 13, null);
            HBCIDialogLockKeys lock = new HBCIDialogLockKeys();
            ret = lock.execute(ctx);
            this.passport.clearMyDigKey();
            this.passport.clearMySigKey();
            this.passport.clearMyEncKey();
            this.passport.setSigId(new Long(1L));
            this.passport.saveChanges();
            HBCIUtilsInternal.getCallback().status((HBCIPassport)this.passport, 14, ret);
            HBCIDialogEnd end = new HBCIDialogEnd(new HBCIDialogEnd.Flag[0]);
            end.execute(ctx);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_LOCKFAILED"), e);
        }
        finally {
            this.passport.closeComm();
        }
    }

    @Override
    public MsgGen getMsgGen() {
        return this.kernel.getMsgGen();
    }

    @Override
    public HBCIPassport getPassport() {
        return this.passport;
    }
}

