/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Properties;
import org.kapott.hbci.manager.HBCIUtils;

public enum HHDVersion {
    QR_1_3(Type.QRCODE, "HHD1\\.3\\..*?QR", null, -1, "hhd13"),
    QR_1_4(Type.QRCODE, "Q1S.*", null, -1, "hhd14"),
    HHD_1_4(Type.CHIPTAN, "HHD1\\.4.*", "1.4", 5, "hhd14"),
    HHD_1_3(Type.CHIPTAN, "HHD1\\.3.*", "1.3", 4, "hhd13"),
    MS_1(Type.PHOTOTAN, "MS1.*|photoTAN.*", null, -1, "hhd14"),
    HHD_1_2(Type.CHIPTAN, null, null, -1, "hhd12"),
    DECOUPLED(Type.DECOUPLED, "Decouple.*");

    public static final HHDVersion DEFAULT;
    private Type type = null;
    private String nameMatch = null;
    private String idMatch = null;
    private String versionStart = null;
    private int segVersion = 0;
    private String challengeVersion = null;

    private HHDVersion(Type type, String nameMatch) {
        this.type = type;
        this.nameMatch = nameMatch;
    }

    private HHDVersion(Type type, String idMatch, String versionStart, int segVersion, String challengeVersion) {
        this.type = type;
        this.idMatch = idMatch;
        this.versionStart = versionStart;
        this.segVersion = segVersion;
        this.challengeVersion = challengeVersion;
    }

    public String getChallengeVersion() {
        return this.challengeVersion;
    }

    public Type getType() {
        return this.type;
    }

    public static HHDVersion find(Properties secmech) {
        HBCIUtils.log("trying to determine HHD version for secmech: " + secmech, 4);
        if (secmech == null) {
            HBCIUtils.log("have no secmech data, fallback to default: " + (Object)((Object)DEFAULT), 2);
            return DEFAULT;
        }
        String name = secmech.getProperty("zkamethod_name", "");
        if (name != null && name.length() > 0) {
            HBCIUtils.log("  DK name: " + name, 4);
            for (HHDVersion v : HHDVersion.values()) {
                String s = v.nameMatch;
                if (s == null || !name.matches(s)) continue;
                HBCIUtils.log("  identified as " + (Object)((Object)v), 4);
                return v;
            }
        }
        String id = secmech.getProperty("id", "");
        HBCIUtils.log("  technical HHD id: " + id, 4);
        for (HHDVersion v : HHDVersion.values()) {
            String s = v.idMatch;
            if (s == null || id == null || !id.matches(s)) continue;
            HBCIUtils.log("  identified as " + (Object)((Object)v), 4);
            return v;
        }
        String version = secmech.getProperty("zkamethod_version");
        HBCIUtils.log("  ZKA version: " + version, 4);
        if (version != null && version.length() > 0) {
            for (HHDVersion v : HHDVersion.values()) {
                String s = v.versionStart;
                if (s == null || !version.startsWith(s)) continue;
                HBCIUtils.log("  identified as " + (Object)((Object)v), 4);
                return v;
            }
        }
        String segversion = secmech.getProperty("segversion");
        HBCIUtils.log("  segment version: " + segversion, 4);
        if (segversion != null && segversion.length() > 0) {
            int i = Integer.parseInt(segversion);
            for (HHDVersion v : HHDVersion.values()) {
                int i2 = v.segVersion;
                if (i2 <= 0 || i != i2) continue;
                HBCIUtils.log("  identified as " + (Object)((Object)v), 4);
                return v;
            }
        }
        HBCIUtils.log("  no HHD version detected, default to " + (Object)((Object)DEFAULT), 4);
        return DEFAULT;
    }

    static {
        DEFAULT = HHD_1_2;
    }

    public static enum Type {
        CHIPTAN,
        PHOTOTAN,
        QRCODE,
        DECOUPLED;

    }
}

