/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class LogFilter {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SECRETS = 1;
    public static final int FILTER_IDS = 2;
    public static final int FILTER_MOST = 3;
    private static LogFilter _instance;
    private Map<Integer, List<String[]>> secretDataByLevel = new Hashtable<Integer, List<String[]>>();

    public static synchronized LogFilter getInstance() {
        if (_instance == null) {
            _instance = new LogFilter();
        }
        return _instance;
    }

    private LogFilter() {
    }

    public synchronized void clearSecretData() {
        this.secretDataByLevel.clear();
    }

    public synchronized void addSecretData(String secret, String replacement, int level) {
        if (secret != null && secret.length() != 0) {
            List<String[]> secretData = this.secretDataByLevel.get(new Integer(level));
            if (secretData == null) {
                secretData = new ArrayList<String[]>();
                this.secretDataByLevel.put(new Integer(level), secretData);
            }
            boolean found = false;
            for (String[] entry : secretData) {
                if (!entry[0].equals(secret)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (replacement == null || replacement.length() < 2) {
                    char filler = replacement != null && replacement.length() == 1 ? (char)replacement.charAt(0) : (char)'X';
                    char[] ca = new char[secret.length()];
                    Arrays.fill(ca, filler);
                    replacement = new String(ca);
                }
                secretData.add(new String[]{secret, replacement});
            }
        }
    }

    public synchronized String filterLine(String line, int filterLevel) {
        String ret = null;
        if (line != null) {
            StringBuffer line2 = new StringBuffer(line);
            for (int level = filterLevel; level > 0; --level) {
                List<String[]> secretData = this.secretDataByLevel.get(new Integer(level));
                if (secretData == null) continue;
                for (String[] entry : secretData) {
                    String secret = entry[0];
                    String replacement = entry[1];
                    if (secret.isEmpty()) continue;
                    int posi = 0;
                    while ((posi = line2.indexOf(secret, posi)) != -1) {
                        line2.replace(posi, posi + secret.length(), replacement);
                        posi += replacement.length();
                    }
                }
            }
            ret = line2.toString();
        }
        return ret;
    }
}

