/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.comm.Comm;
import org.kapott.hbci.dialog.DialogContext;
import org.kapott.hbci.dialog.DialogEvent;
import org.kapott.hbci.dialog.HBCIMessage;
import org.kapott.hbci.dialog.HBCIMessageQueue;
import org.kapott.hbci.dialog.KnownDialogTemplate;
import org.kapott.hbci.dialog.KnownReturncode;
import org.kapott.hbci.dialog.KnownTANProcess;
import org.kapott.hbci.dialog.RawHBCIDialog;
import org.kapott.hbci.dialog.SCARequest;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.Feature;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.TanMethod;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.protocol.factory.SEGFactory;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.tools.CryptUtils;
import org.kapott.hbci.tools.NumberUtil;
import org.kapott.hbci.tools.ParameterFinder;
import org.kapott.hbci.tools.StringUtil;

public abstract class AbstractPinTanPassport
extends AbstractHBCIPassport {
    private static final String CACHE_KEY_SCA_STEP = "__sca_step__";
    public static final String KEY_PD_SCA = "__pintan_sca___";
    public static final String KEY_PD_CHALLENGE = "__pintan_challenge___";
    public static final String KEY_PD_HHDUC = "__pintan_hhduc___";
    public static final String KEY_PD_ORDERREF = "__pintan_orderref___";
    private String certfile;
    private boolean checkCert;
    private String proxy;
    private String proxyuser;
    private String proxypass;
    private boolean verifyTANMode;
    private String tanMethod;
    private boolean tanMethodAutoSelected;
    private List<String> tanMethodsUser;
    private Hashtable<String, Properties> tanMethodsBank = new Hashtable();
    private String pin;

    public AbstractPinTanPassport(Object initObject) {
        super(initObject);
        this.tanMethodsUser = new ArrayList<String>();
    }

    @Override
    public String getPassportTypeName() {
        return "PinTan";
    }

    @Override
    public void setBPD(Properties p) {
        super.setBPD(p);
        if (p != null && p.size() != 0) {
            this.tanMethodsBank.clear();
            int maxAllowedVersion = Integer.parseInt(HBCIUtils.getParam("kernel.gv.HITANS.segversion.max", "0"));
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                int prevVersion;
                String subkey;
                String key = (String)e.nextElement();
                if (!key.startsWith("Params") || !(subkey = key.substring(key.indexOf(46) + 1)).startsWith("TAN2StepPar")) continue;
                int segVersion = Integer.parseInt(subkey.substring(11, 12));
                if (!(subkey = subkey.substring(subkey.indexOf(46) + 1)).startsWith("ParTAN2Step") || !subkey.endsWith(".secfunc")) continue;
                if (maxAllowedVersion > 0 && segVersion > maxAllowedVersion) {
                    HBCIUtils.log("skipping segversion " + segVersion + ", larger than allowed version " + maxAllowedVersion, 4);
                    continue;
                }
                String secfunc = p.getProperty(key);
                Properties prev = this.tanMethodsBank.get(secfunc);
                if (prev != null && (prevVersion = Integer.parseInt(prev.getProperty("segversion"))) > segVersion) {
                    HBCIUtils.log("found another twostepmech " + secfunc + " in segversion " + segVersion + ", already have one in segversion " + prevVersion + ", ignoring segversion " + segVersion, 4);
                    continue;
                }
                Properties entry = new Properties();
                entry.put("segversion", Integer.toString(segVersion));
                String paramHeader = key.substring(0, key.lastIndexOf(46));
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String key2 = (String)e2.nextElement();
                    if (!key2.startsWith(paramHeader + ".")) continue;
                    int dotPos = key2.lastIndexOf(46);
                    entry.setProperty(key2.substring(dotPos + 1), p.getProperty(key2));
                }
                this.tanMethodsBank.put(secfunc, entry);
            }
        }
    }

    @Override
    public void onDialogEvent(DialogEvent event, DialogContext ctx) {
        super.onDialogEvent(event, ctx);
        if (event == DialogEvent.MSG_CREATED) {
            this.checkSCARequest(ctx);
        } else if (event == DialogEvent.MSG_SENT) {
            this.checkInvalidPIN(ctx);
            this.check3920(ctx);
            this.check3072(ctx);
            this.checkSCAResponse(ctx);
        } else if (event == DialogEvent.JOBS_CREATED) {
            this.patchMessagesFor2StepMethods(ctx);
        }
    }

    private void checkInvalidPIN(DialogContext ctx) {
        if (ctx.isAnonymous()) {
            return;
        }
        HBCIMsgStatus status = ctx.getMsgStatus();
        if (status == null) {
            return;
        }
        if (status.isOK()) {
            return;
        }
        HBCIRetVal ret = status.getInvalidPINCode();
        if (ret == null) {
            return;
        }
        HBCIUtils.log("PIN-Fehler erkannt, Meldung der Bank: " + ret.code + ": " + ret.text, 3);
        this.clearPIN();
        HBCIUtilsInternal.getCallback().callback(this, 40, "*** invalid PIN entered", 2, new StringBuffer());
    }

    private void check3920(DialogContext ctx) {
        if (ctx.isAnonymous()) {
            return;
        }
        HBCIMsgStatus status = ctx.getMsgStatus();
        if (status == null) {
            return;
        }
        List<HBCIRetVal> recvList = KnownReturncode.W3920.searchReturnValues(status);
        if (recvList == null || recvList.isEmpty()) {
            return;
        }
        HBCIUtils.log("autosecfunc: found " + recvList.size() + " 3920s in response, detect allowed twostep secmechs", 4);
        ArrayList<String> oldList = new ArrayList<String>(this.tanMethodsUser);
        HashSet<String> newSet = new HashSet<String>();
        for (HBCIRetVal r : recvList) {
            if (r.params == null) continue;
            newSet.addAll(Arrays.asList(r.params));
        }
        ArrayList newList = new ArrayList(newSet);
        if (newList.size() > 0 && !newList.equals(oldList)) {
            this.tanMethodsUser.clear();
            this.tanMethodsUser.addAll(newList);
            HBCIUtils.log("autosecfunc: found 3920 in response - updated list of allowed twostepmechs - old: " + oldList + ", new: " + this.tanMethodsUser, 4);
        }
        if (this.isAnonymous()) {
            return;
        }
        String oldMethod = this.tanMethod;
        String newMethod = this.getCurrentTANMethod(true);
        if (Objects.equals(oldMethod, newMethod)) {
            return;
        }
        if (ctx.getDialogInit().getTemplate() == KnownDialogTemplate.SYNC) {
            return;
        }
        HBCIUtils.log("autosecfunc: after this dialog-init we had to change selected pintan method from " + oldMethod + " to " + newMethod + ", so a restart of this dialog is needed", 4);
        HBCIUtils.log("Derzeitiges TAN-Verfahren aktualisiert, starte Dialog neu", 3);
        ctx.setRepeat(true);
    }

    private void check3072(DialogContext ctx) {
        HBCIRetVal[] seg;
        if (ctx.isAnonymous()) {
            return;
        }
        HBCIMsgStatus status = ctx.getMsgStatus();
        if (status == null) {
            return;
        }
        HBCIRetVal[] hBCIRetValArray = seg = status.segStatus != null ? status.segStatus.getWarnings() : null;
        if (seg == null) {
            return;
        }
        HBCIRetVal ret = KnownReturncode.W3072.searchReturnValue(seg);
        if (ret == null) {
            return;
        }
        String newCustomerId = "";
        String newUserId = "";
        int l2 = ret.params.length;
        if (l2 > 0) {
            newUserId = ret.params[0];
            newCustomerId = ret.params[0];
        }
        if (l2 > 1) {
            newCustomerId = ret.params[1];
        }
        if (l2 > 0) {
            HBCIUtils.log("autosecfunc: found 3072 in response - change user id", 4);
            StringBuffer retData = new StringBuffer();
            retData.append(newUserId + "|" + newCustomerId);
            HBCIUtilsInternal.getCallback().callback(this, 41, "*** User ID changed", 2, retData);
        }
    }

    private void checkSCARequest(DialogContext ctx) {
        KnownTANProcess.Variant variant;
        KnownTANProcess tp;
        HBCIUtils.log("check SCA request", 4);
        SCARequest sca = this.getSCARequest(ctx);
        if (sca == null) {
            HBCIUtils.log("no SCA request for this context, skipping check", 4);
            return;
        }
        Integer step = (Integer)ctx.getMeta().get(CACHE_KEY_SCA_STEP);
        if (step == null) {
            step = 1;
            ctx.getMeta().put(CACHE_KEY_SCA_STEP, step);
        }
        if ((tp = KnownTANProcess.get(variant = sca.getVariant(), step)) == KnownTANProcess.PROCESS2_STEP2) {
            Properties secmechInfo = this.getCurrentSecMechInfo();
            HHDVersion hhd = HHDVersion.find(secmechInfo);
            String segversion = secmechInfo != null ? secmechInfo.getProperty("segversion") : null;
            HBCIUtils.log("detected HHD version: " + (Object)((Object)hhd), 4);
            if (hhd != null && hhd.getType() == HHDVersion.Type.DECOUPLED) {
                Integer i = null;
                try {
                    i = Integer.parseInt(segversion);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i != null && i >= 7) {
                    HBCIUtils.log("switching TAN process from " + (Object)((Object)tp) + " to " + (Object)((Object)KnownTANProcess.PROCESS2_STEPS), 4);
                    tp = KnownTANProcess.PROCESS2_STEPS;
                }
            }
        }
        int version = sca.getVersion();
        HBCIKernelImpl k = ctx.getKernel();
        String prefix = "TAN2Step" + version;
        k.rawSet(prefix, "requested");
        k.rawSet(prefix + ".process", tp.getCode());
        String segcode = sca.getTanReference();
        if (Feature.PINTAN_SEGCODE_STRICT.isEnabled() && step == 2) {
            segcode = "";
        }
        HBCIUtils.log("creating HKTAN for SCA [process : " + (Object)((Object)tp) + ", order code: " + segcode + ", step: " + step + "]", 4);
        k.rawSet(prefix + ".ordersegcode", segcode);
        k.rawSet(prefix + ".OrderAccount.bic", "");
        k.rawSet(prefix + ".OrderAccount.iban", "");
        k.rawSet(prefix + ".OrderAccount.number", "");
        k.rawSet(prefix + ".OrderAccount.subnumber", "");
        k.rawSet(prefix + ".OrderAccount.KIK.blz", "");
        k.rawSet(prefix + ".OrderAccount.KIK.country", "");
        k.rawSet(prefix + ".orderhash", variant == KnownTANProcess.Variant.V2 ? "" : "B00000000");
        k.rawSet(prefix + ".orderref", step == 2 ? (String)this.getPersistentData(KEY_PD_ORDERREF) : "");
        k.rawSet(prefix + ".notlasttan", tp == KnownTANProcess.PROCESS1 || step == 2 ? "N" : "");
        k.rawSet(prefix + ".challengeklass", variant == KnownTANProcess.Variant.V2 ? "" : "99");
        k.rawSet(prefix + ".tanmedia", sca.getTanMedia());
    }

    private SCARequest getSCARequest(DialogContext ctx) {
        int hktanVersion;
        HBCIUtils.log("create new SCA request", 4);
        RawHBCIDialog init = ctx.getDialogInit();
        if (init == null) {
            HBCIUtils.log("have no dialog init, skip SCA request creation", 4);
            return null;
        }
        if (!KnownDialogTemplate.LIST_SEND_SCA.contains((Object)init.getTemplate())) {
            HBCIUtils.log("dialog (" + (Object)((Object)init.getTemplate()) + ") not in list of SCA dialogs, skip SCA request creation", 4);
            return null;
        }
        if (Feature.PINTAN_INIT_SKIPONESTEPSCA.isEnabled()) {
            KnownDialogTemplate tpl = init.getTemplate();
            String currentTanMethod = this.getCurrentTANMethod(false);
            if (!ctx.isAnonymous() && Objects.equals(TanMethod.ONESTEP.getId(), currentTanMethod) && (tpl == KnownDialogTemplate.INIT || Feature.INIT_FLIP_USER_INST.isEnabled() && tpl == KnownDialogTemplate.SYNC)) {
                HBCIUtils.log("skipping HKTAN for dialog init [anon: " + ctx.isAnonymous() + ", current tan method: " + currentTanMethod + ", tpl: " + (Object)((Object)tpl) + "]", 4);
                return null;
            }
        }
        int segversionDefault = 6;
        Properties secmechInfo = this.getCurrentSecMechInfo();
        int n = hktanVersion = secmechInfo != null ? NumberUtil.parseInt(secmechInfo.getProperty("segversion"), 6) : 6;
        if (hktanVersion < 6) {
            HBCIUtils.log("HKTAN version < 6, skip SCA request creation", 4);
            return null;
        }
        SCARequest r = init.createSCARequest(secmechInfo, hktanVersion);
        if (r == null) {
            HBCIUtils.log("have no SCA request, skip SCA request creation", 4);
            return null;
        }
        if (r.getTanReference() == null) {
            String segcode = "HKIDN";
            HBCIDialog payload = ctx.getDialog();
            if (payload != null) {
                HBCIMessageQueue queue = payload.getMessageQueue();
                for (String code : Arrays.asList("HKPAE", "HKTAB")) {
                    if (queue.findTask(code) == null) continue;
                    segcode = code;
                    break;
                }
            }
            r.setTanReference(segcode);
        }
        if (r.getTanMedia() == null) {
            r.setTanMedia(this.getTanMedia(hktanVersion));
        }
        return r;
    }

    private void checkSCAResponse(DialogContext ctx) {
        HBCIUtils.log("check SCA response", 4);
        RawHBCIDialog init = ctx.getDialogInit();
        if (init == null) {
            HBCIUtils.log("no init dialog, skip SCA response analysis", 4);
            return;
        }
        if (!KnownDialogTemplate.LIST_SEND_SCA.contains((Object)init.getTemplate())) {
            HBCIUtils.log("dialog (" + (Object)((Object)init.getTemplate()) + ") not in list of SCA dialogs, skip SCA response analysis", 4);
            return;
        }
        if (ctx.isAnonymous() || this.isAnonymous()) {
            HBCIUtils.log("anonymous dialog, skip SCA response analysis", 4);
            ctx.getMeta().remove(CACHE_KEY_SCA_STEP);
            return;
        }
        Integer scaStep = (Integer)ctx.getMeta().get(CACHE_KEY_SCA_STEP);
        if (scaStep == null) {
            HBCIUtils.log("no sca request sent, skip SCA response analysis", 4);
            return;
        }
        HBCIMsgStatus status = ctx.getMsgStatus();
        if (status == null) {
            HBCIUtils.log("no message status received, skip SCA response analysis", 4);
            return;
        }
        if (status.segStatus != null && (KnownReturncode.W3076.searchReturnValue(status.segStatus.getWarnings()) != null || KnownReturncode.W3076.searchReturnValue(status.globStatus.getWarnings()) != null)) {
            HBCIUtils.log("found status code 3076, no SCA required", 4);
            ctx.getMeta().remove(CACHE_KEY_SCA_STEP);
            return;
        }
        if (scaStep == 1) {
            String orderref;
            String hhdUc;
            HBCIUtils.log("HKTAN step 1 for SCA sent, checking for HITAN response [step: " + scaStep + "]", 4);
            Properties props = ParameterFinder.find(status.getData(), "TAN2StepRes*.");
            if (props == null || props.size() == 0) {
                HBCIUtils.log("no hitan reponse data found", 4);
                return;
            }
            HBCIUtils.log("SCA HITAN response found, triggering TAN request", 4);
            String challenge = props.getProperty("challenge");
            if (challenge != null && challenge.length() > 0) {
                this.setPersistentData(KEY_PD_CHALLENGE, challenge);
            }
            if ((hhdUc = props.getProperty("challenge_hhd_uc")) != null && hhdUc.length() > 0) {
                this.setPersistentData(KEY_PD_HHDUC, hhdUc);
            }
            if ((orderref = props.getProperty("orderref")) != null && orderref.length() > 0) {
                this.setPersistentData(KEY_PD_ORDERREF, orderref);
            }
            ctx.getMeta().put(CACHE_KEY_SCA_STEP, 2);
            ctx.getDialogInit().setTemplate(KnownDialogTemplate.INIT_SCA);
            ctx.setRepeat(true);
            return;
        }
        if (scaStep == 2) {
            ctx.getMeta().remove(CACHE_KEY_SCA_STEP);
            HBCIUtils.log("HKTAN step 2 for SCA sent, checking for HITAN response [step: " + scaStep + "]", 4);
            Properties props = ParameterFinder.find(status.getData(), "TAN2StepRes*.");
            if (props.size() > 0) {
                HBCIUtils.log("final SCA HITAN response found", 4);
            }
        }
    }

    @Override
    public Comm getCommInstance() {
        return Comm.getInstance("PinTan", this);
    }

    @Override
    public boolean isSupported() {
        Properties bpd = this.getBPD();
        if (bpd == null) {
            return true;
        }
        this.getCurrentTANMethod(true);
        return true;
    }

    private boolean isOneStepAllowed() {
        Properties bpd = this.getBPD();
        if (bpd == null) {
            return true;
        }
        return ParameterFinder.findAll(bpd, ParameterFinder.Query.BPD_PINTAN_CAN1STEP).containsValue("J");
    }

    public void resetSecMechs() {
        this.tanMethodsUser = new ArrayList<String>();
        this.tanMethod = null;
        this.tanMethodAutoSelected = false;
    }

    public void setCurrentTANMethod(String method) {
        this.tanMethod = method;
    }

    public String getCurrentTANMethod(boolean recheck) {
        if (this.tanMethod != null && !recheck) {
            return this.tanMethod;
        }
        boolean auto = Feature.PINTAN_INIT_AUTOMETHOD.isEnabled();
        HBCIUtils.log("(re)checking selected pintan method using " + (auto ? "auto-determine" : "ask") + " strategy", 4);
        if (auto) {
            return this.determineTanMethod();
        }
        return this.askForTanMethod();
    }

    private String determineTanMethod() {
        boolean reuse;
        TanMethod m2;
        if (this.tanMethodsUser.size() == 0 && this.isOneStepAllowed()) {
            return TanMethod.ONESTEP.getId();
        }
        ArrayList<TanMethod> userList = new ArrayList<TanMethod>();
        ArrayList<TanMethod> bankList = new ArrayList<TanMethod>();
        Object[] secfuncs = this.tanMethodsBank.keySet().toArray(new String[this.tanMethodsBank.size()]);
        Arrays.sort(secfuncs);
        for (Object secfunc : secfuncs) {
            Properties entry = this.tanMethodsBank.get(secfunc);
            TanMethod m3 = new TanMethod((String)secfunc, entry.getProperty("name"));
            if (this.tanMethodsUser.contains(secfunc)) {
                userList.add(m3);
            }
            bankList.add(m3);
        }
        HBCIUtils.log("tan methods of institute: " + bankList, 4);
        HBCIUtils.log("tan methods for user: " + userList, 4);
        if (userList.size() == 0) {
            if (this.isOneStepAllowed()) {
                m2 = TanMethod.ONESTEP;
                HBCIUtils.log("no tan method available for user, using: " + m2, 4);
                return m2.getId();
            }
            if (bankList.size() == 0) {
                m2 = TanMethod.ONESTEP;
                HBCIUtils.log("no tan method available for bank, using: " + m2, 4);
                return m2.getId();
            }
            HBCIUtils.log("have no methods for user and institute doesn't allow one step method - asking user. available methods on institute: " + bankList, 4);
            this.setCurrentTANMethod(this.chooseTANMethod(bankList));
            HBCIUtils.log("selected pintan method by user: " + this.tanMethod, 3);
            return this.tanMethod;
        }
        if (userList.size() == 1) {
            m2 = (TanMethod)userList.get(0);
            HBCIUtils.log("only one tan method available for user: " + m2, 4);
            this.setCurrentTANMethod(m2.getId());
            return this.tanMethod;
        }
        boolean bl = reuse = this.tanMethod != null && userList.stream().anyMatch(m -> Objects.equals(m.getId(), this.tanMethod));
        if (reuse) {
            return this.tanMethod;
        }
        HBCIUtils.log("asking user what tan method to use. available methods: " + userList, 4);
        this.setCurrentTANMethod(this.chooseTANMethod(userList));
        HBCIUtils.log("selected pintan method by user: " + this.tanMethod, 3);
        return this.tanMethod;
    }

    private String askForTanMethod() {
        TanMethod m;
        String selected;
        ArrayList<TanMethod> options = new ArrayList<TanMethod>();
        ArrayList<TanMethod> fallback = new ArrayList<TanMethod>();
        if (this.isOneStepAllowed()) {
            TanMethod m2 = TanMethod.ONESTEP;
            if (this.tanMethodsUser.size() == 0 || this.tanMethodsUser.contains(m2.getId())) {
                options.add(m2);
            }
        }
        Object[] secfuncs = this.tanMethodsBank.keySet().toArray(new String[this.tanMethodsBank.size()]);
        Arrays.sort(secfuncs);
        for (Object secfunc : secfuncs) {
            Properties entry = this.tanMethodsBank.get(secfunc);
            TanMethod m3 = new TanMethod((String)secfunc, entry.getProperty("name"));
            if (this.tanMethodsUser.size() == 0 || this.tanMethodsUser.contains(secfunc)) {
                options.add(m3);
            }
            fallback.add(m3);
        }
        if (options.size() == 0) {
            this.tanMethodAutoSelected = true;
            HBCIUtils.log("autosecfunc: no information about allowed pintan methods available", 3);
            if (fallback.size() > 0) {
                HBCIUtils.log("autosecfunc: have some pintan methods in HIPINS, asking user, what to use from: " + fallback, 3);
                selected = this.chooseTANMethod(fallback);
                this.setCurrentTANMethod(selected);
                HBCIUtils.log("autosecfunc: manually selected pintan method from HIPINS " + this.tanMethod, 4);
            } else {
                m = TanMethod.ONESTEP;
                HBCIUtils.log("autosecfunc: absolutly no information about allowed pintan methods available, fallback to " + m, 2);
                this.setCurrentTANMethod(m.getId());
            }
            return this.tanMethod;
        }
        if (options.size() == 1) {
            m = (TanMethod)options.get(0);
            HBCIUtils.log("autosecfunc: there is only one pintan method supported - choosing this automatically: " + m, 4);
            if (this.tanMethod != null && !this.tanMethod.equals(m.getId())) {
                HBCIUtils.log("autosecfunc: auto-selected method differs from current: " + this.tanMethod, 4);
            }
            this.setCurrentTANMethod(m.getId());
            this.tanMethodAutoSelected = true;
            return this.tanMethod;
        }
        if (this.tanMethod != null) {
            TanMethod m4;
            boolean found = false;
            Iterator iterator = options.iterator();
            while (iterator.hasNext() && !(found |= this.tanMethod.equals((m4 = (TanMethod)iterator.next()).getId()))) {
            }
            if (!found) {
                HBCIUtils.log("autosecfunc: currently selected pintan method (" + this.tanMethod + ") not in list of supported methods  " + options + " - resetting current selection", 4);
                this.tanMethod = null;
            }
        }
        if (this.tanMethod != null && !this.tanMethodAutoSelected) {
            return this.tanMethod;
        }
        if (options != null && options.size() > 0) {
            HBCIUtils.log("autosecfunc: asking user what tan method to use. available methods: " + options, 4);
            selected = this.chooseTANMethod(options);
            this.setCurrentTANMethod(selected);
            this.tanMethodAutoSelected = false;
            HBCIUtils.log("autosecfunc: manually selected pintan method " + this.tanMethod, 4);
        }
        return this.tanMethod;
    }

    private String chooseTANMethod(List<TanMethod> options) {
        StringBuffer retData = new StringBuffer();
        for (TanMethod entry : options) {
            if (retData.length() != 0) {
                retData.append("|");
            }
            retData.append(entry.getId()).append(":").append(entry.getName());
        }
        HBCIUtilsInternal.getCallback().callback(this, 27, "*** Select a pintan method from the list", 2, retData);
        String selected = retData.toString();
        for (TanMethod entry : options) {
            if (!selected.equals(entry.getId())) continue;
            return selected;
        }
        throw new InvalidUserDataException("*** selected pintan method not supported: " + selected);
    }

    public Properties getCurrentSecMechInfo() {
        return this.tanMethodsBank.get(this.getCurrentTANMethod(false));
    }

    public Hashtable<String, Properties> getTwostepMechanisms() {
        return this.tanMethodsBank;
    }

    @Override
    public String getProfileMethod() {
        return "PIN";
    }

    @Override
    public String getProfileVersion() {
        return this.getCurrentTANMethod(false).equals(TanMethod.ONESTEP.getId()) ? "1" : "2";
    }

    @Override
    public boolean needUserKeys() {
        return false;
    }

    @Override
    public boolean needInstKeys() {
        return false;
    }

    @Override
    public boolean needUserSig() {
        return true;
    }

    @Override
    public String getSysStatus() {
        return "1";
    }

    @Override
    public boolean hasInstSigKey() {
        return true;
    }

    @Override
    public boolean hasInstEncKey() {
        return true;
    }

    @Override
    public boolean hasMySigKey() {
        return true;
    }

    @Override
    public boolean hasMyEncKey() {
        return true;
    }

    @Override
    public HBCIKey getInstSigKey() {
        return null;
    }

    @Override
    public HBCIKey getInstEncKey() {
        return null;
    }

    @Override
    public String getInstSigKeyName() {
        return this.getUserId();
    }

    @Override
    public String getInstSigKeyNum() {
        return "0";
    }

    @Override
    public String getInstSigKeyVersion() {
        return "0";
    }

    @Override
    public String getInstEncKeyName() {
        return this.getUserId();
    }

    @Override
    public String getInstEncKeyNum() {
        return "0";
    }

    @Override
    public String getInstEncKeyVersion() {
        return "0";
    }

    @Override
    public String getMySigKeyName() {
        return this.getUserId();
    }

    @Override
    public String getMySigKeyNum() {
        return "0";
    }

    @Override
    public String getMySigKeyVersion() {
        return "0";
    }

    @Override
    public String getMyEncKeyName() {
        return this.getUserId();
    }

    @Override
    public String getMyEncKeyNum() {
        return "0";
    }

    @Override
    public String getMyEncKeyVersion() {
        return "0";
    }

    @Override
    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateDigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPublicSigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateSigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return null;
    }

    @Override
    public String getCryptMode() {
        return "2";
    }

    @Override
    public String getCryptAlg() {
        return "13";
    }

    @Override
    public String getCryptKeyType() {
        return "5";
    }

    @Override
    public String getSigFunction() {
        return this.getCurrentTANMethod(false);
    }

    @Override
    public String getCryptFunction() {
        return "998";
    }

    @Override
    public String getSigAlg() {
        return "10";
    }

    @Override
    public String getSigMode() {
        return "16";
    }

    @Override
    public String getHashAlg() {
        return "999";
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
    }

    @Override
    public void incSigId() {
    }

    protected String collectSegCodes(String msg) {
        int endPosi;
        StringBuffer ret = new StringBuffer();
        int len = msg.length();
        int posi = 0;
        while ((endPosi = msg.indexOf(58, posi)) != -1) {
            String segcode = msg.substring(posi, endPosi);
            if (ret.length() != 0) {
                ret.append("|");
            }
            ret.append(segcode);
            while (posi < len && msg.charAt(posi) != '\'') {
                posi = HBCIUtilsInternal.getPosiOfNextDelimiter(msg, posi + 1);
            }
            if (posi >= len) break;
            ++posi;
        }
        return ret.toString();
    }

    public String getPinTanInfo(String code) {
        String ret = "";
        Properties bpd = this.getBPD();
        if (bpd == null) {
            return ret;
        }
        boolean isGV = false;
        String paramCode = StringUtil.toParameterCode(code);
        Enumeration<?> e = bpd.propertyNames();
        while (e.hasMoreElements()) {
            String code2;
            String key = (String)e.nextElement();
            if (key.startsWith("Params") && key.substring(key.indexOf(".") + 1).startsWith("PinTanPar") && key.indexOf(".ParPinTan.PinTanGV") != -1 && key.endsWith(".segcode")) {
                code2 = bpd.getProperty(key);
                if (!code.equals(code2)) continue;
                key = key.substring(0, key.length() - "segcode".length()) + "needtan";
                ret = bpd.getProperty(key);
                break;
            }
            if (!key.startsWith("Params") || !key.endsWith(".SegHead.code") || !paramCode.equals(code2 = bpd.getProperty(key))) continue;
            isGV = true;
        }
        if (ret.length() == 0 && !isGV) {
            if (this.verifyTANMode && code.equals("HKIDN")) {
                ret = "J";
                this.deactivateTANVerifyMode();
            } else {
                ret = "A";
            }
        }
        return ret;
    }

    public void deactivateTANVerifyMode() {
        this.verifyTANMode = false;
    }

    public void activateTANVerifyMode() {
        this.verifyTANMode = true;
    }

    public void setCertFile(String filename) {
        this.certfile = filename;
    }

    public String getCertFile() {
        return this.certfile;
    }

    protected void setCheckCert(boolean doCheck) {
        this.checkCert = doCheck;
    }

    public boolean getCheckCert() {
        return this.checkCert;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getProxyPass() {
        return this.proxypass;
    }

    public String getProxyUser() {
        return this.proxyuser;
    }

    public void setProxyPass(String proxypass) {
        this.proxypass = proxypass;
    }

    public void setProxyUser(String proxyuser) {
        this.proxyuser = proxyuser;
    }

    private String getOrderHashMode() {
        Properties bpd = this.getBPD();
        if (bpd == null) {
            return null;
        }
        Properties props = this.getCurrentSecMechInfo();
        String segVersion = props.getProperty("segversion");
        String s = ParameterFinder.getValue(bpd, ParameterFinder.Query.BPD_PINTAN_ORDERHASHMODE.withParameters(segVersion != null ? segVersion : ""), null);
        if ("1".equals(s)) {
            return "RIPEMD160";
        }
        if ("2".equals(s)) {
            return "SHA-1";
        }
        throw new HBCI_Exception("unknown orderhash mode " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchMessagesFor2StepMethods(DialogContext ctx) {
        HBCIDialog dialog = ctx.getDialog();
        if (dialog == null) {
            return;
        }
        HBCIMessageQueue queue = dialog.getMessageQueue();
        if (queue == null) {
            return;
        }
        String tanMethod = this.getCurrentTANMethod(false);
        if (tanMethod.equals(TanMethod.ONESTEP.getId())) {
            return;
        }
        HBCIUtils.log("patching message for twostep method", 4);
        HBCIHandler handler = (HBCIHandler)this.getParentHandlerData();
        Properties secmechInfo = this.getCurrentSecMechInfo();
        String segversion = secmechInfo.getProperty("segversion");
        String process = secmechInfo.getProperty("process");
        for (HBCIMessage message : queue.getMessages()) {
            for (HBCIJobImpl task : message.getTasks()) {
                if (task.haveTan()) continue;
                String segcode = task.getHBCICode();
                if (!this.getPinTanInfo(segcode).equals("J")) {
                    HBCIUtils.log("found task that does not require HKTAN: " + segcode + " - adding it to current msg", 4);
                    continue;
                }
                HBCIUtils.log("found task that probably requires HKTAN: " + segcode + " - have to patch message queue", 4);
                GVTAN2Step hktan = (GVTAN2Step)handler.newJob("TAN2Step");
                hktan.setParam("ordersegcode", task.getHBCICode());
                hktan.setExternalId(task.getExternalId());
                hktan.setSegVersion(segversion);
                task.tanApplied();
                String tanMedia = this.getTanMedia(Integer.parseInt(hktan.getSegVersion()));
                if (tanMedia != null && tanMedia.length() > 0) {
                    hktan.setParam("tanmedia", tanMedia);
                }
                if (process.equals("1")) {
                    HBCIUtils.log("process variant 1: adding new message with HKTAN(p=1,hash=...) before current message", 4);
                    hktan.setProcess(KnownTANProcess.PROCESS1);
                    hktan.setParam("notlasttan", "N");
                    int hktanVersion = Integer.parseInt(hktan.getSegVersion());
                    if (hktanVersion >= 5) {
                        String noa = secmechInfo.getProperty("needorderaccount", "");
                        HBCIUtils.log("needorderaccount=" + noa, 4);
                        if (noa.equals("2")) {
                            Konto k = task.getOrderAccount();
                            if (k != null) {
                                HBCIUtils.log("applying orderaccount to HKTAN for " + task.getHBCICode(), 4);
                                hktan.setParam("orderaccount", k);
                            } else {
                                HBCIUtils.log("orderaccount needed, but not found in " + task.getHBCICode(), 2);
                            }
                        }
                    }
                    if (secmechInfo.getProperty("needchallengeklass", "N").equals("J")) {
                        ChallengeInfo cinfo = ChallengeInfo.getInstance();
                        cinfo.applyParams(task, hktan, secmechInfo);
                    }
                    SEG seg = null;
                    try {
                        seg = task.createJobSegment(3);
                        seg.validate();
                        String segdata = seg.toString(0);
                        HBCIUtils.log("calculating hash for jobsegment: " + segdata, 5);
                        hktan.setParam("orderhash", CryptUtils.hash(segdata, this.getOrderHashMode()));
                    }
                    finally {
                        SEGFactory.getInstance().unuseObject(seg);
                    }
                    HBCIMessage newMsg = queue.insertBefore(message);
                    newMsg.append(hktan);
                    continue;
                }
                HBCIUtils.log("process variant 2: adding new task HKTAN(p=4) to current message", 4);
                hktan.setProcess(KnownTANProcess.PROCESS2_STEP1);
                message.append(hktan);
                HBCIUtils.log("process variant 2: creating new msg with HKTAN(p=2,orderref=DELAYED)", 4);
                KnownTANProcess proc = KnownTANProcess.PROCESS2_STEP2;
                HHDVersion hhd = HHDVersion.find(secmechInfo);
                HBCIUtils.log("detected HHD version: " + (Object)((Object)hhd), 4);
                if (hhd.getType() == HHDVersion.Type.DECOUPLED) {
                    Integer i = null;
                    try {
                        i = Integer.parseInt(segversion);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (i != null && i >= 7) {
                        HBCIUtils.log("using decoupled hktan for step 2", 4);
                        proc = KnownTANProcess.PROCESS2_STEPS;
                    }
                }
                GVTAN2Step hktan2 = (GVTAN2Step)handler.newJob("TAN2Step");
                hktan2.setProcess(proc);
                hktan2.setExternalId(task.getExternalId());
                hktan2.setSegVersion(segversion);
                hktan2.setParam("notlasttan", "N");
                HBCIUtils.log("storing reference to original job in new HKTAN segment", 4);
                hktan2.setTask(task);
                hktan.setStep2(hktan2);
                HBCIUtils.log("adding new message with HKTAN(p=2) after current one", 4);
                HBCIMessage newMsg = queue.insertAfter(message);
                newMsg.append(hktan2);
            }
        }
    }

    private String getTanMedia(int segVersion) {
        HBCIUtils.log("HKTAN version: " + segVersion, 4);
        if (segVersion < 3) {
            return "";
        }
        Properties secmechInfo = this.getCurrentSecMechInfo();
        String needed = secmechInfo != null ? secmechInfo.getProperty("needtanmedia", "") : "";
        HBCIUtils.log("needtanmedia: " + needed, 4);
        boolean tn = Objects.equals(needed, "2");
        if (tn) {
            HBCIUtils.log("we have to add the tan media", 4);
            StringBuffer retData = new StringBuffer();
            Properties upd = this.getUPD();
            if (upd != null) {
                retData.append(upd.getProperty("tanmedia.names", ""));
            }
            HBCIUtilsInternal.getCallback().callback(this, 32, "*** Enter the name of your TAN media", 2, retData);
            String result = retData.toString();
            if (StringUtil.hasText(result)) {
                return result;
            }
        }
        return tn ? "noref" : "";
    }

    public void setPIN(String pin) {
        this.pin = pin;
    }

    public String getPIN() {
        return this.pin;
    }

    public void clearPIN() {
        this.setPIN(null);
    }

    public List<String> getAllowedTwostepMechanisms() {
        return this.tanMethodsUser;
    }

    public void setAllowedTwostepMechanisms(List<String> l) {
        this.tanMethodsUser = l;
    }

    @Override
    public int getMaxGVSegsPerMsg() {
        return 1;
    }

    @Override
    public String getHost() {
        String host = super.getHost();
        if (host == null || host.length() == 0 || !host.startsWith("https://")) {
            return host;
        }
        return host.replace("https://", "");
    }
}

