/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.kapott.cryptalgs.RSAPrivateCrtKey2;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractRDHPassport;
import org.kapott.hbci.tools.CryptUtils;

public abstract class AbstractRDHSWPassport
extends AbstractRDHPassport {
    protected HBCIKey[][] keys = new HBCIKey[3][];

    protected AbstractRDHSWPassport(Object init) {
        super(init);
        for (int i = 0; i < 3; ++i) {
            this.keys[i] = new HBCIKey[2];
            for (int j = 0; j < 2; ++j) {
                this.keys[i][j] = null;
            }
        }
    }

    @Override
    public boolean hasInstSigKey() {
        return this.getInstSigKey() != null;
    }

    @Override
    public boolean hasInstEncKey() {
        return this.getInstEncKey() != null;
    }

    @Override
    public boolean hasMySigKey() {
        return this.getMyPublicSigKey() != null;
    }

    @Override
    public boolean hasMyEncKey() {
        return this.getMyPublicEncKey() != null;
    }

    public HBCIKey getKey(int i, int j) {
        return this.keys[i][j];
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
        this.setKey(0, 0, key);
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
        this.setKey(0, 1, key);
    }

    public void setMySigKey(HBCIKey key) {
        this.setKey(1, 0, key);
        this.setKey(1, 1, key);
    }

    public void setMyEncKey(HBCIKey key) {
        this.setKey(2, 0, key);
        this.setKey(2, 1, key);
    }

    public void setMyDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
        this.setKey(1, 0, key);
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
        this.setKey(1, 1, key);
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
        this.setKey(2, 0, key);
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
        this.setKey(2, 1, key);
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public HBCIKey getMyPublicSigKey() {
        return this.getKey(1, 0);
    }

    @Override
    public HBCIKey getMyPrivateSigKey() {
        return this.getKey(1, 1);
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return this.getKey(2, 0);
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return this.getKey(2, 1);
    }

    @Override
    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateDigKey() {
        return null;
    }

    @Override
    public HBCIKey getInstSigKey() {
        return this.getKey(0, 0);
    }

    @Override
    public String getInstSigKeyName() {
        return this.getInstSigKey() != null ? this.getInstSigKey().userid : null;
    }

    @Override
    public String getInstSigKeyNum() {
        return this.getInstSigKey() != null ? this.getInstSigKey().num : null;
    }

    @Override
    public String getInstSigKeyVersion() {
        return this.getInstSigKey() != null ? this.getInstSigKey().version : null;
    }

    @Override
    public HBCIKey getInstEncKey() {
        return this.getKey(0, 1);
    }

    @Override
    public String getInstEncKeyName() {
        return this.getInstEncKey() != null ? this.getInstEncKey().userid : null;
    }

    @Override
    public String getInstEncKeyNum() {
        return this.getInstEncKey() != null ? this.getInstEncKey().num : null;
    }

    @Override
    public String getInstEncKeyVersion() {
        return this.getInstEncKey() != null ? this.getInstEncKey().version : null;
    }

    @Override
    public String getMySigKeyName() {
        return this.getMyPublicSigKey() != null ? this.getMyPublicSigKey().userid : null;
    }

    @Override
    public String getMySigKeyNum() {
        return this.getMyPublicSigKey() != null ? this.getMyPublicSigKey().num : null;
    }

    @Override
    public String getMySigKeyVersion() {
        return this.getMyPublicSigKey() != null ? this.getMyPublicSigKey().version : null;
    }

    @Override
    public String getMyEncKeyName() {
        return this.getMyPublicEncKey() != null ? this.getMyPublicEncKey().userid : null;
    }

    @Override
    public String getMyEncKeyNum() {
        return this.getMyPublicEncKey() != null ? this.getMyPublicEncKey().num : null;
    }

    @Override
    public String getMyEncKeyVersion() {
        return this.getMyPublicEncKey() != null ? this.getMyPublicEncKey().version : null;
    }

    public final void setKey(int i, int j, HBCIKey key) {
        this.keys[i][j] = key;
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            Signature sig = this.getSignatureInstance();
            sig.initSign((PrivateKey)this.getMyPrivateSigKey().key);
            sig.update(data);
            byte[] result = sig.sign();
            result = AbstractRDHSWPassport.checkForCryptDataSize(result, this.getCryptDataSize(this.getMyPublicSigKey().key));
            return result;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing of message failed", ex);
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        try {
            Signature sign = this.getSignatureInstance();
            sign.initVerify((PublicKey)this.getInstSigKey().key);
            sign.update(data);
            return sign.verify(sig);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** verification of message signature failed", ex);
        }
    }

    private byte[] encryptMessage(byte[] plainMsg, SecretKey msgkey) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            Cipher cipher = provider == null ? Cipher.getInstance("DESede/CBC/NoPadding") : Cipher.getInstance("DESede/CBC/NoPadding", provider);
            byte[] iv = new byte[8];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec spec = new IvParameterSpec(iv);
            cipher.init(1, (Key)msgkey, spec);
            return cipher.doFinal(plainMsg);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** can not encrypt message", ex);
        }
    }

    private byte[] encryptKey(SecretKey msgkey) {
        try {
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory factory = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            DESedeKeySpec spec = (DESedeKeySpec)factory.getKeySpec(msgkey, DESedeKeySpec.class);
            byte[] plainKey = spec.getKey();
            int cryptDataSize = this.getCryptDataSize(this.getInstEncKey().key);
            byte[] plainText = new byte[cryptDataSize];
            Arrays.fill(plainText, (byte)0);
            System.arraycopy(plainKey, 0, plainText, plainText.length - 16, 16);
            BigInteger m = new BigInteger(1, plainText);
            Key k = this.getInstEncKey().key;
            BigInteger c = m.modPow(((RSAPublicKey)k).getPublicExponent(), ((RSAPublicKey)k).getModulus());
            byte[] result = c.toByteArray();
            result = AbstractRDHSWPassport.checkForCryptDataSize(result, cryptDataSize);
            return result;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** can not encrypt message key", ex);
        }
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            SecretKey msgkey = this.createMsgKey();
            byte[] cryptMsg = this.encryptMessage(plainMsg, msgkey);
            byte[] cryptKey = this.encryptKey(msgkey);
            byte[][] ret = new byte[][]{cryptKey, cryptMsg};
            return ret;
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while encrypting", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] cryptedMsg) {
        try {
            byte[] plainKey;
            Key k = this.getMyPrivateEncKey().key;
            if (k instanceof RSAPrivateKey) {
                HBCIUtils.log("decrypting message key with (n,d)-algorithm", 4);
                BigInteger exponent = ((RSAPrivateKey)k).getPrivateExponent();
                BigInteger modulus = ((RSAPrivateKey)k).getModulus();
                BigInteger c = new BigInteger(1, cryptedKey);
                plainKey = c.modPow(exponent, modulus).toByteArray();
            } else {
                HBCIUtils.log("decrypting message key with (p,q,dP,dQ,qInv)-algorithm", 4);
                BigInteger p = ((RSAPrivateCrtKey2)k).getP();
                BigInteger q = ((RSAPrivateCrtKey2)k).getQ();
                BigInteger dP = ((RSAPrivateCrtKey2)k).getdP();
                BigInteger dQ = ((RSAPrivateCrtKey2)k).getdQ();
                BigInteger qInv = ((RSAPrivateCrtKey2)k).getQInv();
                BigInteger c = new BigInteger(1, cryptedKey);
                BigInteger m1 = c.modPow(dP, p);
                BigInteger m2 = c.modPow(dQ, q);
                BigInteger h = m1.subtract(m2).multiply(qInv).mod(p);
                plainKey = m2.add(q.multiply(h)).toByteArray();
            }
            byte[] realPlainKey = new byte[24];
            System.arraycopy(plainKey, plainKey.length - 16, realPlainKey, 0, 16);
            System.arraycopy(plainKey, plainKey.length - 16, realPlainKey, 16, 8);
            DESedeKeySpec spec = new DESedeKeySpec(realPlainKey);
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory fac = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            SecretKey key = fac.generateSecret(spec);
            Cipher cipher = provider == null ? Cipher.getInstance("DESede/CBC/NoPadding") : Cipher.getInstance("DESede/CBC/NoPadding", provider);
            byte[] ivarray = new byte[8];
            Arrays.fill(ivarray, (byte)0);
            IvParameterSpec iv = new IvParameterSpec(ivarray);
            cipher.init(2, (Key)key, iv);
            return cipher.doFinal(cryptedMsg);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while decrypting message", ex);
        }
    }

    private int getKeySizeByProfile() {
        int ret = -1;
        int profile = Integer.parseInt(this.getProfileVersion());
        switch (profile) {
            case 1: {
                ret = 768;
                break;
            }
            case 2: {
                ret = 2048;
                break;
            }
            case 10: {
                HBCIKey k = this.getInstSigKey();
                if (k == null) {
                    k = this.getInstEncKey();
                }
                if (k != null) {
                    RSAPublicKey pkey = (RSAPublicKey)k.key;
                    ret = pkey.getModulus().bitLength();
                    break;
                }
                ret = 4096;
                break;
            }
            default: {
                throw new HBCI_Exception("*** dont know which keysize to use for profile rdh-" + profile);
            }
        }
        HBCIUtils.log("using keysize " + ret + " bits for newly generated keys", 4);
        return ret;
    }

    @Override
    public HBCIKey[][] generateNewUserKeys() {
        HBCIKey[] newSigKey = null;
        HBCIKey[] newEncKey = null;
        try {
            HBCIUtils.log("Erzeuge neue Benutzerschl\u00fcssel", 3);
            String blz = this.getBLZ();
            String country = this.getCountry();
            String userid = this.getUserId();
            String profileVersion = this.getProfileVersion();
            newSigKey = new HBCIKey[2];
            newEncKey = new HBCIKey[2];
            String num = this.hasMySigKey() ? this.getMyPublicSigKey().num : profileVersion;
            String version = this.hasMySigKey() ? this.getMyPublicSigKey().version : "0";
            version = Integer.toString(Integer.parseInt(version) + 1);
            int keySize = this.getKeySizeByProfile();
            for (int i = 0; i < 2; ++i) {
                KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
                keygen.initialize(keySize);
                KeyPair pair = keygen.generateKeyPair();
                if (i == 0) {
                    newSigKey[0] = new HBCIKey(country, blz, userid, num, version, pair.getPublic());
                    newSigKey[1] = new HBCIKey(country, blz, userid, num, version, pair.getPrivate());
                    continue;
                }
                newEncKey[0] = new HBCIKey(country, blz, userid, num, version, pair.getPublic());
                newEncKey[1] = new HBCIKey(country, blz, userid, num, version, pair.getPrivate());
            }
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_GENKEYS_ERR"), ex);
        }
        HBCIKey[][] ret = new HBCIKey[][]{newSigKey, newEncKey, null};
        return ret;
    }
}

