/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import org.kapott.hbci.comm.Comm;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;

public class HBCIPassportAnonymous
extends AbstractHBCIPassport {
    private String filename;

    public HBCIPassportAnonymous(Object initObject) {
        super(initObject);
        String header = "client.passport.Anonymous.";
        String filename = HBCIUtils.getParam(header + "filename");
        boolean init = HBCIUtils.getParam(header + "init", "1").equals("1");
        if (filename == null) {
            throw new NullPointerException("*** client.passport.Anonymous.filename must not be null");
        }
        HBCIUtils.log("loading passport data from file " + filename, 4);
        this.setFileName(filename);
        this.setFilterType("None");
        this.setPort(3000);
        if (init) {
            HBCIUtils.log("loading data from file " + filename, 4);
            if (!new File(filename).canRead()) {
                HBCIUtils.log("have to create new passport file", 2);
                this.askForMissingData(true, true, true, true, false, false, false);
                this.saveChanges();
            }
            PassportData data = PassportStorage.load((HBCIPassport)this, new File(filename));
            this.setBLZ(data.blz);
            this.setCountry(data.country);
            this.setHost(data.host);
            this.setPort(data.port);
            this.setHBCIVersion(data.hbciVersion);
            this.setBPD(data.bpd);
            this.setUPD(data.upd);
            if (this.askForMissingData(true, true, true, true, false, false, false)) {
                this.saveChanges();
            }
        }
    }

    @Override
    public String getPassportTypeName() {
        return "Anonymous";
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public String getSigFunction() {
        return "";
    }

    @Override
    public String getProfileMethod() {
        return "";
    }

    @Override
    public boolean needUserKeys() {
        return false;
    }

    @Override
    public HBCIKey getInstEncKey() {
        return null;
    }

    @Override
    public String getMyEncKeyVersion() {
        return "";
    }

    @Override
    public String getMySigKeyNum() {
        return "";
    }

    @Override
    public String getCryptMode() {
        return "";
    }

    @Override
    public boolean needInstKeys() {
        return false;
    }

    @Override
    public String getSigAlg() {
        return "";
    }

    @Override
    public String getSigMode() {
        return "";
    }

    @Override
    public byte[][] encrypt(byte[] parm1) {
        return new byte[][]{null, parm1};
    }

    @Override
    public String getInstSigKeyVersion() {
        return "";
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
    }

    @Override
    public String getCryptKeyType() {
        return "";
    }

    @Override
    public String getMySigKeyName() {
        return "";
    }

    @Override
    public String getMySigKeyVersion() {
        return "";
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return null;
    }

    @Override
    public boolean needUserSig() {
        return false;
    }

    @Override
    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
    }

    @Override
    public Comm getCommInstance() {
        return Comm.getInstance("Standard", this);
    }

    @Override
    public String getProfileVersion() {
        return "";
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
    }

    @Override
    public HBCIKey getMyPrivateSigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPublicSigKey() {
        return null;
    }

    @Override
    public String getCryptAlg() {
        return "";
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
    }

    @Override
    public String getMyEncKeyNum() {
        return "";
    }

    @Override
    public boolean hasMyEncKey() {
        return false;
    }

    @Override
    public byte[] hash(byte[] data) {
        return data;
    }

    @Override
    public byte[] sign(byte[] data) {
        return new byte[0];
    }

    @Override
    public HBCIKey getMyPrivateDigKey() {
        return null;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean hasMySigKey() {
        return false;
    }

    @Override
    public void resetPassphrase() {
    }

    @Override
    public String getMyEncKeyName() {
        return "";
    }

    @Override
    public String getCryptFunction() {
        return "";
    }

    @Override
    public String getInstSigKeyName() {
        return "";
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return null;
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
    }

    @Override
    public String getInstEncKeyVersion() {
        return "";
    }

    @Override
    public String getHashAlg() {
        return "";
    }

    @Override
    public byte[] decrypt(byte[] parm1, byte[] parm2) {
        return parm2;
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
    }

    @Override
    public boolean hasInstEncKey() {
        return false;
    }

    @Override
    public String getInstSigKeyNum() {
        return "";
    }

    @Override
    public HBCIKey getInstSigKey() {
        return null;
    }

    @Override
    public boolean verify(byte[] parm1, byte[] parm2) {
        return true;
    }

    @Override
    public String getInstEncKeyName() {
        return "";
    }

    @Override
    public String getInstEncKeyNum() {
        return "";
    }

    @Override
    public boolean hasInstSigKey() {
        return false;
    }

    @Override
    public String getSysStatus() {
        return "0";
    }

    private void setFileName(String filename) {
        this.filename = filename;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public void saveChanges() {
        try {
            PassportData data = new PassportData();
            data.country = this.getCountry();
            data.blz = this.getBLZ();
            data.host = this.getHost();
            data.port = this.getPort();
            data.hbciVersion = this.getHBCIVersion();
            data.bpd = this.getBPD();
            data.upd = this.getUPD();
            PassportStorage.save((HBCIPassport)this, data, new File(this.getFileName()));
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_WRITEERR"), e);
        }
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }
}

