/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractDDVPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;
import org.kapott.hbci.tools.CryptUtils;
import org.kapott.hbci.tools.IOUtils;

public class HBCIPassportDDV
extends AbstractDDVPassport {
    private String paramHeader;
    private String filename;
    private HBCIKey[] keys;
    private int comport;
    private int ctnumber;
    private String cardid;
    private boolean pinEntered;
    private int useBio;
    private int useSoftPin;
    private byte[] softPin;
    private int entryIdx;

    protected native void initCT();

    protected native void ctReadBankData();

    protected native void ctReadKeyData();

    protected native void ctEnterPIN();

    protected native void ctSaveBankData();

    protected native void ctSaveSigId();

    protected native byte[] ctSign(byte[] var1);

    protected native byte[][] ctEncrypt();

    protected native byte[] ctDecrypt(byte[] var1);

    protected native void closeCT();

    public HBCIPassportDDV(Object init, int dummy) {
        super(init);
        this.setParamHeader("client.passport.DDV");
        this.keys = new HBCIKey[2];
        for (int i = 0; i < 2; ++i) {
            this.keys[i] = null;
        }
    }

    public HBCIPassportDDV(Object init) {
        this(init, 0);
        int comport = Integer.parseInt(HBCIUtils.getParam(this.paramHeader + ".port", "0"));
        int ctnumber = Integer.parseInt(HBCIUtils.getParam(this.paramHeader + ".ctnumber", "0"));
        String ddvLib = HBCIUtils.getParam(this.paramHeader + ".libname.ddv");
        if (ddvLib == null) {
            throw new NullPointerException(this.paramHeader + ".libname.ddv must not be null");
        }
        this.setComPort(comport);
        this.setCTNumber(ctnumber);
        this.setUseBio(Integer.parseInt(HBCIUtils.getParam(this.paramHeader + ".usebio", "-1")));
        this.setUseSoftPin(Integer.parseInt(HBCIUtils.getParam(this.paramHeader + ".softpin", "-1")));
        this.setSoftPin(new byte[0]);
        this.setPINEntered(false);
        this.setEntryIdx(Integer.parseInt(HBCIUtils.getParam(this.paramHeader + ".entryidx", "1")));
        this.setPort(new Integer(3000));
        this.setFilterType("None");
        HBCIUtils.log("trying to load native DDV library " + ddvLib, 4);
        System.load(ddvLib);
        HBCIUtils.log("using chipcard terminal with port " + comport + " and terminal number " + ctnumber, 4);
        try {
            HBCIUtilsInternal.getCallback().callback(this, 2, HBCIUtilsInternal.getLocMsg("CALLB_NEED_CHIPCARD"), 0, null);
            this.initCT();
            HBCIUtilsInternal.getCallback().callback(this, 6, "", 0, null);
            this.ctReadBankData();
            if (this.askForMissingData(true, true, true, false, false, true, false)) {
                this.saveBankData();
            }
            this.ctReadKeyData();
            this.setFileName(HBCIUtilsInternal.withCounter(HBCIUtils.getParam(this.paramHeader + ".path", "./") + this.getCardId(), this.getEntryIdx() - 1));
            File file = new File(this.getFileName());
            if (file.exists() && file.isFile() && file.canRead()) {
                PassportData data = PassportStorage.load((HBCIPassport)this, new File(this.getFileName()));
                this.setBPD(data.bpd);
                this.setUPD(data.upd);
                this.setHBCIVersion(data.hbciVersion);
            }
        }
        catch (Exception e) {
            try {
                this.closeCT();
            }
            catch (Exception e2) {
                HBCIUtils.log(e2);
            }
            if (e instanceof HBCI_Exception) {
                throw (HBCI_Exception)e;
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CTERR"), e);
        }
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public void setFileName(String filename) {
        this.filename = IOUtils.safeFilename(filename);
    }

    public void setComPort(int comport) {
        this.comport = comport;
    }

    public void setCTNumber(int ctnumber) {
        this.ctnumber = ctnumber;
    }

    public int getComPort() {
        return this.comport;
    }

    public int getCTNumber() {
        return this.ctnumber;
    }

    public int getUseBio() {
        return this.useBio;
    }

    public void setUseBio(int useBio) {
        this.useBio = useBio;
    }

    public int getUseSoftPin() {
        return this.useSoftPin;
    }

    public void setUseSoftPin(int useSoftPin) {
        this.useSoftPin = useSoftPin;
    }

    public byte[] getSoftPin() {
        return this.softPin;
    }

    public void setSoftPin(byte[] softPin) {
        LogFilter.getInstance().addSecretData(new String(softPin), "X", 1);
        this.softPin = softPin;
    }

    public void setEntryIdx(int idx) {
        this.entryIdx = idx;
    }

    public int getEntryIdx() {
        return this.entryIdx;
    }

    public void setCardId(String cardid) {
        this.cardid = cardid;
    }

    public String getCardId() {
        return this.cardid;
    }

    @Override
    public boolean isSupported() {
        boolean ret = false;
        if (this.getBPD() != null) {
            String[][] methods = this.getSuppSecMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i][0].equals("DDV")) continue;
                ret = true;
                break;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private HBCIKey getKey(int i) {
        return this.keys[i];
    }

    @Override
    public HBCIKey getInstSigKey() {
        return this.getKey(0);
    }

    @Override
    public String getInstSigKeyName() {
        return this.getInstSigKey() != null ? this.getInstSigKey().userid : null;
    }

    @Override
    public String getInstSigKeyNum() {
        return this.getInstSigKey() != null ? this.getInstSigKey().num : null;
    }

    @Override
    public String getInstSigKeyVersion() {
        return this.getInstSigKey() != null ? this.getInstSigKey().version : null;
    }

    @Override
    public HBCIKey getInstEncKey() {
        return this.getKey(1);
    }

    @Override
    public String getInstEncKeyName() {
        return this.getInstEncKey() != null ? this.getInstEncKey().userid : null;
    }

    @Override
    public String getInstEncKeyNum() {
        return this.getInstEncKey() != null ? this.getInstEncKey().num : null;
    }

    @Override
    public String getInstEncKeyVersion() {
        return this.getInstEncKey() != null ? this.getInstEncKey().version : null;
    }

    @Override
    public HBCIKey getMyPublicSigKey() {
        return this.getInstSigKey();
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return this.getInstEncKey();
    }

    @Override
    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateSigKey() {
        return this.getMyPublicSigKey();
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return this.getMyPublicEncKey();
    }

    @Override
    public HBCIKey getMyPrivateDigKey() {
        return this.getMyPublicDigKey();
    }

    @Override
    public String getMySigKeyName() {
        return this.getInstSigKeyName();
    }

    @Override
    public String getMySigKeyNum() {
        return this.getInstSigKeyNum();
    }

    @Override
    public String getMySigKeyVersion() {
        return this.getInstSigKeyVersion();
    }

    @Override
    public String getMyEncKeyName() {
        return this.getInstEncKeyName();
    }

    @Override
    public String getMyEncKeyNum() {
        return this.getInstEncKeyNum();
    }

    @Override
    public String getMyEncKeyVersion() {
        return this.getInstEncKeyVersion();
    }

    private void setKey(int i, HBCIKey key) {
        this.keys[i] = key;
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
        this.setKey(0, key);
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
        this.setKey(1, key);
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
    }

    private void checkPIN() {
        block12: {
            try {
                if (this.pinEntered) break block12;
                if (this.useSoftPin == 1) {
                    String pin = HBCIUtils.getParam(this.paramHeader + ".pin");
                    if (pin == null || pin.length() == 0) {
                        StringBuffer temppin = new StringBuffer();
                        HBCIUtilsInternal.getCallback().callback(this, 4, HBCIUtilsInternal.getLocMsg("CALLB_NEED_SOFTPIN"), 1, temppin);
                        if (temppin.length() == 0) {
                            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PINZERO"));
                        }
                        pin = temppin.toString();
                        LogFilter.getInstance().addSecretData(pin, "X", 1);
                    }
                    this.setSoftPin(pin.getBytes("ISO-8859-1"));
                } else {
                    HBCIUtilsInternal.getCallback().callback(this, 3, HBCIUtilsInternal.getLocMsg("CALLB_NEED_HARDPIN"), 0, null);
                }
                try {
                    this.ctEnterPIN();
                    this.pinEntered = true;
                }
                catch (Exception e) {
                    HBCIUtils.setParam(this.paramHeader + ".pin", null);
                    this.setSoftPin(new byte[0]);
                }
                finally {
                    if (this.useSoftPin != 1) {
                        HBCIUtilsInternal.getCallback().callback(this, 5, null, 0, null);
                    }
                }
            }
            catch (Exception e) {
                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PINERR"), e);
            }
        }
    }

    @Override
    public void saveBankData() {
        try {
            this.checkPIN();
            this.ctSaveBankData();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_INSTSAVEERR"), e);
        }
    }

    @Override
    public void resetPassphrase() {
    }

    @Override
    public void saveChanges() {
        try {
            this.checkPIN();
            this.ctSaveSigId();
            PassportData data = new PassportData();
            data.bpd = this.getBPD();
            data.upd = this.getUPD();
            data.hbciVersion = this.getHBCIVersion();
            PassportStorage.save((HBCIPassport)this, data, new File(this.getFileName()));
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_WRITEERR"), e);
        }
    }

    @Override
    public byte[] hash(byte[] data) {
        MessageDigest dig;
        try {
            dig = MessageDigest.getInstance("RIPEMD160", "CryptAlgs4Java");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        return dig.digest(data);
    }

    @Override
    public byte[] sign(byte[] data) {
        this.checkPIN();
        return this.ctSign(data);
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        this.checkPIN();
        byte[] correctSig = this.ctSign(data);
        return Arrays.equals(sig, correctSig);
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            this.checkPIN();
            byte[][] msgkeys = this.ctEncrypt();
            byte[] longKey = new byte[24];
            int posi = msgkeys[0].length - 16;
            System.arraycopy(msgkeys[0], posi, longKey, 0, 16);
            System.arraycopy(msgkeys[0], posi, longKey, 16, 8);
            DESedeKeySpec spec = new DESedeKeySpec(longKey);
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory fac = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            SecretKey key = fac.generateSecret(spec);
            Cipher cipher = provider == null ? Cipher.getInstance("DESede/CBC/NoPadding") : Cipher.getInstance("DESede/CBC/NoPadding", provider);
            byte[] ivarray = new byte[8];
            Arrays.fill(ivarray, (byte)0);
            IvParameterSpec iv = new IvParameterSpec(ivarray);
            cipher.init(1, (Key)key, iv);
            byte[] cryptedMsg = cipher.doFinal(plainMsg);
            byte[][] ret = new byte[][]{msgkeys[1], cryptedMsg};
            return ret;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CANTCRYPT"), ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] cryptedMsg) {
        try {
            this.checkPIN();
            byte[] plainKey = this.ctDecrypt(cryptedKey);
            byte[] longKey = new byte[24];
            int posi = plainKey.length - 16;
            System.arraycopy(plainKey, posi, longKey, 0, 16);
            System.arraycopy(plainKey, posi, longKey, 16, 8);
            DESedeKeySpec spec = new DESedeKeySpec(longKey);
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory fac = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            SecretKey key = fac.generateSecret(spec);
            Cipher cipher = provider == null ? Cipher.getInstance("DESede/CBC/NoPadding") : Cipher.getInstance("DESede/CBC/NoPadding", provider);
            byte[] ivarray = new byte[8];
            Arrays.fill(ivarray, (byte)0);
            IvParameterSpec iv = new IvParameterSpec(ivarray);
            cipher.init(2, (Key)key, iv);
            return cipher.doFinal(cryptedMsg);
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_DECRYPTERR"), ex);
        }
    }

    public void setPINEntered(boolean pinEntered) {
        this.pinEntered = pinEntered;
    }

    @Override
    public void close() {
        super.close();
        this.setPINEntered(false);
        this.closeCT();
    }

    public String getLibName() {
        return HBCIUtils.getParam(this.paramHeader + ".libname.ctapi");
    }

    @Override
    protected void setParamHeader(String p) {
        this.paramHeader = p;
    }

    @Override
    protected String getParamHeader() {
        return this.paramHeader;
    }
}

