/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import org.kapott.hbci.datatypes.SyntaxCtr;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportDDV;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;
import org.kapott.hbci.smartcardio.DDVBankData;
import org.kapott.hbci.smartcardio.DDVCardService;
import org.kapott.hbci.smartcardio.DDVKeyData;
import org.kapott.hbci.smartcardio.SmartCardService;

public class HBCIPassportDDVPCSC
extends HBCIPassportDDV {
    private DDVCardService cardService;

    public HBCIPassportDDVPCSC(Object init, int dummy) {
        super(init, dummy);
    }

    public HBCIPassportDDVPCSC(Object init) {
        this(init, 0);
        this.setUseBio(Integer.parseInt(HBCIUtils.getParam(this.getParamHeader() + ".usebio", "-1")));
        this.setUseSoftPin(Integer.parseInt(HBCIUtils.getParam(this.getParamHeader() + ".softpin", "-1")));
        this.setSoftPin(new byte[0]);
        this.setPINEntered(false);
        this.setEntryIdx(Integer.parseInt(HBCIUtils.getParam(this.getParamHeader() + ".entryidx", "1")));
        this.setPort(new Integer(3000));
        this.setFilterType("None");
        try {
            HBCIUtilsInternal.getCallback().callback(this, 2, HBCIUtilsInternal.getLocMsg("CALLB_NEED_CHIPCARD"), 0, null);
            HBCIUtils.log("initializing javax.smartcardio", 4);
            this.initCT();
            HBCIUtilsInternal.getCallback().callback(this, 6, "", 0, null);
            this.ctReadBankData();
            if (this.askForMissingData(true, true, true, false, false, true, false)) {
                this.saveBankData();
            }
            this.ctReadKeyData();
            String path = HBCIUtils.getParam(this.getParamHeader() + ".path", "./");
            this.setFileName(HBCIUtilsInternal.withCounter(path + "pcsc" + this.getCardId(), this.getEntryIdx() - 1));
            File file = new File(this.getFileName());
            if (file.exists() && file.isFile() && file.canRead()) {
                PassportData data = PassportStorage.load((HBCIPassport)this, new File(this.getFileName()));
                this.setBPD(data.bpd);
                this.setUPD(data.upd);
                this.setHBCIVersion(data.hbciVersion);
            }
        }
        catch (Exception e) {
            try {
                this.closeCT();
            }
            catch (Exception e2) {
                HBCIUtils.log(e2);
            }
            if (e instanceof HBCI_Exception) {
                throw (HBCI_Exception)e;
            }
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_CTERR"), e);
        }
    }

    @Override
    protected void initCT() {
        this.cardService = (DDVCardService)SmartCardService.createInstance(DDVCardService.class, HBCIUtils.getParam(this.getParamHeader() + ".pcsc.name", null));
        this.setCID(this.cardService.getCID());
        this.setCardId(this.cardService.getCardId());
    }

    @Override
    protected void ctReadBankData() {
        int idx = this.getEntryIdx() - 1;
        DDVBankData bankData = this.cardService.readBankData(idx);
        this.setBLZ(bankData.blz);
        this.setCountry(SyntaxCtr.getName(bankData.country));
        this.setHost(bankData.commaddr);
        this.setUserId(bankData.userid);
    }

    @Override
    protected void ctReadKeyData() {
        this.setSigId(new Long(this.cardService.readSigId()));
        DDVKeyData[] keyData = this.cardService.readKeyData();
        this.setInstSigKey(new HBCIKey(this.getCountry(), this.getBLZ(), this.getUserId(), Integer.toString(keyData[0].num), Integer.toString(keyData[0].version), null));
        this.setInstEncKey(new HBCIKey(this.getCountry(), this.getBLZ(), this.getUserId(), Integer.toString(keyData[1].num), Integer.toString(keyData[1].version), null));
    }

    @Override
    protected void ctEnterPIN() {
        if (this.getUseSoftPin() == 1) {
            this.cardService.verifySoftPIN(1, this.getSoftPin());
        } else {
            this.cardService.verifyHardPIN(1);
        }
    }

    @Override
    protected void ctSaveBankData() {
        int idx = this.getEntryIdx() - 1;
        DDVBankData bankData = this.cardService.readBankData(idx);
        bankData.country = SyntaxCtr.getCode(this.getCountry());
        bankData.blz = this.getBLZ();
        bankData.commaddr = this.getHost();
        bankData.userid = this.getUserId();
        this.cardService.writeBankData(idx, bankData);
    }

    @Override
    protected void ctSaveSigId() {
        this.cardService.writeSigId(this.getSigId().intValue());
    }

    @Override
    protected byte[] ctSign(byte[] data) {
        return this.cardService.sign(data);
    }

    @Override
    protected byte[][] ctEncrypt() {
        return this.cardService.getEncryptionKeys(Integer.parseInt(this.getInstEncKeyNum()));
    }

    @Override
    protected byte[] ctDecrypt(byte[] cryptedKey) {
        return this.cardService.decrypt(Integer.parseInt(this.getInstEncKeyNum()), cryptedKey);
    }

    @Override
    protected void closeCT() {
        try {
            if (this.cardService != null) {
                this.cardService.close();
            }
        }
        finally {
            this.cardService = null;
        }
    }
}

