/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.FlickerCode;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.manager.MatrixCode;
import org.kapott.hbci.manager.QRCode;
import org.kapott.hbci.manager.TanMethod;
import org.kapott.hbci.passport.AbstractPinTanPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;

public class HBCIPassportPinTan
extends AbstractPinTanPassport {
    private String filename;

    public HBCIPassportPinTan(Object init, int dummy) {
        super(init);
    }

    public HBCIPassportPinTan(Object initObject) {
        this(initObject, 0);
        String header = "client.passport.PinTan.";
        String filename = HBCIUtils.getParam(header + "filename");
        if (initObject instanceof File) {
            filename = ((File)initObject).getAbsolutePath();
        }
        this.setFileName(filename);
        this.setCertFile(HBCIUtils.getParam(header + "certfile"));
        this.setCheckCert(HBCIUtils.getParam(header + "checkcert", "1").equals("1"));
        this.setProxy(HBCIUtils.getParam(header + "proxy", ""));
        this.setProxyUser(HBCIUtils.getParam(header + "proxyuser", ""));
        this.setProxyPass(HBCIUtils.getParam(header + "proxypass", ""));
        boolean init = HBCIUtils.getParam(header + "init", "1").equals("1");
        if (init) {
            this.read();
            if (this.askForMissingData(true, true, true, true, true, true, true)) {
                this.saveChanges();
            }
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public void resetPassphrase() {
    }

    protected void create() {
        String fname = this.getFileName();
        if (fname == null) {
            throw new NullPointerException("client.passport.PinTan.filename must not be null");
        }
        File file = new File(fname);
        if (file.exists() && file.isFile() && file.canRead()) {
            return;
        }
        HBCIUtils.log("have to create new passport file", 2);
        this.askForMissingData(true, true, true, true, true, true, true);
        this.saveChanges();
    }

    protected void read() {
        this.create();
        String fname = this.getFileName();
        if (fname == null) {
            throw new NullPointerException("client.passport.PinTan.filename must not be null");
        }
        PassportData data = PassportStorage.load((HBCIPassport)this, new File(fname));
        this.setCountry(data.country);
        this.setBLZ(data.blz);
        this.setHost(data.host);
        this.setPort(data.port);
        this.setUserId(data.userId);
        this.setSysId(data.sysId);
        this.setBPD(data.bpd);
        this.setUPD(data.upd);
        this.setHBCIVersion(data.hbciVersion);
        this.setCustomerId(data.customerId);
        this.setFilterType(data.filter);
        this.setAllowedTwostepMechanisms(data.twostepMechs);
        this.setCurrentTANMethod(data.tanMethod);
    }

    @Override
    public void saveChanges() {
        try {
            PassportData data = new PassportData();
            data.country = this.getCountry();
            data.blz = this.getBLZ();
            data.host = this.getHost();
            data.port = this.getPort();
            data.userId = this.getUserId();
            data.sysId = this.getSysId();
            data.bpd = this.getBPD();
            data.upd = this.getUPD();
            data.hbciVersion = this.getHBCIVersion();
            data.customerId = this.getCustomerId();
            data.filter = this.getFilterType();
            List<String> l = this.getAllowedTwostepMechanisms();
            HBCIUtils.log("saving two step mechs: " + l, 4);
            data.twostepMechs = l;
            try {
                String s = this.getCurrentTANMethod(false);
                HBCIUtils.log("saving current tan method: " + s, 4);
                data.tanMethod = s;
            }
            catch (Exception e) {
                HBCIUtils.log("could not determine current tan methode, skipping: " + e.getMessage(), 4);
                HBCIUtils.log(e, 5);
            }
            PassportStorage.save((HBCIPassport)this, data, new File(this.getFileName()));
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_WRITEERR"), e);
        }
    }

    @Override
    public byte[] hash(byte[] data) {
        return data;
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            if (this.getPIN() == null) {
                StringBuffer s = new StringBuffer();
                HBCIUtilsInternal.getCallback().callback(this, 16, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PTPIN"), 1, s);
                if (s.length() == 0) {
                    throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PINZERO"));
                }
                this.setPIN(s.toString());
                LogFilter.getInstance().addSecretData(this.getPIN(), "X", 1);
            }
            String tan = "";
            String pintanMethod = this.getCurrentTANMethod(false);
            if (pintanMethod.equals(TanMethod.ONESTEP.getId())) {
                HBCIUtils.log("onestep method - checking GVs to decide whether or not we need a TAN", 4);
                String codes = this.collectSegCodes(new String(data, "ISO-8859-1"));
                StringTokenizer tok = new StringTokenizer(codes, "|");
                while (tok.hasMoreTokens()) {
                    String code = tok.nextToken();
                    String info = this.getPinTanInfo(code);
                    if (info.equals("J")) {
                        HBCIUtils.log("the job with the code " + code + " needs a TAN", 4);
                        if (tan.length() == 0) {
                            StringBuffer s = new StringBuffer();
                            try {
                                HBCIUtilsInternal.getCallback().callback(this, 17, HBCIUtilsInternal.getLocMsg("CALLB_NEED_PTTAN"), 2, s);
                            }
                            catch (HBCI_Exception e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new HBCI_Exception(e);
                            }
                            if (s.length() == 0) {
                                throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_TANZERO"));
                            }
                            tan = s.toString();
                            continue;
                        }
                        HBCIUtils.log("there should be only one job that needs a TAN!", 2);
                        continue;
                    }
                    if (info.equals("N")) {
                        HBCIUtils.log("the job with the code " + code + " does not need a TAN", 4);
                        continue;
                    }
                    if (info.length() != 0) continue;
                    HBCIUtils.log("the job with the code " + code + " seems not to be allowed with PIN/TAN", 2);
                }
            } else {
                HBCIUtils.log("twostep method - checking passport(challenge) to decide whether or not we need a TAN", 4);
                Properties secmechInfo = this.getCurrentSecMechInfo();
                String haveSCA = (String)this.getPersistentData("__pintan_sca___");
                this.setPersistentData("__pintan_sca___", null);
                String challenge = (String)this.getPersistentData("__pintan_challenge___");
                this.setPersistentData("__pintan_challenge___", null);
                if (haveSCA != null) {
                    HBCIUtils.log("will not sign with a TAN, found status code 3076, no SCA required", 4);
                } else if (challenge == null) {
                    HBCIUtils.log("will not sign with a TAN, because there is no challenge", 4);
                } else {
                    HBCIUtils.log("found challenge in passport, so we ask for a TAN", 4);
                    String hhduc = (String)this.getPersistentData("__pintan_hhduc___");
                    this.setPersistentData("__pintan_hhduc___", null);
                    HHDVersion hhd = HHDVersion.find(secmechInfo);
                    HBCIUtils.log("detected HHD version: " + (Object)((Object)hhd), 4);
                    StringBuffer payload = new StringBuffer();
                    String msg = secmechInfo.getProperty("name") + "\n" + secmechInfo.getProperty("inputinfo") + "\n\n" + challenge;
                    int callback = 17;
                    if (hhd.getType() == HHDVersion.Type.PHOTOTAN && MatrixCode.tryParse(hhduc) != null) {
                        payload.append(hhduc);
                        callback = 33;
                    } else if (hhd.getType() == HHDVersion.Type.QRCODE && QRCode.tryParse(hhduc, msg) != null) {
                        payload.append(hhduc);
                        callback = 34;
                    } else if (hhd.getType() == HHDVersion.Type.DECOUPLED) {
                        callback = 35;
                    } else {
                        FlickerCode flicker = FlickerCode.tryParse(hhd, challenge, hhduc);
                        if (flicker != null) {
                            payload.append(flicker.render());
                        }
                    }
                    HBCIUtilsInternal.getCallback().callback(this, callback, msg, 2, payload);
                    this.setPersistentData("externalid", null);
                    if (callback == 35) {
                        return (this.getPIN() + "|").getBytes("ISO-8859-1");
                    }
                    if (payload == null || payload.length() == 0) {
                        throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_TANZERO"));
                    }
                    tan = payload.toString();
                }
            }
            if (tan.length() != 0) {
                LogFilter.getInstance().addSecretData(tan, "X", 1);
            }
            return (this.getPIN() + "|" + tan).getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing failed", ex);
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        return true;
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            byte padLength = plainMsg[plainMsg.length - 1];
            byte[] encrypted = new String(plainMsg, 0, plainMsg.length - padLength, "ISO-8859-1").getBytes("ISO-8859-1");
            return new byte[][]{new byte[8], encrypted};
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** encrypting message failed", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] cryptedMsg) {
        try {
            return new String(new String(cryptedMsg, "ISO-8859-1") + '\u0001').getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** decrypting of message failed", ex);
        }
    }

    @Override
    public void close() {
        super.close();
    }
}

