/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.File;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.passport.AbstractRDHSWFileBasedPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.PassportStorage;

public class HBCIPassportRDHNew
extends AbstractRDHSWFileBasedPassport {
    private String profileVersion;

    public HBCIPassportRDHNew(Object init, int dummy) {
        super(init);
    }

    public HBCIPassportRDHNew(Object initObject) {
        this(initObject, 0);
        this.setParamHeader("client.passport.RDHNew");
        String filename = HBCIUtils.getParam(this.getParamHeader() + ".filename");
        boolean init = HBCIUtils.getParam(this.getParamHeader() + ".init", "1").equals("1");
        if (filename == null) {
            throw new NullPointerException(this.getParamHeader() + ".filename must not be null");
        }
        HBCIUtils.log("loading passport data from file " + filename, 4);
        this.setFilename(filename);
        if (init) {
            HBCIUtils.log("loading data from file " + filename, 4);
            this.setFilterType("None");
            this.setPort(new Integer(3000));
            if (!new File(filename).canRead()) {
                HBCIUtils.log("have to create new passport file", 2);
                this.askForMissingData(true, true, true, true, false, true, true);
                this.saveChanges();
            }
            PassportData data = PassportStorage.load((HBCIPassport)this, new File(filename));
            this.setBLZ(data.blz);
            this.setCountry(data.country);
            this.setHost(data.host);
            this.setPort(data.port);
            this.setUserId(data.userId);
            this.setCustomerId(data.customerId);
            this.setSysId(data.sysId);
            this.setSigId(data.sigId);
            this.setProfileVersion(data.profileVersion != null ? data.profileVersion : "");
            this.setHBCIVersion(data.hbciVersion);
            this.setBPD(data.bpd);
            this.setUPD(data.upd);
            this.setInstSigKey(data.instSigKey);
            this.setInstEncKey(data.instEncKey);
            this.setMyPublicSigKey(data.myPublicSigKey);
            this.setMyPrivateSigKey(data.myPrivateSigKey);
            this.setMyPublicEncKey(data.myPublicEncKey);
            this.setMyPrivateEncKey(data.myPrivateEncKey);
            if (this.askForMissingData(true, true, true, true, false, true, true)) {
                this.saveChanges();
            }
        }
    }

    @Override
    public void saveChanges() {
        try {
            PassportData data = new PassportData();
            data.country = this.getCountry();
            data.blz = this.getBLZ();
            data.host = this.getHost();
            data.port = this.getPort();
            data.userId = this.getUserId();
            data.customerId = this.getCustomerId();
            data.sysId = this.getSysId();
            data.sigId = this.getSigId();
            data.profileVersion = this.getProfileVersion();
            data.hbciVersion = this.getHBCIVersion();
            data.bpd = this.getBPD();
            data.upd = this.getUPD();
            data.instSigKey = this.getInstSigKey();
            data.instEncKey = this.getInstEncKey();
            data.myPublicSigKey = this.getMyPublicSigKey();
            data.myPrivateSigKey = this.getMyPrivateSigKey();
            data.myPublicEncKey = this.getMyPublicEncKey();
            data.myPrivateEncKey = this.getMyPrivateEncKey();
            PassportStorage.save((HBCIPassport)this, data, new File(this.getFilename()));
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_WRITEERR"), e);
        }
    }

    @Override
    public void setProfileVersion(String version) {
        this.profileVersion = version;
    }

    @Override
    public String getProfileVersion() {
        String ret = this.profileVersion;
        if (ret == null) {
            ret = "";
        }
        if (ret.length() == 0) {
            HBCIUtils.log("have to determine my rdh-profile-version, but have no information about it yet", 4);
            if (this.hasMySigKey()) {
                HBCIUtils.log("found user sig key in passport file, but no profile version, so I guess it is an old RDHnew file, which always stored RDH-1 keys", 4);
                ret = "1";
            } else {
                HBCIUtils.log("no user keys found in passport - so we use the highest available profile", 4);
                String[][] methods = this.getSuppSecMethods();
                int maxVersion = 0;
                for (int i = 0; i < methods.length; ++i) {
                    String method = methods[i][0];
                    int version = Integer.parseInt(methods[i][1]);
                    if (!method.equals("RDH") || version != 1 && version != 2 && version != 10 || version <= maxVersion) continue;
                    maxVersion = version;
                }
                if (maxVersion != 0) {
                    ret = Integer.toString(maxVersion);
                }
                HBCIUtils.log("using RDH profile " + ret + " taken from supported profiles (BPD)", 4);
            }
        }
        if (ret == null || ret.length() == 0) {
            ret = HBCIUtils.getParam(this.getParamHeader() + ".defaultprofile", null);
            HBCIUtils.log("unable to determine rdh-profile-version using BPD, using default version " + ret, 2);
        }
        this.setProfileVersion(ret);
        return ret;
    }

    @Override
    public void resetPassphrase() {
    }
}

