/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.rdhXfile;

public class TLV {
    private int tag;
    private int len;
    private byte[] data;
    private byte[] rawdata;

    public TLV(byte[] buffer, int offset) {
        this.tag = buffer[offset + 1] << 8 | buffer[offset + 0] & 0xFF;
        this.len = buffer[offset + 3] << 8 | buffer[offset + 2] & 0xFF;
        this.data = new byte[this.len];
        System.arraycopy(buffer, offset + 4, this.data, 0, this.len);
        this.rawdata = new byte[4 + this.len];
        System.arraycopy(buffer, offset, this.rawdata, 0, 4 + this.len);
    }

    protected TLV(TLV tlv) {
        this.tag = (int)(tlv.getTag() & 0xFFFFL);
        this.len = tlv.getLength();
        this.data = tlv.getData();
        this.rawdata = tlv.getRawData();
    }

    public TLV(int tag) {
        this.tag = tag;
    }

    public long getTag() {
        return (long)this.tag & 0xFFFFL;
    }

    public int getLength() {
        return this.len;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.len = data.length;
        this.rawdata = new byte[4 + this.len];
        this.rawdata[0] = (byte)(this.tag >> 0 & 0xFF);
        this.rawdata[1] = (byte)(this.tag >> 8 & 0xFF);
        this.rawdata[2] = (byte)(this.len >> 0 & 0xFF);
        this.rawdata[3] = (byte)(this.len >> 8 & 0xFF);
        System.arraycopy(this.data, 0, this.rawdata, 4, this.len);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void updateData() {
    }

    protected String expand(String st, int size) {
        StringBuffer ret = st != null ? new StringBuffer(st) : new StringBuffer();
        for (int i = ret.length(); i < size; ++i) {
            ret.append(' ');
        }
        return ret.toString();
    }

    protected byte[] int2ba(int x) {
        return new byte[]{(byte)(x & 0xFF), (byte)(x >> 8 & 0xFF)};
    }

    protected byte[] long2ba(long x) {
        return new byte[]{(byte)(x & 0xFFL), (byte)(x >> 8 & 0xFFL), (byte)(x >> 16 & 0xFFL), (byte)(x >> 24 & 0xFFL)};
    }

    protected byte[] reverseba(byte[] ba) {
        int l = ba.length;
        byte[] ret = new byte[l];
        for (int i = 0; i < l; ++i) {
            ret[i] = ba[l - i - 1];
        }
        return ret;
    }

    protected byte[] trimba(byte[] ba) {
        int posi;
        int l = ba.length;
        for (posi = 0; posi < ba.length && ba[posi] == 0; ++posi) {
        }
        byte[] newba = new byte[l - posi];
        System.arraycopy(ba, posi, newba, 0, l - posi);
        return newba;
    }
}

