/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.format.PassportFormat;
import org.kapott.hbci.tools.IOUtils;

public class PassportStorage {
    private static final List<String> ORDER_DEFAULT = Arrays.asList("AESFormat", "LegacyFormat");
    private static Map<String, PassportFormat> formats = null;

    public static PassportData load(HBCIPassport passport, File file) {
        PassportData passportData;
        if (file == null) {
            throw new HBCI_Exception("no passport file given");
        }
        if (!file.canRead() || !file.isFile()) {
            throw new HBCI_Exception("passport file " + file + " not readable or no file");
        }
        HBCIUtils.log("loading passport data from " + file, 4);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            passportData = PassportStorage.load(passport, is);
        }
        catch (IOException e) {
            try {
                throw new HBCI_Exception("unable to read passport file " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
        }
        IOUtils.close(is);
        return passportData;
    }

    public static PassportData load(HBCIPassport passport, InputStream is) {
        if (passport == null) {
            throw new HBCI_Exception("no passport given");
        }
        if (is == null) {
            throw new HBCI_Exception("no inputstream given");
        }
        try {
            byte[] data = IOUtils.read(is);
            if (data != null && data.length == 0) {
                return new PassportData();
            }
            for (PassportFormat format : PassportStorage.getLoadFormats()) {
                try {
                    PassportData result = format.load(passport, data);
                    HBCIUtils.log("passport data loaded using " + format.getClass().getSimpleName(), 4);
                    return result;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new HBCI_Exception("unknown passport file format");
        }
        catch (IOException e) {
            throw new HBCI_Exception("unable to read passport file", e);
        }
    }

    public static void save(HBCIPassport passport, PassportData data, File file) {
        if (file == null) {
            throw new HBCI_Exception("no passport file given");
        }
        HBCIUtils.log("saving passport data to " + file, 4);
        BufferedOutputStream os = null;
        try {
            File directory = file.getAbsoluteFile().getParentFile();
            String prefix = file.getName() + "_";
            File tempfile = File.createTempFile(prefix, "", directory);
            os = new BufferedOutputStream(new FileOutputStream(tempfile));
            PassportStorage.save(passport, data, os);
            ((OutputStream)os).close();
            IOUtils.safeReplace(file, tempfile);
        }
        catch (IOException e) {
            try {
                throw new HBCI_Exception("unable to write passport file " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close(os);
    }

    public static void save(HBCIPassport passport, PassportData data, OutputStream os) {
        if (passport == null) {
            throw new HBCI_Exception("no passport given");
        }
        if (data == null) {
            throw new HBCI_Exception("no passport data given");
        }
        PassportFormat format = PassportStorage.getSaveFormat(passport);
        try {
            byte[] bytes = format.save(passport, data);
            os.write(bytes);
            os.flush();
            HBCIUtils.log("passport data saved using " + format.getClass().getSimpleName(), 4);
            return;
        }
        catch (IOException e) {
            throw new HBCI_Exception("unable to write passport file", e);
        }
    }

    private static void init() {
        if (formats != null) {
            return;
        }
        formats = new HashMap<String, PassportFormat>();
        HBCIUtils.log("searching supported passport formats", 4);
        ServiceLoader<PassportFormat> loader = ServiceLoader.load(PassportFormat.class);
        for (PassportFormat f : loader) {
            String name = f.getClass().getSimpleName();
            if (!f.supported()) {
                HBCIUtils.log("passport format " + name + " not supported on this plattform", 3);
                continue;
            }
            formats.put(name, f);
        }
        if (formats.size() == 0) {
            HBCIUtils.log("No supported passport formats found", 1);
        }
    }

    private static List<PassportFormat> getLoadFormats() {
        LinkedList<PassportFormat> result = new LinkedList<PassportFormat>();
        for (String name : PassportStorage.getFormatOrder()) {
            PassportFormat f = formats.get(name);
            if (f == null) {
                HBCIUtils.log("passport format unknown or not supported: " + name, 4);
                continue;
            }
            result.add(f);
        }
        return result;
    }

    private static PassportFormat getSaveFormat(HBCIPassport passport) {
        PassportFormat format;
        String type = passport.getClass().getSimpleName();
        String name = HBCIUtils.getParam("passport.format." + type, HBCIUtils.getParam("passport.format"));
        if (name != null && (format = formats.get(name)) != null) {
            return format;
        }
        for (String s : PassportStorage.getFormatOrder()) {
            PassportFormat format2 = formats.get(s);
            if (format2 == null) continue;
            return format2;
        }
        if (formats.size() == 0) {
            throw new HBCI_Exception("No supported passport formats found");
        }
        return formats.values().iterator().next();
    }

    private static List<String> getFormatOrder() {
        String value = HBCIUtils.getParam("passport.order");
        if (value == null || value.length() == 0) {
            return ORDER_DEFAULT;
        }
        if ((value = value.trim().replace(" ", "")).length() == 0) {
            return ORDER_DEFAULT;
        }
        if (!value.contains(",")) {
            return Arrays.asList(value);
        }
        return Arrays.asList(value.split(","));
    }

    static {
        PassportStorage.init();
    }
}

