/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.storage.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.format.AbstractFormat;
import org.kapott.hbci.tools.CryptUtils;
import org.kapott.hbci.tools.IOUtils;

public class AESFormat
extends AbstractFormat {
    private static final String FORMAT_NAME = "H4JAES";
    private static final int FORMAT_VERSION = 1;
    private static final String ENCODING = "UTF-8";
    private static final SecureRandom RAND = new SecureRandom();
    private static final String KEY_ALG_NAME = "PBKDF2WithHmacSHA256";
    private static final String KEY_ALG = "AES";
    private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    private static final int CIPHER_ITERATIONS = 65536;
    private static final int KEY_SIZE = 256;
    private static final int SALT_SIZE = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PassportData load(HBCIPassport passport, byte[] data) throws UnsupportedOperationException {
        byte ivLen;
        long started = System.currentTimeMillis();
        if (data == null) throw new UnsupportedOperationException("not enough data");
        if (data.length < 20) {
            throw new UnsupportedOperationException("not enough data");
        }
        int pos = 0;
        try {
            if (!FORMAT_NAME.equals(new String(Arrays.copyOfRange(data, pos, pos + FORMAT_NAME.length()), ENCODING))) {
                throw new UnsupportedOperationException("wrong format identifier, expected: H4JAES");
            }
            pos += FORMAT_NAME.length();
            if (1 != data[FORMAT_NAME.length()]) {
                throw new UnsupportedOperationException("wrong format version, expected: 1");
            }
        }
        catch (UnsupportedEncodingException e) {
            HBCIUtils.log(e);
            throw new UnsupportedOperationException();
        }
        byte saltLen = data[++pos];
        if (data.length < ++pos + saltLen) {
            throw new HBCI_Exception("passport file corrupted, not enough data");
        }
        byte[] salt = Arrays.copyOfRange(data, pos, pos + saltLen);
        pos += saltLen;
        if (data.length < ++pos + (ivLen = data[pos])) {
            throw new HBCI_Exception("passport file corrupted, not enough data");
        }
        byte[] iv = Arrays.copyOfRange(data, pos, pos + ivLen);
        pos += ivLen;
        int retries = this.getRetries();
        int i = 0;
        while (i < 10) {
            block18: {
                ObjectInputStream is = null;
                try {
                    Cipher cipher = this.getCipher();
                    SecretKey key = this.getPassportKey(passport, salt, false);
                    cipher.init(2, (Key)key, new IvParameterSpec(iv));
                    is = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(Arrays.copyOfRange(data, pos, data.length)), cipher));
                    PassportData result = (PassportData)is.readObject();
                    HBCIUtils.log("used time for decrypting " + data.length + " bytes: " + (System.currentTimeMillis() - started) + " millis", 4);
                    PassportData passportData = result;
                    IOUtils.close(is);
                    return passportData;
                }
                catch (UnsupportedOperationException uoe) {
                    throw uoe;
                    catch (HBCI_Exception e) {
                        if (retries-- <= 0) {
                            throw e;
                        }
                        break block18;
                    }
                    catch (Exception ex) {
                        if (retries-- <= 0) {
                            throw new HBCI_Exception("unable to load passport data", ex);
                        }
                    }
                }
                finally {
                    IOUtils.close(is);
                }
            }
            ++i;
        }
        throw new HBCI_Exception("unable to load passport data");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] save(HBCIPassport passport, PassportData data) throws UnsupportedOperationException {
        byte[] byArray;
        long started = System.currentTimeMillis();
        ObjectOutputStream os = null;
        try {
            Cipher cipher = this.getCipher();
            byte[] salt = new byte[8];
            RAND.nextBytes(salt);
            SecretKey key = this.getPassportKey(passport, salt, true);
            cipher.init(1, key);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(FORMAT_NAME.getBytes(ENCODING));
            bos.write(1);
            bos.write(salt.length);
            bos.write(salt);
            bos.write(iv.length);
            bos.write(iv);
            os = new ObjectOutputStream(new CipherOutputStream(bos, cipher));
            os.writeObject(data);
            os.close();
            byte[] result = bos.toByteArray();
            HBCIUtils.log("used time for encrypting passort into " + result.length + " bytes: " + (System.currentTimeMillis() - started) + " millis", 4);
            byArray = result;
        }
        catch (UnsupportedOperationException uoe) {
            try {
                throw uoe;
                catch (HBCI_Exception e) {
                    throw e;
                }
                catch (Exception ex) {
                    throw new HBCI_Exception("unable to load passport data", ex);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close(os);
        return byArray;
    }

    @Override
    protected String getCipherAlg() {
        return CIPHER_ALG;
    }

    @Override
    public boolean supported() {
        try {
            Cipher cipher = this.getCipher();
            byte[] salt = new byte[8];
            RAND.nextBytes(salt);
            byte[] b = new byte[10];
            RAND.nextBytes(b);
            char[] pw = new String(b, StandardCharsets.UTF_8).toCharArray();
            SecretKey key = this.getPassportKey(pw, salt);
            cipher.init(1, key);
            return super.supported();
        }
        catch (Exception e) {
            HBCIUtils.log("no support for passport format " + this.getClass().getSimpleName() + ": " + e.getMessage(), 3);
            return false;
        }
    }

    private SecretKey getPassportKey(HBCIPassport passport, byte[] salt, boolean forSaving) throws GeneralSecurityException {
        try {
            char[] pw = this.getPassword(passport, forSaving);
            return this.getPassportKey(pw, salt);
        }
        catch (NoSuchAlgorithmException e) {
            HBCIUtils.log("AES-Format not supported in this Java version", 4);
            throw new UnsupportedOperationException("AES-Format not supported in this Java version");
        }
    }

    private SecretKey getPassportKey(char[] password, byte[] salt) throws GeneralSecurityException {
        try {
            String provider = CryptUtils.getSecurityProvider();
            SecretKeyFactory fac = provider != null ? SecretKeyFactory.getInstance(KEY_ALG_NAME, provider) : SecretKeyFactory.getInstance(KEY_ALG_NAME);
            PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 256);
            SecretKey tmp = fac.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), KEY_ALG);
            return secret;
        }
        catch (NoSuchAlgorithmException e) {
            HBCIUtils.log("AES-Format not supported in this Java version", 4);
            throw new UnsupportedOperationException("AES-Format not supported in this Java version");
        }
    }
}

