/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.storage.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.format.AbstractFormat;
import org.kapott.hbci.passport.storage.format.legacy.Converter;
import org.kapott.hbci.tools.CryptUtils;
import org.kapott.hbci.tools.IOUtils;

public class LegacyFormat
extends AbstractFormat {
    private static List<Converter> converters = null;
    private static final String CIPHER_ALG = "PBEWithMD5AndDES";
    private static final int CIPHER_ITERATIONS = 987;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PassportData load(HBCIPassport passport, byte[] data) throws UnsupportedOperationException {
        Converter converter = this.getConverter(passport);
        int retries = this.getRetries();
        int i = 0;
        while (i < 10) {
            block11: {
                CipherInputStream is = null;
                try {
                    Cipher cipher = this.getCipher();
                    SecretKey key = this.getPassportKey(passport, false);
                    PBEParameterSpec paramspec = new PBEParameterSpec(converter.getSalt(), 987);
                    cipher.init(2, (Key)key, paramspec);
                    is = new CipherInputStream(new ByteArrayInputStream(data), cipher);
                    PassportData passportData = converter.load(is);
                    IOUtils.close(is);
                    return passportData;
                }
                catch (UnsupportedOperationException uoe) {
                    throw uoe;
                    catch (HBCI_Exception e) {
                        if (retries-- <= 0) {
                            throw e;
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        if (retries-- <= 0) {
                            throw new HBCI_Exception("unable to load passport data", ex);
                        }
                    }
                }
                finally {
                    IOUtils.close(is);
                }
            }
            ++i;
        }
        throw new HBCI_Exception("unable to load passport data");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] save(HBCIPassport passport, PassportData data) throws UnsupportedOperationException {
        byte[] byArray;
        Converter converter = this.getConverter(passport);
        CipherOutputStream os = null;
        try {
            Cipher cipher = this.getCipher();
            SecretKey key = this.getPassportKey(passport, false);
            PBEParameterSpec paramspec = new PBEParameterSpec(converter.getSalt(), 987);
            cipher.init(1, (Key)key, paramspec);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            os = new CipherOutputStream(bos, cipher);
            converter.save(data, os);
            os.close();
            byArray = bos.toByteArray();
        }
        catch (HBCI_Exception e) {
            try {
                throw e;
                catch (Exception ex) {
                    throw new HBCI_Exception("unable to load passport data", ex);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close(os);
        return byArray;
    }

    @Override
    protected String getCipherAlg() {
        return CIPHER_ALG;
    }

    private SecretKey getPassportKey(HBCIPassport passport, boolean forSaving) throws GeneralSecurityException {
        char[] pw = this.getPassword(passport, forSaving);
        String provider = CryptUtils.getSecurityProvider();
        SecretKeyFactory fac = provider != null ? SecretKeyFactory.getInstance(CIPHER_ALG, provider) : SecretKeyFactory.getInstance(CIPHER_ALG);
        PBEKeySpec keyspec = new PBEKeySpec(pw);
        SecretKey passportKey = fac.generateSecret(keyspec);
        keyspec.clearPassword();
        return passportKey;
    }

    private Converter getConverter(HBCIPassport p) {
        for (Converter c : converters) {
            if (!c.supports(p)) continue;
            return c;
        }
        throw new UnsupportedOperationException("found no matching converter for passport type " + p.getClass().getSimpleName());
    }

    private static void init() {
        if (converters != null) {
            return;
        }
        converters = new LinkedList<Converter>();
        HBCIUtils.log("searching supported converters", 4);
        ServiceLoader<Converter> loader = ServiceLoader.load(Converter.class);
        for (Converter c : loader) {
            HBCIUtils.log("  " + c.getClass().getSimpleName(), 4);
            converters.add(c);
        }
        if (converters.size() == 0) {
            HBCIUtils.log("no supported legacy converters found", 1);
        }
    }

    static {
        LegacyFormat.init();
    }
}

