/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.storage.format.legacy;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.kapott.cryptalgs.RSAPrivateCrtKey2;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.format.legacy.AbstractConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractConverterXML
extends AbstractConverter {
    protected Element read(InputStream is) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(is).getDocumentElement();
    }

    @Override
    public void save(PassportData data, OutputStream os) throws Exception {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setValidating(false);
        DocumentBuilder db = fac.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement("HBCIPassportRDHNew");
        this.fill(doc, root, data);
        TransformerFactory tfac = TransformerFactory.newInstance();
        Transformer tform = tfac.newTransformer();
        tform.setOutputProperty("method", "xml");
        tform.setOutputProperty("omit-xml-declaration", "no");
        tform.setOutputProperty("encoding", "ISO-8859-1");
        tform.setOutputProperty("indent", "yes");
        tform.transform(new DOMSource(root), new StreamResult(os));
        os.flush();
    }

    protected abstract void fill(Document var1, Element var2, PassportData var3);

    protected String getElementValue(Element root, String name) {
        Node content;
        NodeList list = root.getElementsByTagName(name);
        if (list != null && list.getLength() != 0 && (content = list.item(0).getFirstChild()) != null) {
            return content.getNodeValue();
        }
        return null;
    }

    protected Properties getElementProps(Element root, String name) {
        Node base = root.getElementsByTagName(name).item(0);
        if (base == null) {
            return null;
        }
        Properties ret = new Properties();
        NodeList entries = base.getChildNodes();
        int len = entries.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = entries.item(i);
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            ret.setProperty(e.getAttribute("name"), e.getAttribute("value"));
        }
        return ret;
    }

    protected HBCIKey getElementKey(Element root, String owner, String type, String part) throws Exception {
        HBCIKey ret = null;
        NodeList keys = root.getElementsByTagName("key");
        int len = keys.getLength();
        for (int i = 0; i < len; ++i) {
            Key key;
            Element keynode;
            Node n = keys.item(i);
            if (n.getNodeType() != 1 || !(keynode = (Element)n).getAttribute("owner").equals(owner) || !keynode.getAttribute("type").equals(type) || !keynode.getAttribute("part").equals(part)) continue;
            if (part.equals("public")) {
                RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(this.getElementValue(keynode, "modulus")), new BigInteger(this.getElementValue(keynode, "exponent")));
                key = KeyFactory.getInstance("RSA").generatePublic(spec);
            } else {
                String modulus = this.getElementValue(keynode, "modulus");
                String privexponent = this.getElementValue(keynode, "exponent");
                String pubexponent = this.getElementValue(keynode, "pubexponent");
                String p = this.getElementValue(keynode, "p");
                String q = this.getElementValue(keynode, "q");
                String dP = this.getElementValue(keynode, "dP");
                String dQ = this.getElementValue(keynode, "dQ");
                String qInv = this.getElementValue(keynode, "qInv");
                if (privexponent == null) {
                    HBCIUtils.log("private " + type + " key is CRT-only", 4);
                    key = new RSAPrivateCrtKey2(new BigInteger(p), new BigInteger(q), new BigInteger(dP), new BigInteger(dQ), new BigInteger(qInv));
                } else if (p == null) {
                    HBCIUtils.log("private " + type + " key is exponent-only", 4);
                    RSAPrivateKeySpec spec = new RSAPrivateKeySpec(new BigInteger(modulus), new BigInteger(privexponent));
                    key = KeyFactory.getInstance("RSA").generatePrivate(spec);
                } else {
                    HBCIUtils.log("private " + type + " key is fully specified", 4);
                    RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(new BigInteger(modulus), new BigInteger(pubexponent), new BigInteger(privexponent), new BigInteger(p), new BigInteger(q), new BigInteger(dP), new BigInteger(dQ), new BigInteger(qInv));
                    key = KeyFactory.getInstance("RSA").generatePrivate(spec);
                }
            }
            ret = new HBCIKey(this.getElementValue(keynode, "country"), this.getElementValue(keynode, "blz"), this.getElementValue(keynode, "userid"), this.getElementValue(keynode, "keynum"), this.getElementValue(keynode, "keyversion"), key);
            break;
        }
        return ret;
    }

    protected void createElement(Document doc, Element root, String elemName, String elemValue) {
        Element elem = doc.createElement(elemName);
        root.appendChild(elem);
        Text data = doc.createTextNode(this.notNull(elemValue));
        elem.appendChild(data);
    }

    protected void createPropsElement(Document doc, Element root, String elemName, Properties p) {
        if (p == null) {
            return;
        }
        Element base = doc.createElement(elemName);
        root.appendChild(base);
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            Element data = doc.createElement("entry");
            data.setAttribute("name", key);
            data.setAttribute("value", this.notNull(value));
            base.appendChild(data);
        }
    }

    protected void createKeyElement(Document doc, Element root, String owner, String type, String part, HBCIKey key) {
        if (key == null) {
            return;
        }
        Element base = doc.createElement("key");
        base.setAttribute("owner", this.notNull(owner));
        base.setAttribute("type", this.notNull(type));
        base.setAttribute("part", this.notNull(part));
        root.appendChild(base);
        this.createElement(doc, base, "country", this.notNull(key.country));
        this.createElement(doc, base, "blz", this.notNull(key.blz));
        this.createElement(doc, base, "userid", this.notNull(key.userid));
        this.createElement(doc, base, "keynum", this.notNull(key.num));
        this.createElement(doc, base, "keyversion", this.notNull(key.version));
        Element keydata = doc.createElement("keydata");
        base.appendChild(keydata);
        byte[] e = key.key.getEncoded();
        String encoded = e != null ? HBCIUtils.encodeBase64(e) : null;
        String format = key.key.getFormat();
        if (encoded != null) {
            Element data = doc.createElement("rawdata");
            data.setAttribute("format", format);
            data.setAttribute("encoding", "base64");
            keydata.appendChild(data);
            Text content = doc.createTextNode(encoded);
            data.appendChild(content);
        }
        if (part.equals("public") && key.key != null) {
            this.createElement(doc, keydata, "modulus", ((RSAPublicKey)key.key).getModulus().toString());
            this.createElement(doc, keydata, "exponent", ((RSAPublicKey)key.key).getPublicExponent().toString());
        } else if (key.key instanceof RSAPrivateCrtKey) {
            HBCIUtils.log("saving " + type + " key as fully specified", 4);
            this.createElement(doc, keydata, "modulus", ((RSAPrivateCrtKey)key.key).getModulus().toString());
            this.createElement(doc, keydata, "exponent", ((RSAPrivateCrtKey)key.key).getPrivateExponent().toString());
            this.createElement(doc, keydata, "pubexponent", ((RSAPrivateCrtKey)key.key).getPublicExponent().toString());
            this.createElement(doc, keydata, "p", ((RSAPrivateCrtKey)key.key).getPrimeP().toString());
            this.createElement(doc, keydata, "q", ((RSAPrivateCrtKey)key.key).getPrimeQ().toString());
            this.createElement(doc, keydata, "dP", ((RSAPrivateCrtKey)key.key).getPrimeExponentP().toString());
            this.createElement(doc, keydata, "dQ", ((RSAPrivateCrtKey)key.key).getPrimeExponentQ().toString());
            this.createElement(doc, keydata, "qInv", ((RSAPrivateCrtKey)key.key).getCrtCoefficient().toString());
        } else if (key.key instanceof RSAPrivateKey) {
            HBCIUtils.log("saving " + type + " key as exponent-only", 4);
            this.createElement(doc, keydata, "modulus", ((RSAPrivateKey)key.key).getModulus().toString());
            this.createElement(doc, keydata, "exponent", ((RSAPrivateKey)key.key).getPrivateExponent().toString());
        } else if (key.key instanceof RSAPrivateCrtKey2) {
            HBCIUtils.log("saving " + type + " key as crt-only", 4);
            this.createElement(doc, keydata, "p", ((RSAPrivateCrtKey2)key.key).getP().toString());
            this.createElement(doc, keydata, "q", ((RSAPrivateCrtKey2)key.key).getQ().toString());
            this.createElement(doc, keydata, "dP", ((RSAPrivateCrtKey2)key.key).getdP().toString());
            this.createElement(doc, keydata, "dQ", ((RSAPrivateCrtKey2)key.key).getdQ().toString());
            this.createElement(doc, keydata, "qInv", ((RSAPrivateCrtKey2)key.key).getQInv().toString());
        } else {
            HBCIUtils.log("key has none of the known types - please contact the author!", 2);
        }
    }

    private String notNull(String value) {
        return value != null ? value : "";
    }
}

