/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport.storage.format.legacy;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportDDV;
import org.kapott.hbci.passport.storage.PassportData;
import org.kapott.hbci.passport.storage.format.legacy.AbstractConverter;

public class ConverterDDV
extends AbstractConverter {
    private static final byte[] CIPHER_SALT_DDV = new byte[]{86, -68, 28, -120, 31, -29, 115, -52};

    @Override
    public byte[] getSalt() {
        return CIPHER_SALT_DDV;
    }

    @Override
    public PassportData load(InputStream is) throws Exception {
        PassportData data = new PassportData();
        ObjectInputStream o = new ObjectInputStream(is);
        data.bpd = (Properties)o.readObject();
        data.upd = (Properties)o.readObject();
        data.hbciVersion = (String)o.readObject();
        return data;
    }

    @Override
    public void save(PassportData data, OutputStream os) throws Exception {
        ObjectOutputStream o = new ObjectOutputStream(os);
        o.writeObject(data.bpd);
        o.writeObject(data.upd);
        o.writeObject(data.hbciVersion);
        os.flush();
    }

    @Override
    public boolean supports(HBCIPassport passport) {
        return passport != null && passport instanceof HBCIPassportDDV;
    }
}

