/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.kapott.hbci.protocol.DEG;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.kapott.hbci.protocol.factory.DEGFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MultipleDEGs
extends MultipleSyntaxElements {
    private char delimiter;

    @Override
    protected SyntaxElement createAndAppendNewElement(Node ref, String path, int idx, Document syntax) {
        DEG ret = null;
        ret = DEGFactory.getInstance().createDEG(this.getType(), this.getName(), path, idx, syntax);
        this.addElement(ret);
        return ret;
    }

    private void initData(Node degref, char delimiter, String path, Document syntax) {
        this.delimiter = delimiter;
    }

    public MultipleDEGs(Node degref, char delimiter, String path, Document syntax) {
        super(degref, path, syntax);
        this.initData(degref, delimiter, path, syntax);
    }

    public void init(Node degref, char delimiter, String path, Document syntax) {
        super.init(degref, path, syntax);
        this.initData(degref, delimiter, path, syntax);
    }

    @Override
    public String toString(int zero) {
        StringBuffer ret = new StringBuffer(128);
        boolean first = true;
        ListIterator<SyntaxElement> i = this.getElements().listIterator();
        while (i.hasNext()) {
            if (!first) {
                ret.append(this.delimiter);
            }
            first = false;
            DEG deg = (DEG)i.next();
            if (deg == null) continue;
            ret.append(deg.toString(0));
        }
        return ret.toString();
    }

    @Override
    protected SyntaxElement parseAndAppendNewElement(Node ref, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        DEG ret = null;
        ret = DEGFactory.getInstance().createDEG(this.getType(), this.getName(), path, predelim, idx, res, fullResLen, syntax, predefs, valids);
        this.addElement(ret);
        return ret;
    }

    private void initData(Node degref, char delimiter, String path, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<?, ?> predefs, Hashtable<?, ?> valids) {
        this.delimiter = delimiter;
    }

    public MultipleDEGs(Node degref, char delimiter, String path, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super(degref, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        this.initData(degref, delimiter, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
    }

    public void init(Node degref, char delimiter, String path, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super.init(degref, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
        this.initData(degref, delimiter, path, predelim0, predelim1, res, fullResLen, syntax, predefs, valids);
    }

    @Override
    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
        if (this.getElements().size() != 0) {
            for (SyntaxElement e : this.getElements()) {
                if (e == null) continue;
                e.getElementPaths(p, segref, degref, deref);
            }
        } else if (deref == null) {
            p.setProperty(Integer.toString(segref[0]) + ":" + Integer.toString(degref[0]), this.getPath());
            degref[0] = degref[0] + 1;
        } else {
            p.setProperty(Integer.toString(segref[0]) + ":" + Integer.toString(degref[0]) + "," + Integer.toString(deref[0]), this.getPath());
            deref[0] = deref[0] + 1;
        }
    }

    @Override
    public void destroy() {
        List<SyntaxElement> children = this.getElements();
        Iterator<SyntaxElement> i = children.iterator();
        while (i.hasNext()) {
            DEGFactory.getInstance().unuseObject(i.next());
        }
        super.destroy();
    }
}

