/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.rewrite;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.rewrite.Rewrite;

public class RWrongStatusSegOrder
extends Rewrite {
    private List<Properties> createSegmentListFromMessage(String msg) {
        ArrayList<Properties> segmentList = new ArrayList<Properties>();
        boolean quoteNext = false;
        int startPosi = 0;
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (!quoteNext && ch == '@') {
                int idx = msg.indexOf("@", i + 1);
                String len_st = msg.substring(i + 1, idx);
                i += Integer.parseInt(len_st) + 1 + len_st.length();
            } else if (!quoteNext && ch == '\'') {
                Properties segmentInfo = new Properties();
                segmentInfo.setProperty("code", msg.substring(startPosi, msg.indexOf(":", startPosi)));
                segmentInfo.setProperty("start", Integer.toString(startPosi));
                segmentInfo.setProperty("length", Integer.toString(i - startPosi + 1));
                segmentList.add(segmentInfo);
                startPosi = i + 1;
            }
            quoteNext = !quoteNext && ch == '?';
        }
        return segmentList;
    }

    @Override
    public String incomingClearText(String st, MsgGen gen) {
        List<Properties> segmentList = this.createSegmentListFromMessage(st);
        ArrayList<Properties> headerList = new ArrayList<Properties>();
        ArrayList<Properties> HIRMGList = new ArrayList<Properties>();
        ArrayList<Properties> HIRMSList = new ArrayList<Properties>();
        ArrayList<Properties> dataList = new ArrayList<Properties>();
        boolean inHeader = true;
        boolean inGlob = false;
        boolean inSeg = false;
        boolean inData = false;
        boolean errorOccured = false;
        for (Properties segmentInfo : segmentList) {
            String segmentCode = segmentInfo.getProperty("code");
            if (segmentCode.equals("HNHBK") || segmentCode.equals("HNSHK")) {
                headerList.add(segmentInfo);
                if (inHeader) continue;
                HBCIUtils.log("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position", 2);
                errorOccured = true;
                continue;
            }
            if (segmentCode.equals("HIRMG")) {
                HIRMGList.add(segmentInfo);
                if (inHeader) {
                    inHeader = false;
                    inGlob = true;
                }
                if (inGlob) continue;
                HBCIUtils.log("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position", 2);
                errorOccured = true;
                continue;
            }
            if (segmentCode.equals("HIRMS")) {
                HIRMSList.add(segmentInfo);
                if (inGlob) {
                    inGlob = false;
                    inSeg = true;
                }
                if (inSeg) continue;
                HBCIUtils.log("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position", 2);
                errorOccured = true;
                continue;
            }
            dataList.add(segmentInfo);
            if (inGlob || inSeg) {
                inGlob = false;
                inSeg = false;
                inData = true;
            }
            if (inData) continue;
            HBCIUtils.log("RWrongStatusSegOrder: found segment " + segmentCode + " at invalid position", 2);
            errorOccured = true;
        }
        StringBuffer new_msg = new StringBuffer();
        if (errorOccured) {
            int counter = 1;
            new_msg.append(this.getDataForSegmentList(st, headerList, counter));
            new_msg.append(this.getDataForSegmentList(st, HIRMGList, counter += headerList.size()));
            new_msg.append(this.getDataForSegmentList(st, HIRMSList, counter += HIRMGList.size()));
            new_msg.append(this.getDataForSegmentList(st, dataList, counter += HIRMSList.size()));
            HBCIUtils.log("RWrongStatusSegOrder: new message after reordering: " + new_msg, 5);
        } else {
            new_msg.append(st);
        }
        return new_msg.toString();
    }

    private String getDataForSegmentList(String origMsg, List<Properties> list, int counter) {
        StringBuffer data = new StringBuffer();
        for (Properties segmentInfo : list) {
            int start = Integer.parseInt(segmentInfo.getProperty("start"));
            int len = Integer.parseInt(segmentInfo.getProperty("length"));
            StringBuffer segmentData = new StringBuffer(origMsg.substring(start, start + len));
            data.append(segmentData.toString());
            ++counter;
        }
        return data.toString();
    }
}

