/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.security;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SEG;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Crypt {
    public static final String SECFUNC_ENC = "4";
    public static final String SECFUNC_ENC_PLAIN = "998";
    public static final String ENCALG_2K3DES = "13";
    public static final String ENCALG_AES256 = "14";
    public static final String ENCMODE_CBC = "2";
    public static final String ENCMODE_PKCS1 = "18";
    public static final String ENC_KEYTYPE_RSA = "6";
    public static final String ENC_KEYTYPE_DDV = "5";
    private IHandlerData handlerdata;
    private MSG msg;
    private String u_secfunc;
    private String u_keytype;
    private String u_blz;
    private String u_country;
    private String u_keyuserid;
    private String u_keynum;
    private String u_keyversion;
    private String u_cid;
    private String u_sysId;
    private String u_role;
    private String u_alg;
    private String u_mode;
    private String u_compfunc;

    public void setParam(String name, String value) {
        try {
            Field field = this.getClass().getDeclaredField("u_" + name);
            HBCIUtils.log("setting " + name + " to " + value, 4);
            field.set(this, value);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while setting parameter", ex);
        }
    }

    private void initData(IHandlerData handlerdata, MSG msg) {
        this.msg = msg;
        this.handlerdata = handlerdata;
    }

    public Crypt(IHandlerData handlerdata, MSG msg) {
        this.initData(handlerdata, msg);
    }

    public void init(IHandlerData handlerdata, MSG msg) {
        this.initData(handlerdata, msg);
    }

    private byte[] getPlainString() {
        try {
            StringBuffer ret = new StringBuffer(1024);
            List<MultipleSyntaxElements> childs = this.msg.getChildContainers();
            int len = childs.size();
            for (int i = 1; i < len - 1; ++i) {
                ret.append(childs.get(i).toString(0));
            }
            int padLength = 8 - ret.length() % 8;
            for (int i = 0; i < padLength - 1; ++i) {
                ret.append('\u0000');
            }
            ret.append((char)padLength);
            return ret.toString().getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while extracting plain message string", ex);
        }
    }

    public MSG cryptIt(String newName) {
        MSG newmsg = this.msg;
        HBCIPassportInternal passport = (HBCIPassportInternal)this.handlerdata.getPassport();
        if (passport.hasInstEncKey()) {
            MsgGen gen;
            String msgName = this.msg.getName();
            Node msgNode = this.msg.getSyntaxDef(msgName, (gen = this.handlerdata.getMsgGen()).getSyntax());
            String dontcryptAttr = ((Element)msgNode).getAttribute("dontcrypt");
            if (dontcryptAttr.length() == 0) {
                try {
                    this.setParam("secfunc", passport.getCryptFunction());
                    this.setParam("keytype", passport.getCryptKeyType());
                    this.setParam("blz", passport.getBLZ());
                    this.setParam("country", passport.getCountry());
                    this.setParam("keyuserid", passport.getInstEncKeyName());
                    this.setParam("keynum", passport.getInstEncKeyNum());
                    this.setParam("keyversion", passport.getInstEncKeyVersion());
                    this.setParam("cid", passport.getCID());
                    this.setParam("sysId", passport.getSysId());
                    this.setParam("role", "1");
                    this.setParam("alg", passport.getCryptAlg());
                    this.setParam("mode", passport.getCryptMode());
                    this.setParam("compfunc", "0");
                    byte[][] crypteds = passport.encrypt(this.getPlainString());
                    String msgPath = this.msg.getPath();
                    String dialogid = this.msg.getValueOfDE(msgPath + ".MsgHead.dialogid");
                    String msgnum = this.msg.getValueOfDE(msgPath + ".MsgHead.msgnum");
                    String segnum = this.msg.getValueOfDE(msgPath + ".MsgTail.SegHead.seq");
                    Date d = new Date();
                    gen.set(newName + ".CryptData.data", "B" + new String(crypteds[1], "ISO-8859-1"));
                    gen.set(newName + ".CryptHead.CryptAlg.alg", this.u_alg);
                    gen.set(newName + ".CryptHead.CryptAlg.mode", this.u_mode);
                    gen.set(newName + ".CryptHead.CryptAlg.enckey", "B" + new String(crypteds[0], "ISO-8859-1"));
                    gen.set(newName + ".CryptHead.CryptAlg.keytype", this.u_keytype);
                    gen.set(newName + ".CryptHead.SecIdnDetails.func", newmsg.getName().endsWith("Res") ? ENCMODE_CBC : "1");
                    gen.set(newName + ".CryptHead.KeyName.KIK.blz", this.u_blz);
                    gen.set(newName + ".CryptHead.KeyName.KIK.country", this.u_country);
                    gen.set(newName + ".CryptHead.KeyName.userid", this.u_keyuserid);
                    gen.set(newName + ".CryptHead.KeyName.keynum", this.u_keynum);
                    gen.set(newName + ".CryptHead.KeyName.keyversion", this.u_keyversion);
                    gen.set(newName + ".CryptHead.SecProfile.method", passport.getProfileMethod());
                    gen.set(newName + ".CryptHead.SecProfile.version", passport.getProfileVersion());
                    if (passport.getSysStatus().equals("0")) {
                        gen.set(newName + ".CryptHead.SecIdnDetails.cid", "B" + this.u_cid);
                    } else {
                        gen.set(newName + ".CryptHead.SecIdnDetails.sysid", this.u_sysId);
                    }
                    gen.set(newName + ".CryptHead.SecTimestamp.date", HBCIUtils.date2StringISO(d));
                    gen.set(newName + ".CryptHead.SecTimestamp.time", HBCIUtils.time2StringISO(d));
                    gen.set(newName + ".CryptHead.role", this.u_role);
                    gen.set(newName + ".CryptHead.secfunc", this.u_secfunc);
                    gen.set(newName + ".CryptHead.compfunc", this.u_compfunc);
                    gen.set(newName + ".MsgHead.dialogid", dialogid);
                    gen.set(newName + ".MsgHead.msgnum", msgnum);
                    gen.set(newName + ".MsgTail.msgnum", msgnum);
                    if (newName.endsWith("Res")) {
                        gen.set(newName + ".MsgHead.MsgRef.dialogid", dialogid);
                        gen.set(newName + ".MsgHead.MsgRef.msgnum", msgnum);
                    }
                    newmsg = gen.generate(newName);
                    for (int i = 1; i <= 2; ++i) {
                        SEG seg = (SEG)((MultipleSEGs)newmsg.getChildContainers().get(i)).getElements().get(0);
                        seg.setSeq(997 + i, true);
                    }
                    newmsg.propagateValue(newmsg.getPath() + ".MsgTail.SegHead.seq", segnum, false, true);
                    newmsg.autoSetMsgSize(gen);
                }
                catch (Exception ex) {
                    throw new HBCI_Exception("*** error while encrypting", ex);
                }
            } else {
                HBCIUtils.log("did not encrypt - message does not want to be encrypted", 4);
            }
        } else {
            HBCIUtils.log("can not encrypt - no encryption key available", 2);
        }
        return newmsg;
    }

    private boolean isCrypted() {
        boolean ret = true;
        MultipleSyntaxElements seglist = this.msg.getChildContainers().get(1);
        if (seglist instanceof MultipleSEGs) {
            SEG crypthead = null;
            try {
                crypthead = (SEG)seglist.getElements().get(0);
            }
            catch (Exception e) {
                ret = false;
            }
            if (ret) {
                String sigheadCode = "HNVSK";
                MsgGen gen = this.handlerdata.getMsgGen();
                if (!crypthead.getCode(gen).equals(sigheadCode)) {
                    ret = false;
                }
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public String decryptIt() {
        StringBuffer ret = new StringBuffer(this.msg.toString(0));
        HBCIPassportInternal passport = (HBCIPassportInternal)this.handlerdata.getPassport();
        if (passport.hasMyEncKey()) {
            if (this.isCrypted()) {
                try {
                    String errmsg;
                    String errmsg2;
                    String msgName = this.msg.getName();
                    List<MultipleSyntaxElements> childs = this.msg.getChildContainers();
                    SEG msghead = (SEG)((MultipleSEGs)childs.get(0)).getElements().get(0);
                    SEG msgtail = (SEG)((MultipleSEGs)childs.get(childs.size() - 1)).getElements().get(0);
                    SEG cryptdata = (SEG)((MultipleSEGs)childs.get(2)).getElements().get(0);
                    byte[] cryptedstring = cryptdata.getValueOfDE(msgName + ".CryptData.data").getBytes("ISO-8859-1");
                    SEG crypthead = (SEG)((MultipleSEGs)childs.get(1)).getElements().get(0);
                    byte[] cryptedkey = crypthead.getValueOfDE(msgName + ".CryptHead.CryptAlg.enckey").getBytes("ISO-8859-1");
                    String secfunc = crypthead.getValueOfDE(msgName + ".CryptHead.secfunc");
                    if (!secfunc.equals(passport.getCryptFunction()) && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreCryptErrors", errmsg2 = HBCIUtilsInternal.getLocMsg("EXCMSG_CRYPTSFFAIL", new Object[]{secfunc, passport.getCryptFunction()}))) {
                        throw new HBCI_Exception(errmsg2);
                    }
                    String compfunc = crypthead.getValueOfDE(msgName + ".CryptHead.compfunc");
                    if (!compfunc.equals("0") && !HBCIUtilsInternal.ignoreError(null, "client.errors.ignoreCryptErrors", errmsg = HBCIUtilsInternal.getLocMsg("EXCMSG_CRYPTCOMPFUNCFAIL", compfunc))) {
                        throw new HBCI_Exception(errmsg);
                    }
                    byte[] plainMsg = passport.decrypt(cryptedkey, cryptedstring);
                    byte padLength = plainMsg[plainMsg.length - 1];
                    ret = new StringBuffer(1024);
                    ret.append(msghead.toString(0)).append(new String(plainMsg, 0, plainMsg.length - padLength, "ISO-8859-1")).append(msgtail.toString(0));
                    HBCIUtils.log("decrypted message: " + ret, 5);
                }
                catch (Exception ex) {
                    throw new HBCI_Exception("*** error while decrypting", ex);
                }
            } else {
                HBCIUtils.log("did not decrypt - message is already cleartext", 4);
            }
        } else {
            HBCIUtils.log("can not decrypt - no decryption key available", 2);
        }
        return ret.toString();
    }

    public void destroy() {
        this.handlerdata = null;
        this.msg = null;
        this.u_alg = null;
        this.u_blz = null;
        this.u_cid = null;
        this.u_compfunc = null;
        this.u_country = null;
        this.u_keynum = null;
        this.u_keyuserid = null;
        this.u_keyversion = null;
        this.u_mode = null;
        this.u_role = null;
        this.u_secfunc = null;
        this.u_keytype = null;
        this.u_sysId = null;
    }
}

