/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.io.ByteArrayOutputStream;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.smartcardio.SmartCardService;

public class ChipTanCardService
extends SmartCardService {
    public String getTan(String hhduc) {
        try {
            Integer feature = this.getFeatures().get((Object)SmartCardService.Feature.FEATURE_MCT_READER_DIRECT);
            if (feature != null) {
                return this.getTanScardControl(hhduc);
            }
            return this.getTanScardTransmit(hhduc);
        }
        catch (HBCI_Exception e) {
            throw e;
        }
        catch (Exception e2) {
            throw new HBCI_Exception(e2);
        }
    }

    public String getTanScardControl(String hhduc) throws Exception {
        String tan = null;
        byte[] hhdBytes = this.toBytes(hhduc);
        HBCIUtils.log("sending HHDuc to chipcard using ScardControl, length: " + hhdBytes.length, 4);
        int len = 8 + hhdBytes.length;
        ByteArrayOutputStream cmd = new ByteArrayOutputStream();
        cmd.write(new byte[]{32, 118, 0, 0});
        cmd.write(new byte[]{0, 0, (byte)len});
        cmd.write(new byte[]{0, 0, 0, 0});
        cmd.write(1);
        cmd.write(0);
        cmd.write(new byte[]{0, (byte)hhdBytes.length});
        cmd.write(hhdBytes);
        cmd.write(new byte[]{0, 0});
        byte[] request = cmd.toByteArray();
        byte[] response = this.getCard().transmitControlCommand(this.getFeatures().get((Object)SmartCardService.Feature.FEATURE_MCT_READER_DIRECT), request);
        ResponseAPDU apdu = new ResponseAPDU(response);
        this.check(apdu, new byte[]{-112, -111});
        byte[] data = apdu.getData();
        if (data != null && data.length > 1) {
            byte tanLength = data[0];
            HBCIUtils.log("received TAN", 4);
            if (tanLength > 0) {
                byte[] tanBytes = new byte[tanLength];
                System.arraycopy(data, 1, tanBytes, 0, tanLength);
                tan = this.parseTAN(tanBytes);
                HBCIUtils.log("TAN length: " + tan.length() + " chars", 4);
            }
        }
        try {
            HBCIUtils.log("finalizing chipcard transaction", 4);
            ByteArrayOutputStream cmd2 = new ByteArrayOutputStream();
            cmd2.write(new byte[]{32, 119, 0, 0});
            cmd2.write(new byte[]{0, 0, 6});
            cmd2.write(new byte[]{0, 0, 0, 0});
            cmd2.write(0);
            cmd2.write(0);
            cmd2.write(new byte[]{0, 0});
            byte[] response2 = this.getCard().transmitControlCommand(this.getFeatures().get((Object)SmartCardService.Feature.FEATURE_MCT_READER_DIRECT), cmd2.toByteArray());
            ResponseAPDU apdu2 = new ResponseAPDU(response2);
            this.check(apdu2, new byte[]{-112, -111, 109});
        }
        catch (Exception e) {
            HBCIUtils.log("error while finalizing transaction, continue nevertheless since we already have a TAN - stacktrace for debugging purpose", 4);
            HBCIUtils.log(e, 4);
        }
        HBCIUtils.log("returning TAN", 4);
        return tan;
    }

    public String getTanScardTransmit(String hhduc) throws Exception {
        String tan = null;
        byte[] hhdBytes = this.toBytes(hhduc);
        HBCIUtils.log("sending HHDuc to chipcard using ScardTransmit, length: " + hhdBytes.length, 4);
        int len = 8 + hhdBytes.length;
        ByteArrayOutputStream cmd = new ByteArrayOutputStream();
        cmd.write(new byte[]{-1, -111, 6, 0});
        cmd.write(new byte[]{0, 0, (byte)len});
        cmd.write(new byte[]{0, 0, 0, 0});
        cmd.write(1);
        cmd.write(0);
        cmd.write(new byte[]{0, (byte)hhdBytes.length});
        cmd.write(hhdBytes);
        cmd.write(new byte[]{0, 0});
        byte[] request = cmd.toByteArray();
        CommandAPDU apdu = new CommandAPDU(request);
        byte[] data = this.receive(apdu, new byte[]{-112, -111});
        if (data != null && data.length > 1) {
            byte tanLength = data[0];
            HBCIUtils.log("received TAN", 4);
            if (tanLength > 0) {
                byte[] tanBytes = new byte[tanLength];
                System.arraycopy(data, 1, tanBytes, 0, tanLength);
                tan = this.parseTAN(tanBytes);
                HBCIUtils.log("TAN length: " + tan.length() + " chars", 4);
            }
        }
        try {
            HBCIUtils.log("finalizing chipcard transaction", 4);
            ByteArrayOutputStream cmd2 = new ByteArrayOutputStream();
            cmd2.write(new byte[]{-1, -111, 7, 0});
            cmd2.write(new byte[]{0, 0, 6});
            cmd2.write(new byte[]{0, 0, 0, 0});
            cmd2.write(0);
            cmd2.write(0);
            cmd2.write(new byte[]{0, 0});
            byte[] request2 = cmd2.toByteArray();
            CommandAPDU apdu2 = new CommandAPDU(request2);
            this.receive(apdu2, new byte[]{-112, -111, 109, 1});
        }
        catch (Exception e) {
            HBCIUtils.log("error while finalizing transaction, continue nevertheless since we already have a TAN - stacktrace for debugging purpose", 4);
            HBCIUtils.log(e, 4);
        }
        HBCIUtils.log("returning TAN", 4);
        return tan;
    }

    public String parseTAN(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            sb.append(b1);
            if (i + 1 == bytes.length && b2 == 15) break;
            sb.append(b2);
        }
        return sb.toString();
    }
}

