/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.callback.HBCICallbackUnsupported;
import org.kapott.hbci.concurrent.DefaultHBCIPassportFactory;
import org.kapott.hbci.concurrent.HBCIRunnable;
import org.kapott.hbci.concurrent.HBCIThreadFactory;
import org.kapott.hbci.manager.FileSystemClassLoader;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public final class AnalyzeReportOfTransactions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HBCIPassport passport = null;
        HBCIHandler hbciHandle = null;
        HBCIUtils.init(HBCIUtils.loadPropertiesFile(new FileSystemClassLoader(), "/home/stefan.palme/temp/a.props"), new MyHBCICallback());
        String passportDescription = "Passport f\u00fcr Kontoauszugs-Demo";
        passport = AbstractHBCIPassport.getInstance((Object)passportDescription);
        try {
            String version = passport.getHBCIVersion();
            hbciHandle = new HBCIHandler(version.length() != 0 ? version : "plus", passport);
            AnalyzeReportOfTransactions.analyzeReportOfTransactions(passport, hbciHandle);
        }
        finally {
            if (hbciHandle != null) {
                hbciHandle.close();
            } else if (passport != null) {
                passport.close();
            }
        }
    }

    public static void main_multithreaded(String[] args) throws Exception {
        HBCIUtils.init(new Properties(), new HBCICallbackUnsupported());
        ExecutorService executor = Executors.newCachedThreadPool(new HBCIThreadFactory());
        Properties properties = HBCIUtils.loadPropertiesFile(new FileSystemClassLoader(), "/home/stefan.palme/temp/a.props");
        MyHBCICallback callback = new MyHBCICallback();
        DefaultHBCIPassportFactory passportFactory = new DefaultHBCIPassportFactory((Object)"Passport f\u00fcr Kontoauszugs-Demo");
        HBCIRunnable runnable = new HBCIRunnable(properties, callback, passportFactory){

            @Override
            protected void execute() throws Exception {
                AnalyzeReportOfTransactions.analyzeReportOfTransactions(this.passport, this.handler);
            }
        };
        executor.submit(runnable);
        executor.shutdown();
        while (!executor.isTerminated()) {
            executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        HBCIUtils.done();
    }

    private static void analyzeReportOfTransactions(HBCIPassport hbciPassport, HBCIHandler hbciHandle) {
        Konto myaccount = hbciPassport.getAccounts()[0];
        HBCIJob auszug = hbciHandle.newJob("KUmsAll");
        auszug.setParam("my", myaccount);
        auszug.addToQueue();
        HBCIExecStatus ret = hbciHandle.execute();
        GVRKUms result = (GVRKUms)auszug.getJobResult();
        if (result.isOK()) {
            System.out.println(result.toString());
            List<GVRKUms.UmsLine> lines = result.getFlatData();
            for (GVRKUms.UmsLine entry : lines) {
                List<String> usages = entry.usage;
                for (String usageline : usages) {
                    if (!usageline.equals("Rechnung 12345")) continue;
                }
            }
        } else {
            System.out.println("Job-Error");
            System.out.println(result.getJobStatus().getErrorString());
            System.out.println("Global Error");
            System.out.println(ret.getErrorString());
        }
    }

    private static class MyHBCICallback
    extends HBCICallbackConsole {
        private MyHBCICallback() {
        }

        @Override
        public void callback(HBCIPassport passport, int reason, String msg, int dataType, StringBuffer retData) {
            System.out.println("Callback f\u00fcr folgendes Passport: " + passport.getClientData("init").toString());
            super.callback(passport, reason, msg, dataType, retData);
        }
    }
}

